/*
 * Decompiled with CFR 0.152.
 */
package org.spin.node.dataaccess.types;

import java.io.IOException;
import java.util.Date;
import javax.persistence.AttributeOverride;
import javax.persistence.AttributeOverrides;
import javax.persistence.Column;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.log4j.Logger;
import org.spin.node.dataaccess.transform.TypeConversionException;
import org.spin.node.dataaccess.types.LogEntryPK;
import org.spin.node.dataaccess.types.properties.PrimaryKey;
import org.spin.query.message.headers.QueryInfo;
import org.spin.tools.NetworkTime;
import org.spin.tools.RandomTool;
import org.spin.tools.config.QueryStatus;
import org.spin.tools.crypto.signature.CertID;
import org.spin.tools.crypto.signature.Identity;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="LogEntry")
@XmlRootElement
@Entity
public class LogEntry
implements PrimaryKey<LogEntryPK> {
    private static final Logger log = Logger.getLogger(LogEntry.class);
    private static final BASE64Encoder encoder = new BASE64Encoder();
    private static final BASE64Decoder decoder = new BASE64Decoder();
    protected static final int maxStringColumnLength = 30000;
    @Id
    @Embedded
    @Column(nullable=false)
    @XmlElement(required=true)
    private LogEntryPK primaryKey;
    @Column(nullable=true, length=30000)
    @XmlElement(required=false)
    private String queryType;
    @Column(nullable=false, length=30000)
    @XmlElement(required=true)
    private String username;
    @Column(nullable=false, length=30000)
    @XmlElement(required=true)
    private String role;
    @Column(nullable=false, length=30000)
    @XmlElement(required=true)
    private String domain;
    @Column(nullable=true)
    @XmlElement(required=true)
    @Embedded
    @AttributeOverrides(value={@AttributeOverride(name="certSerial", column=@Column(name="authenticatorKeyID")), @AttributeOverride(name="certName", column=@Column(name="authenticatorName", length=254))})
    private CertID authenticator;
    @Column(nullable=true)
    @Temporal(value=TemporalType.TIMESTAMP)
    @XmlElement(required=true)
    private Date authenticatedTime;
    @Column(nullable=true, length=30000)
    @XmlElement(required=true)
    private String digitalSignature;
    @Column(nullable=false)
    @XmlElement(required=false)
    private Boolean valid;
    @Column(nullable=false, length=30000)
    @XmlElement(required=true)
    private String queryCriteria;
    @Column(nullable=false)
    @Temporal(value=TemporalType.TIMESTAMP)
    @XmlElement(required=true)
    private Date receivedDate;
    @Column(nullable=true)
    @Temporal(value=TemporalType.TIMESTAMP)
    @XmlElement(required=false)
    private Date completedDate;
    @Column(nullable=true)
    @XmlElement(required=false)
    private QueryStatus completionStatus;

    public LogEntry() {
        this(null, LogEntry.makeDummyQueryInfo(), null, false);
    }

    private static final QueryInfo makeDummyQueryInfo() {
        return new QueryInfo(RandomTool.randomString(), new Identity(), null);
    }

    public LogEntry(CertID nodeID, QueryInfo queryInfo, String queryCriteria, boolean valid) {
        Identity identity = queryInfo.getIdentity();
        this.primaryKey = new LogEntryPK(nodeID, queryInfo.getQueryID());
        this.queryType = LogEntry.truncateIfNecessary(queryInfo.getQueryType(), "Query type was too long");
        this.username = LogEntry.truncateIfNecessary(identity.getUsername(), "user name was too long");
        this.domain = LogEntry.truncateIfNecessary(identity.getDomain(), "Domain was too long");
        this.role = identity.getAssertion().size() > 0 ? LogEntry.truncateIfNecessary((String)identity.getAssertion().get(0), "Role/Assertion was too long") : "unknown";
        if (identity.getSignature() == null) {
            this.authenticator = null;
            this.authenticatedTime = null;
            this.digitalSignature = null;
        } else {
            this.authenticator = LogEntry.truncateIfNecessary(identity.getSignature().getKeyInfo() != null ? identity.getSignature().getKeyInfo().getCertData().getCertID() : null, "Authenticator CertID name was too long");
            this.authenticatedTime = identity.getTimestamp() != null ? new NetworkTime(identity.getTimestamp()).toCalendar().getTime() : null;
            this.digitalSignature = LogEntry.truncateIfNecessary(LogEntry.getString(identity.getSignature().getSignatureValue().getValue()), "digitalSignature is too long");
        }
        this.valid = valid;
        this.queryCriteria = LogEntry.truncateIfNecessary(queryCriteria, "queryCriteria is too long");
        this.receivedDate = new Date();
    }

    protected static final CertID truncateIfNecessary(CertID certID) {
        return LogEntry.truncateIfNecessary(certID, null);
    }

    protected static final CertID truncateIfNecessary(CertID certID, String message) {
        if (certID == null) {
            return null;
        }
        if (certID.getName().length() > 30000) {
            return new CertID(certID.getSerial(), LogEntry.truncateIfNecessary(certID.getName(), message));
        }
        return certID;
    }

    protected static final String truncateIfNecessary(String s) {
        return LogEntry.truncateIfNecessary(s, null);
    }

    protected static final String truncateIfNecessary(String s, String message) {
        if (s == null) {
            return null;
        }
        if (s.length() > 30000) {
            log.warn((Object)("Truncating String log data longer than 30000 characters: " + (message == null ? "" : message)));
            return s.substring(0, 30000);
        }
        return s;
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + (this.primaryKey == null ? 0 : this.primaryKey.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LogEntry other = (LogEntry)obj;
        return !(this.primaryKey == null ? other.primaryKey != null : !this.primaryKey.equals(other.primaryKey));
    }

    private boolean equals(Date date1, Date date2) {
        if (date1 == null) {
            return date2 == null;
        }
        if (date2 == null) {
            return false;
        }
        long ms = Math.abs(date1.getTime() - date2.getTime());
        return ms < 1000L;
    }

    public boolean deepEquals(LogEntry other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (this.primaryKey == null ? other.primaryKey != null : !this.primaryKey.equals(other.primaryKey)) {
            return false;
        }
        if (this.authenticator == null ? other.authenticator != null : !this.authenticator.equals((Object)other.authenticator)) {
            return false;
        }
        if (this.digitalSignature == null ? other.digitalSignature != null : !this.digitalSignature.equals(other.digitalSignature)) {
            return false;
        }
        if (this.domain == null ? other.domain != null : !this.domain.equals(other.domain)) {
            return false;
        }
        if (this.queryCriteria == null ? other.queryCriteria != null : !this.queryCriteria.equals(other.queryCriteria)) {
            return false;
        }
        if (this.queryType == null ? other.queryType != null : !this.queryType.equals(other.queryType)) {
            return false;
        }
        if (this.role == null ? other.role != null : !this.role.equals(other.role)) {
            return false;
        }
        if (this.username == null ? other.username != null : !this.username.equals(other.username)) {
            return false;
        }
        if (this.valid == null ? other.valid != null : !this.valid.equals(other.valid)) {
            return false;
        }
        if (this.completionStatus == null ? other.completionStatus != null : this.completionStatus != other.completionStatus) {
            return false;
        }
        if (!this.equals(this.authenticatedTime, other.authenticatedTime)) {
            return false;
        }
        if (!this.equals(this.receivedDate, other.receivedDate)) {
            return false;
        }
        return this.equals(this.completedDate, other.completedDate);
    }

    public final CertID getAuthenticator() {
        return this.authenticator;
    }

    public final void setAuthenticator(CertID authenticatedBy) {
        this.authenticator = authenticatedBy;
    }

    public final Date getAuthenticatedTime() {
        return this.authenticatedTime;
    }

    public final void setAuthenticatedTime(Date authenticatedTime) {
        this.authenticatedTime = authenticatedTime;
    }

    public final String getDigitalSignature() {
        return this.digitalSignature;
    }

    public final Date getReceivedDate() {
        return this.receivedDate;
    }

    public final void setReceivedDate(Date receivedDate) {
        this.receivedDate = receivedDate;
    }

    public final String getDomain() {
        return this.domain;
    }

    public final String getQueryCriteria() {
        return this.queryCriteria;
    }

    public final String getQueryID() {
        return this.primaryKey.getQueryID();
    }

    public final String getRole() {
        return this.role;
    }

    public final String getUsername() {
        return this.username;
    }

    public final Boolean getValid() {
        return this.valid;
    }

    public final void setValid(Boolean valid) {
        this.valid = valid;
    }

    public Date getCompletedDate() {
        return this.completedDate;
    }

    public void setCompletedDate(Date completedDate) {
        this.completedDate = completedDate;
    }

    public QueryStatus getCompletionStatus() {
        return this.completionStatus;
    }

    public void setCompletionStatus(QueryStatus completionStatus) {
        this.completionStatus = completionStatus;
    }

    public final String getQueryType() {
        return this.queryType;
    }

    public final void setQueryType(String queryType) {
        this.queryType = queryType;
    }

    public CertID getNodeID() {
        return this.primaryKey.getNodeID();
    }

    @Override
    public LogEntryPK getPrimaryKey() {
        return this.primaryKey;
    }

    @Override
    public void setPrimaryKey(LogEntryPK primaryKey) {
        this.primaryKey = primaryKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final String getString(byte[] bytes) {
        if (bytes != null) {
            BASE64Encoder bASE64Encoder = encoder;
            synchronized (bASE64Encoder) {
                return encoder.encode(bytes);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final byte[] getBytes(String base64EncodedBytes) throws TypeConversionException {
        if (base64EncodedBytes != null) {
            try {
                BASE64Decoder bASE64Decoder = decoder;
                synchronized (bASE64Decoder) {
                    return decoder.decodeBuffer(base64EncodedBytes);
                }
            }
            catch (IOException e) {
                throw new TypeConversionException(e);
            }
        }
        return null;
    }

    public String toString() {
        return "[LogEntry: " + this.primaryKey.getQueryID() + " " + this.queryType + " " + this.username + " " + this.role + " " + this.domain + " " + this.receivedDate + "]";
    }
}

