/*
 * Decompiled with CFR 0.152.
 */
package org.spin.node.dataaccess.types;

import java.io.Serializable;
import javax.persistence.AttributeOverride;
import javax.persistence.AttributeOverrides;
import javax.persistence.Column;
import javax.persistence.Embeddable;
import javax.persistence.Embedded;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.spin.node.dataaccess.types.LogEntry;
import org.spin.node.dataaccess.types.properties.NodeID;
import org.spin.node.dataaccess.types.properties.QueryID;
import org.spin.tools.crypto.signature.CertID;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="LogEntryPK", propOrder={"nodeID", "queryID"})
@XmlRootElement
@Embeddable
public class LogEntryPK
implements Serializable,
NodeID<CertID>,
QueryID<String> {
    private static final long serialVersionUID = 1L;
    @XmlElement(required=true)
    @Embedded
    @AttributeOverrides(value={@AttributeOverride(name="certSerial", column=@Column(name="nodeKeyID")), @AttributeOverride(name="certName", column=@Column(name="nodeKeyName", length=254))})
    private CertID nodeID;
    @XmlElement(required=true)
    @Column(nullable=false, length=254)
    private String queryID;

    public LogEntryPK() {
    }

    public LogEntryPK(CertID nodeID, String queryID) {
        this.nodeID = LogEntry.truncateIfNecessary(nodeID, "Node ID name was too long");
        this.queryID = LogEntry.truncateIfNecessary(queryID, "Query ID was too long");
    }

    @Override
    public CertID getNodeID() {
        return this.nodeID;
    }

    @Override
    public String getQueryID() {
        return this.queryID;
    }

    @Override
    public void setNodeID(CertID nodeID) {
        this.nodeID = nodeID;
    }

    @Override
    public void setQueryID(String queryID) {
        this.queryID = queryID;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.nodeID == null ? 0 : this.nodeID.hashCode());
        result = 31 * result + (this.queryID == null ? 0 : this.queryID.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LogEntryPK other = (LogEntryPK)obj;
        if (this.nodeID == null ? other.nodeID != null : !this.nodeID.equals((Object)other.nodeID)) {
            return false;
        }
        return !(this.queryID == null ? other.queryID != null : !this.queryID.equals(other.queryID));
    }
}

