/*
 * Decompiled with CFR 0.152.
 */
package org.spin.query.message.headers;

import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.spin.tools.Util;
import org.spin.tools.config.EndpointConfig;
import org.spin.tools.crypto.signature.CertID;
import org.spin.tools.crypto.signature.Identity;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="QueryInfo")
@XmlRootElement
public class QueryInfo {
    @XmlElement(required=true)
    protected String queryID;
    @XmlElement(required=true)
    protected String peerGroup;
    @XmlElement(required=true)
    protected String queryType;
    @XmlElement(required=false)
    protected EndpointConfig aggregator;
    @XmlElement(required=false)
    protected final List<CertID> routedByNodes = Util.makeArrayList();
    @XmlElement(required=true)
    protected Identity identity;

    public QueryInfo() {
    }

    protected QueryInfo(QueryInfo other) {
        this.queryID = other.queryID;
        this.peerGroup = other.peerGroup;
        this.queryType = other.queryType;
        this.aggregator = other.aggregator;
        this.routedByNodes.addAll(other.routedByNodes);
        this.identity = Identity.copyOf((Identity)other.identity);
    }

    public static final QueryInfo copyOf(QueryInfo other) {
        Util.guardNotNull((Object)other);
        return new QueryInfo(other);
    }

    public QueryInfo(String peerGroup, Identity identity, String queryType) {
        this.peerGroup = peerGroup;
        this.queryType = queryType;
        this.identity = identity;
    }

    public QueryInfo(String peerGroup, Identity identity, String queryType, EndpointConfig aggregator) {
        this.peerGroup = peerGroup;
        this.queryType = queryType;
        this.identity = identity;
        this.aggregator = aggregator;
    }

    public QueryInfo(String peerGroup, Identity identity, String queryType, String queryID) {
        this.peerGroup = peerGroup;
        this.queryType = queryType;
        this.identity = identity;
        this.queryID = queryID;
    }

    public String getPeerGroup() {
        return this.peerGroup;
    }

    public void setPeerGroup(String peerGroup) {
        this.peerGroup = peerGroup;
    }

    public String getQueryID() {
        return this.queryID;
    }

    public void setQueryID(String queryID) {
        this.queryID = queryID;
    }

    public String getQueryType() {
        return this.queryType;
    }

    public void setQueryType(String queryType) {
        this.queryType = queryType;
    }

    public List<CertID> getRoutedByNodes() {
        return this.routedByNodes;
    }

    public EndpointConfig getAggregator() {
        return this.aggregator;
    }

    public void setAggregator(EndpointConfig aggregator) {
        this.aggregator = aggregator;
    }

    public Identity getIdentity() {
        return this.identity;
    }

    public void setIdentity(Identity identity) {
        this.identity = identity;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.aggregator == null ? 0 : this.aggregator.hashCode());
        result = 31 * result + (this.identity == null ? 0 : this.identity.hashCode());
        result = 31 * result + (this.peerGroup == null ? 0 : this.peerGroup.hashCode());
        result = 31 * result + (this.queryID == null ? 0 : this.queryID.hashCode());
        result = 31 * result + (this.queryType == null ? 0 : this.queryType.hashCode());
        result = 31 * result + (this.routedByNodes == null ? 0 : ((Object)this.routedByNodes).hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        QueryInfo other = (QueryInfo)obj;
        if (this.aggregator == null ? other.aggregator != null : !this.aggregator.equals((Object)other.aggregator)) {
            return false;
        }
        if (this.identity == null ? other.identity != null : !this.identity.equals((Object)other.identity)) {
            return false;
        }
        if (this.peerGroup == null ? other.peerGroup != null : !this.peerGroup.equals(other.peerGroup)) {
            return false;
        }
        if (this.queryID == null ? other.queryID != null : !this.queryID.equals(other.queryID)) {
            return false;
        }
        if (this.queryType == null ? other.queryType != null : !this.queryType.equals(other.queryType)) {
            return false;
        }
        return !(this.routedByNodes == null ? other.routedByNodes != null : !((Object)this.routedByNodes).equals(other.routedByNodes));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        String CRLF = System.getProperty("line.separator");
        sb.append(" PeerGroup: ").append(this.getPeerGroup());
        sb.append(CRLF);
        sb.append(" QueryId: ").append(this.getQueryID());
        sb.append(CRLF);
        sb.append(" QueryType: ").append(this.getQueryType());
        sb.append(CRLF);
        sb.append(" Identity: ").append(this.getIdentity());
        sb.append(CRLF);
        sb.append(" Aggregator: ").append(this.getAggregator());
        sb.append(CRLF);
        sb.append(" Routed by: ");
        for (CertID node : this.getRoutedByNodes()) {
            sb.append(CRLF);
            sb.append(node);
        }
        return sb.toString();
    }
}

