/*
 * Decompiled with CFR 0.152.
 */
package org.spin.tools;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.log4j.Logger;
import org.spin.tools.DynamicLoadingException;
import org.spin.tools.Util;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ClassTools {
    private static final Logger log = Logger.getLogger(ClassTools.class);
    private static final boolean DEBUG = log.isDebugEnabled();

    public static final <T> T createInstance(Class<T> clazz) throws DynamicLoadingException {
        try {
            return clazz.newInstance();
        }
        catch (Exception e) {
            throw new DynamicLoadingException("Error instantiating class '" + clazz.getName() + "':", e);
        }
    }

    public static final <T> T createInstance(String className, Class<T> classToCastInto) throws DynamicLoadingException {
        if (DEBUG) {
            log.debug((Object)("Loading '" + className + "', casting into '" + classToCastInto.getSimpleName() + "'"));
        }
        try {
            return classToCastInto.cast(Class.forName(className).newInstance());
        }
        catch (Exception e) {
            throw new DynamicLoadingException("Error instantiating class '" + className + "':", e);
        }
    }

    public static final <T> T createInstance(String className, Class<T> classToCastInto, Node config) throws DynamicLoadingException {
        return ClassTools.createInstance(className, classToCastInto, new Class[]{Node.class}, new Object[]{config});
    }

    public static final <T> T createInstance(Class<T> clazz, Class<?>[] constructorParamTypes, Object[] constructorParams) throws DynamicLoadingException {
        return ClassTools.createInstance(clazz.getName(), clazz, constructorParamTypes, constructorParams);
    }

    public static final <T> T createInstance(String className, Class<T> classToCastInto, Class<?>[] constructorParamTypes, Object[] constructorParams) throws DynamicLoadingException {
        if (DEBUG) {
            log.debug((Object)("Loading '" + className + "', casting into '" + classToCastInto.getSimpleName() + "'"));
        }
        try {
            Constructor<?> constructor = Class.forName(className).getConstructor(constructorParamTypes);
            return classToCastInto.cast(constructor.newInstance(constructorParams));
        }
        catch (Exception e) {
            throw new DynamicLoadingException("Error instantiating class '" + className + "':", e);
        }
    }

    @Deprecated
    public static <T> ArrayList<T> makeArrayList() {
        return Util.makeArrayList();
    }

    @Deprecated
    public static <T> ArrayList<T> makeArrayList(Collection<? extends T> collection) {
        return Util.makeArrayList(collection);
    }

    @Deprecated
    public static <T> ArrayList<T> makeArrayList(T ... values) {
        return Util.makeArrayList(values);
    }

    @Deprecated
    public static <T> ArrayList<T> makeArrayList(int initialCapacity) {
        return Util.makeArrayList(initialCapacity);
    }

    @Deprecated
    public static <T> LinkedList<T> makeLinkedList() {
        return Util.makeLinkedList();
    }

    @Deprecated
    public static <K, V> HashMap<K, V> makeHashMap() {
        return Util.makeHashMap();
    }

    @Deprecated
    public static <K extends Enum<K>, V> HashMap<K, V> makeEnumMap() {
        return Util.makeEnumMap();
    }

    @Deprecated
    public static <K, V> TreeMap<K, V> makeTreeMap() {
        return Util.makeTreeMap();
    }

    @Deprecated
    public static <T> TreeSet<T> makeTreeSet() {
        return Util.makeTreeSet();
    }

    @Deprecated
    public static <T> HashSet<T> makeHashSet() {
        return Util.makeHashSet();
    }

    @Deprecated
    public static <T> Set<T> asSet(T ... values) {
        return Util.asSet(values);
    }

    @Deprecated
    public static <T> Set<T> asSet(Collection<T> values) {
        return Util.asSet(values);
    }

    @Deprecated
    public static <T> T[] asArray(T ... values) {
        return Util.asArray(values);
    }

    @Deprecated
    public static <T> List<T> asList(Set<T> values) {
        return Util.asList(values);
    }

    public static final boolean allSamePackage(Class<?> ... classes) {
        if (classes == null || classes.length < 1) {
            return false;
        }
        if (classes.length == 1) {
            return true;
        }
        String packageName = classes[0].getPackage().getName();
        for (int i = 1; i < classes.length; ++i) {
            if (classes[i].getPackage().getName().equals(packageName)) continue;
            return false;
        }
        return true;
    }

    @Deprecated
    public static <K, V> boolean mapsAreEqual(Map<K, V> lhs, Map<K, V> rhs) {
        return Util.mapsAreEqual(lhs, rhs);
    }

    @Deprecated
    public static final Util.Range range(int max) {
        return Util.range(max);
    }

    @Deprecated
    public static final Util.Range range(int min, int max) {
        return Util.range(min, max);
    }
}

