/*
 * Decompiled with CFR 0.152.
 */
package org.spin.tools;

import com.sun.net.ssl.internal.ssl.Provider;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.net.URL;
import java.security.InvalidKeyException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Security;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.Map;
import java.util.Set;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import org.apache.log4j.Logger;
import org.spin.tools.Util;
import org.spin.tools.config.ConfigException;
import org.spin.tools.config.ConfigTool;
import org.spin.tools.config.KeyStoreConfig;
import org.spin.tools.crypto.CryptoException;
import org.spin.tools.crypto.PKCryptor;
import org.spin.tools.crypto.signature.CertData;
import org.spin.tools.crypto.signature.CertID;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PKITool {
    public static final String certificateFormat = "X.509";
    public static final String publicKeyAlgorithm = "RSA";
    public static final String signatureAlgorithm = "SHA1withRSA";
    public static final String keystoreType = "JKS";
    private static final Logger log = Logger.getLogger(PKITool.class);
    private static final boolean DEBUG = log.isDebugEnabled();
    private static final boolean INFO = log.isInfoEnabled();
    private static final BASE64Encoder encoder = new BASE64Encoder();
    private static final BASE64Decoder decoder = new BASE64Decoder();
    private static PKITool instance;
    private final KeyStoreConfig config;
    private final KeyStore keystore;
    private final CertificateFactory certFactory;
    private final Map<BigInteger, CertData> x509KeyInfoMap = Util.makeHashMap();
    private final CertData myX509;
    private final PrivateKey myPrivateKey;
    private final PublicKey myPublicKey;

    public static synchronized PKITool getInstance() throws ConfigException {
        if (instance == null) {
            if (DEBUG) {
                log.debug((Object)"instance == null");
            }
            instance = PKITool.getInstance(ConfigTool.loadKeyStoreConfig());
        }
        return instance;
    }

    public static synchronized PKITool getInstance(KeyStoreConfig keyStoreConfig) throws ConfigException {
        if (instance == null) {
            if (DEBUG) {
                log.debug((Object)"getInstance(...) == null");
            }
        } else {
            throw new ConfigException("Are you attempting to reload the application wide keystore? ");
        }
        instance = new PKITool(keyStoreConfig);
        return instance;
    }

    private static final URL getKeyStoreURL(KeyStoreConfig keyStoreConfig) throws ConfigException {
        if (keyStoreConfig.getFile() == null) {
            throw new ConfigException("KeyStoreConfig has null File property");
        }
        URL result = ConfigTool.getConfigFileAsURL(keyStoreConfig.getFile().getPath());
        if (INFO) {
            log.info((Object)("KeyStore URL: " + result));
        }
        return result;
    }

    private static final InputStream getKeyStoreStream(KeyStoreConfig keyStoreConfig) throws ConfigException {
        try {
            return PKITool.getKeyStoreURL(keyStoreConfig).openStream();
        }
        catch (IOException e) {
            throw new ConfigException("Error getting keystore stream", e);
        }
    }

    private PKITool(KeyStoreConfig config) throws ConfigException {
        if (DEBUG) {
            log.debug((Object)"Initializing Keystore");
        }
        try {
            this.config = config;
            this.certFactory = CertificateFactory.getInstance(certificateFormat);
            this.keystore = KeyStore.getInstance(keystoreType);
            this.keystore.load(PKITool.getKeyStoreStream(config), config.getPasswordAsCharArray());
            KeyPair keyPair = PKITool.determineKeyPair(this.keystore, config);
            this.myX509 = keyPair.x509Data;
            this.myPrivateKey = keyPair.privateKey;
            this.myPublicKey = keyPair.publicKey;
            this.fillKeyInfoMap();
            if (config.isSetSystemProperties()) {
                Workarounds.setSystemProperties(config);
            }
            this.debug();
        }
        catch (Exception e) {
            throw new ConfigException("Error initializing PKITool", e);
        }
    }

    private void fillKeyInfoMap() throws CryptoException {
        this.x509KeyInfoMap.clear();
        try {
            for (String alias : Util.iterable(this.keystore.aliases())) {
                X509Certificate cert = this.getCertificate(alias);
                CertData x509Data = PKITool.getX509Data(cert);
                this.x509KeyInfoMap.put(x509Data.getCertID().getSerial(), x509Data);
            }
        }
        catch (CryptoException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CryptoException(e);
        }
    }

    private X509Certificate getCertificate(String alias) throws KeyStoreException {
        return (X509Certificate)this.keystore.getCertificate(alias);
    }

    private static final KeyPair determineKeyPair(KeyStore keystore, KeyStoreConfig config) throws CryptoException {
        Util.guardNotNull(keystore);
        Util.guardNotNull(config);
        int numKeyPairs = PKITool.countKeyPairs(keystore);
        if (numKeyPairs == 0) {
            throw new CryptoException("At least one public/private key pair is required.");
        }
        if (numKeyPairs == 1) {
            try {
                for (String alias : Util.iterable(keystore.aliases())) {
                    if (!keystore.isKeyEntry(alias)) continue;
                    return PKITool.getKeyPair(keystore, config, alias);
                }
            }
            catch (CryptoException e) {
                throw e;
            }
            catch (Exception e) {
                throw new CryptoException(e);
            }
            throw new CryptoException("At least one public/private key pair is required.");
        }
        if (config.getKeyAlias() == null) {
            throw new CryptoException("There are " + numKeyPairs + " keypairs in " + config.getFile() + ".  Set the keyAlias property in keystore.xml to specify which keypair to use");
        }
        return PKITool.getKeyPair(keystore, config, config.getKeyAlias());
    }

    private static final int countKeyPairs(KeyStore keystore) throws CryptoException {
        int count = 0;
        try {
            for (String alias : Util.iterable(keystore.aliases())) {
                if (!keystore.isKeyEntry(alias)) continue;
                ++count;
            }
        }
        catch (Exception e) {
            throw new CryptoException(e);
        }
        return count;
    }

    private static final KeyPair getKeyPair(KeyStore keystore, KeyStoreConfig config, String alias) throws CryptoException {
        try {
            X509Certificate cert = (X509Certificate)keystore.getCertificate(alias);
            CertData myX509 = PKITool.getX509Data(cert);
            PrivateKey myPrivateKey = (PrivateKey)keystore.getKey(alias, config.getPasswordAsCharArray());
            PublicKey myPublicKey = cert.getPublicKey();
            return new KeyPair(myX509, myPrivateKey, myPublicKey);
        }
        catch (CryptoException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CryptoException(e);
        }
    }

    public KeyStoreConfig getConfig() {
        return this.config;
    }

    public PrivateKey getMyPrivateKey() {
        return this.myPrivateKey;
    }

    public PublicKey getMyPublicKey() throws KeyStoreException {
        return this.myPublicKey;
    }

    public CertData getMyX509() {
        return this.myX509;
    }

    public CertID getMyCertID() {
        return this.myX509.getCertID();
    }

    public static CertData getX509Data(X509Certificate cert) throws CryptoException {
        try {
            return new CertData(new CertID(cert), cert.getEncoded());
        }
        catch (CertificateEncodingException e) {
            throw new CryptoException("Could not read encoded bytes for x509 cert", e);
        }
    }

    public Set<BigInteger> getSerialNumbersCopy() {
        return Util.asSet(this.x509KeyInfoMap.keySet());
    }

    public Set<CertData> getImportedCertsCopy() {
        return Util.asSet(this.x509KeyInfoMap.values());
    }

    public boolean containsX509Certificate(CertID serial) {
        return this.containsX509Certificate(serial.getSerial());
    }

    public boolean containsX509Certificate(BigInteger serial) {
        return this.x509KeyInfoMap.containsKey(serial);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addX509Certificate(X509Certificate cert) throws CryptoException {
        if (cert == null) {
            throw new CryptoException("Null certificate passed in");
        }
        Map<BigInteger, CertData> map = this.x509KeyInfoMap;
        synchronized (map) {
            CertData x509 = PKITool.getX509Data(cert);
            this.x509KeyInfoMap.put(x509.getCertID().getSerial(), x509);
        }
    }

    public void addX509Certificate(byte[] encodedInput) throws CryptoException {
        this.addX509Certificate(this.getX509Certificate(encodedInput));
    }

    public void addX509Certificate(InputStream encodedInput) throws CryptoException {
        if (encodedInput == null) {
            throw new CryptoException("Null InputStream passed in");
        }
        try {
            this.addX509Certificate((X509Certificate)this.certFactory.generateCertificate(encodedInput));
        }
        catch (Exception e) {
            throw new CryptoException("Error decoding certificate.  Is it an X.509 cert in the DER encoding?", e);
        }
    }

    public X509Certificate getX509Certificate(CertData x509) throws CryptoException {
        return this.getX509Certificate(x509.getCertID().getSerial());
    }

    public X509Certificate getX509Certificate(CertID x509Serial) throws CryptoException {
        return this.getX509Certificate(x509Serial.getSerial());
    }

    public X509Certificate getX509Certificate(BigInteger serial) throws CryptoException {
        return this.getX509Certificate(this.x509KeyInfoMap.get(serial).getX509Certificate());
    }

    public X509Certificate getX509Certificate(byte[] encoded) throws CryptoException {
        try {
            return (X509Certificate)this.certFactory.generateCertificate(new ByteArrayInputStream(encoded));
        }
        catch (CertificateException e) {
            throw new CryptoException("Could not get x509 cert from encoded bytes[]");
        }
    }

    public X509Certificate removeX509Certificate(CertData x509) throws CryptoException, CertificateException {
        return this.removeX509Certificate(x509.getCertID());
    }

    public X509Certificate removeX509Certificate(CertID x509serial) throws CryptoException, CertificateException {
        return this.removeX509Certificate(x509serial.getSerial());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public X509Certificate removeX509Certificate(BigInteger x509serial) throws CryptoException, CertificateException {
        if (x509serial == null) {
            throw new CryptoException("Null x509Serial passed in.");
        }
        Map<BigInteger, CertData> map = this.x509KeyInfoMap;
        synchronized (map) {
            return this.getX509Certificate(this.x509KeyInfoMap.remove(x509serial).getX509Certificate());
        }
    }

    public PublicKey getPublicKey(BigInteger x509Serial) throws CryptoException {
        if (!this.x509KeyInfoMap.containsKey(x509Serial)) {
            throw new CryptoException("No entry found for x509Serial " + x509Serial);
        }
        return this.getX509Certificate(this.x509KeyInfoMap.get(x509Serial)).getPublicKey();
    }

    private static final Cipher getPublicKeyCipher() throws NoSuchAlgorithmException, NoSuchPaddingException {
        return Cipher.getInstance(publicKeyAlgorithm);
    }

    private static final Signature getSignerVerifier() throws NoSuchAlgorithmException {
        return Signature.getInstance(signatureAlgorithm);
    }

    public byte[] sign(String challenge) throws SignatureException {
        return this.sign(challenge.getBytes());
    }

    public byte[] sign(byte[] challenge) throws SignatureException {
        try {
            Signature signerVerifier = PKITool.getSignerVerifier();
            signerVerifier.initSign(this.myPrivateKey);
            signerVerifier.update(challenge);
            return signerVerifier.sign();
        }
        catch (Exception e) {
            throw new SignatureException("Invalid key, failed to sign challenge " + new String(challenge), e);
        }
    }

    public boolean verifySignature(String challenge, byte[] signature) throws SignatureException {
        return this.verifySignature(challenge.getBytes(), signature);
    }

    public boolean verifySignature(String challenge, byte[] signature, CertData signerKeyInfo) throws SignatureException {
        return this.verifySignature(challenge, signature, signerKeyInfo.getCertID());
    }

    public boolean verifySignature(String challenge, byte[] signature, CertID x509Serial) throws SignatureException {
        return this.verifySignature(challenge, signature, x509Serial.getSerial());
    }

    public boolean verifySignature(String challenge, byte[] signature, BigInteger signerSerial) throws SignatureException {
        return this.verifySignature(challenge.getBytes(), signature, signerSerial);
    }

    public boolean verifySignature(byte[] challenge, byte[] signature) throws SignatureException {
        return this.verifySignature(challenge, signature, this.myX509.getCertID().getSerial());
    }

    public boolean verifySignature(byte[] challenge, byte[] signature, CertData signerX509) throws SignatureException {
        return this.verifySignature(challenge, signature, signerX509.getCertID().getSerial());
    }

    public boolean verifySignature(byte[] challenge, byte[] signature, CertID signedBy) throws SignatureException {
        return this.verifySignature(challenge, signature, signedBy.getSerial());
    }

    public boolean verifySignature(byte[] challenge, byte[] signature, BigInteger signerSerial) throws SignatureException {
        if (challenge == null || signature == null || signerSerial == null) {
            throw new SignatureException("Invalid input:  Verifying signature, signer: " + signerSerial + " challenge: '" + challenge + "' signature: '" + signature + "'");
        }
        try {
            if (DEBUG) {
                log.debug((Object)("Verifying signature, signer: " + signerSerial + " challenge: '" + challenge + "' signature: '" + signature + "'"));
            }
            if (!this.containsX509Certificate(signerSerial)) {
                throw new SignatureException("No certificate found for signer key ID " + signerSerial);
            }
            X509Certificate signerCert = this.getX509Certificate(signerSerial);
            if (DEBUG) {
                log.debug((Object)("Signer keyID: " + signerSerial));
                log.debug((Object)("Signer cert: " + signerCert.toString()));
            }
            Signature signerVerifier = PKITool.getSignerVerifier();
            signerVerifier.initVerify(signerCert);
            signerVerifier.update(challenge);
            boolean verified = signerVerifier.verify(signature);
            if (DEBUG) {
                log.debug((Object)("signature verified: " + verified));
            }
            return verified;
        }
        catch (CryptoException e) {
            throw new SignatureException("Failed to retrieve key for signer", e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new SignatureException("Bad signature algorithm, failed to verify challenge " + challenge, e);
        }
        catch (InvalidKeyException e) {
            throw new SignatureException("Invalid key, failed to verify challenge " + challenge, e);
        }
    }

    public byte[] encrypt(byte[] plainText, CertData x509) throws CryptoException {
        return this.encrypt(plainText, x509.getCertID());
    }

    public byte[] encrypt(byte[] plainText, CertID x509Serial) throws CryptoException {
        return this.encrypt(plainText, x509Serial.getSerial());
    }

    public byte[] encrypt(byte[] plainText, BigInteger x509Serial) throws CryptoException {
        try {
            return this.encrypt(plainText, this.getPublicKey(x509Serial));
        }
        catch (CryptoException e) {
            throw new CryptoException("Error encrypting using the provided key ", e);
        }
    }

    public byte[] encrypt(byte[] inpBytes, PublicKey key) throws CryptoException {
        try {
            Cipher myCipher = Cipher.getInstance(publicKeyAlgorithm);
            myCipher.init(1, key);
            return myCipher.doFinal(inpBytes);
        }
        catch (Exception e) {
            throw new CryptoException("Error encrypting: ", e);
        }
    }

    public byte[] decrypt(byte[] cipherText) throws CryptoException {
        try {
            Cipher myCipher = PKITool.getPublicKeyCipher();
            myCipher.init(2, this.myPrivateKey);
            return myCipher.doFinal(cipherText);
        }
        catch (Exception e) {
            throw new CryptoException("Error decrypting: ", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static final String getString(byte[] bytes) {
        BASE64Encoder bASE64Encoder = encoder;
        synchronized (bASE64Encoder) {
            return encoder.encode(bytes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static final byte[] getBytes(String input) throws IOException {
        BASE64Decoder bASE64Decoder = decoder;
        synchronized (bASE64Decoder) {
            return decoder.decodeBuffer(input);
        }
    }

    public final PKCryptor cryptor() {
        return new PKCryptor(this);
    }

    public final void debug() throws KeyStoreException {
        if (DEBUG) {
            log.debug((Object)("Keystore Type: " + this.keystore.getType()));
            log.debug((Object)"Public-key crypto Algorithm: RSA");
            log.debug((Object)"Signature Algorithm: SHA1withRSA");
            log.debug((Object)this.config);
            log.debug((Object)"Key Aliases:");
            Enumeration<String> aliases = this.keystore.aliases();
            while (aliases.hasMoreElements()) {
                log.debug((Object)("\t" + aliases.nextElement()));
            }
            log.debug((Object)"Key IDs:");
            for (CertData x509Serial : this.x509KeyInfoMap.values()) {
                log.debug((Object)x509Serial.getCertID());
            }
            if (INFO) {
                log.info((Object)("Private Key ID: " + this.myX509));
            }
        }
    }

    @Deprecated
    public static final synchronized void setSystemProperties() {
        try {
            Workarounds.setSystemProperties(PKITool.getInstance().getConfig());
        }
        catch (ConfigException e) {
            throw new IllegalStateException("Error loading key store config", e);
        }
    }

    public static final class Workarounds {
        private static boolean systemPropertiesHaveBeenSet = false;

        private Workarounds() {
        }

        public static final synchronized void setSystemProperties() throws ConfigException {
            Workarounds.setSystemProperties(ConfigTool.loadKeyStoreConfig());
        }

        public static final synchronized void setSystemProperties(KeyStoreConfig config) {
            if (DEBUG) {
                log.debug((Object)"setSystemProperties()");
            }
            if (!systemPropertiesHaveBeenSet) {
                if (INFO) {
                    log.info((Object)"Setting System properties for the first time. ");
                }
                try {
                    System.setProperty("javax.net.ssl.trustStore", Workarounds.getKeyStoreFileName(config));
                    if (DEBUG) {
                        log.debug((Object)("Set javax.net.ssl.trustStore to: " + System.getProperty("javax.net.ssl.trustStore")));
                    }
                    System.setProperty("javax.net.ssl.trustStorePassword", config.getPassword());
                    System.setProperty("java.protocol.handler.pkgs", "javax.net.ssl");
                    Security.addProvider((java.security.Provider)new Provider());
                }
                catch (Exception e) {
                    throw new RuntimeException("Error setting up keystore for SSL: ", e);
                }
                if (DEBUG) {
                    log.debug((Object)"Setting javax.net.debug HANDSHAKE to debug, this will generate a LOT of trace information");
                    System.setProperty("javax.net.debug", "ssl:handshake");
                }
                systemPropertiesHaveBeenSet = true;
            } else {
                log.warn((Object)"are you trying to reset system properties?");
            }
        }

        private static final String getKeyStoreFileName(KeyStoreConfig keyStoreConfig) throws ConfigException {
            return PKITool.getKeyStoreURL(keyStoreConfig).getFile();
        }
    }

    private static final class KeyPair {
        public final CertData x509Data;
        public final PrivateKey privateKey;
        public final PublicKey publicKey;

        public KeyPair(CertData myX509, PrivateKey myPrivateKey, PublicKey myPublicKey) {
            this.x509Data = myX509;
            this.privateKey = myPrivateKey;
            this.publicKey = myPublicKey;
        }
    }
}

