/*
 * Decompiled with CFR 0.152.
 */
package org.spin.tools;

import java.math.BigInteger;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import org.spin.tools.NetworkTime;
import org.spin.tools.Util;
import org.spin.tools.config.ConfigTool;
import org.spin.tools.config.EndpointConfig;
import org.spin.tools.config.EndpointType;
import org.spin.tools.crypto.signature.CertID;
import org.spin.tools.crypto.signature.Identity;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RandomTool {
    private static final Random random = new Random();

    private RandomTool() {
    }

    public static final String randomString() {
        return UUID.randomUUID().toString();
    }

    public static final String randomString(int howLong) {
        StringBuilder builder = new StringBuilder();
        for (int i : Util.range(howLong)) {
            builder.append(RandomTool.randomString());
        }
        return builder.toString();
    }

    public static final boolean randomBoolean() {
        return random.nextBoolean();
    }

    public static final double randomDouble() {
        return random.nextDouble();
    }

    public static final int randomInt() {
        return random.nextInt();
    }

    public static final int randomInt(int max) {
        return random.nextInt(max);
    }

    public static final int randomInt(int min, int max) {
        if (min >= max) {
            throw new IllegalArgumentException("max must be at least one greater than min");
        }
        return min + random.nextInt(max - min);
    }

    public static final <T> T randomEntry(List<T> list) {
        if (list.isEmpty()) {
            throw new IllegalArgumentException("Passed-in list must not be empty");
        }
        return list.get(Math.abs(RandomTool.randomInt() % list.size()));
    }

    public static final EndpointConfig randomEndpointConfig() {
        if (RandomTool.randomBoolean()) {
            return new EndpointConfig(EndpointType.Local, RandomTool.randomString());
        }
        return new EndpointConfig(EndpointType.SOAP, ConfigTool.buildURL(":443/node-server/node").toString());
    }

    public static NetworkTime randomNetworkTime() {
        return new NetworkTime(RandomTool.randomCalendar());
    }

    public static GregorianCalendar randomCalendar() {
        Random rand = RandomGenerator.value;
        return new GregorianCalendar(1950 + rand.nextInt(57), rand.nextInt(12), rand.nextInt(28));
    }

    public static UUID randomUUID() {
        return UUID.randomUUID();
    }

    public static char randomChar(char start, char end) {
        char result = (char)RandomTool.randomInt(start, end + '\u0001');
        if (RandomTool.randomBoolean()) {
            return Character.toUpperCase(result);
        }
        return result;
    }

    public static char randomChar() {
        return RandomTool.randomChar('a', 'z');
    }

    public static String randomMRN() {
        return "MRN" + RandomTool.randomString(3) + RandomTool.randomIntegerString(4);
    }

    public static String randomIntegerString(int numDigits) {
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < numDigits; ++i) {
            result.append(RandomTool.randomChar('0', '9'));
        }
        return result.toString();
    }

    public static String random4DigitZip() {
        return RandomTool.randomIntegerString(4);
    }

    public static String random6DigitZip() {
        return RandomTool.randomIntegerString(6);
    }

    public static String randomParagraph(int numSentences) {
        StringBuffer paragraph = new StringBuffer();
        for (int i = 0; i < numSentences; ++i) {
            paragraph.append(" ").append(RandomTool.randomSentence(RandomTool.randomInt(2, 30)));
        }
        return paragraph.toString();
    }

    public static String randomSentence(int maxWordLength) {
        StringBuffer sentence = new StringBuffer();
        for (int i = 0; i < RandomTool.randomInt(1, 20); ++i) {
            sentence.append(RandomTool.randomString(RandomTool.randomInt(1, maxWordLength)));
            sentence.append(" ");
            if (i % 3 == 0) {
                sentence.append("/");
            }
            if (i % 4 == 0) {
                sentence.append("-");
            }
            if (i % 5 == 0) {
                sentence.append(",");
            }
            if (i % 6 != 0) continue;
            sentence.append(":");
        }
        sentence.append(".");
        return sentence.toString();
    }

    public static final BigInteger randomBigInteger() {
        Integer numbits = RandomTool.randomInt(1, Integer.MAX_VALUE);
        return new BigInteger(numbits.toString());
    }

    public static final CertID randomCertID() {
        return new CertID(RandomTool.randomBigInteger(), RandomTool.randomString());
    }

    public static final Identity randomIdentity() {
        return RandomTool.randomIdentity("domain_" + RandomTool.randomString(), "user_" + RandomTool.randomString());
    }

    public static final Identity randomIdentity(String domain, String username) {
        Identity result = new Identity(domain, username);
        for (int i : Util.range(RandomTool.randomInt(1, 3))) {
            result.addAssertion("assertion_" + i + "_" + RandomTool.randomString());
        }
        return result;
    }

    private static final class RandomGenerator {
        private static final Random value = new Random();

        private RandomGenerator() {
        }
    }
}

