/*
 * Decompiled with CFR 0.152.
 */
package org.spin.tools.config;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.spin.tools.config.EndpointConfig;
import org.spin.tools.config.EndpointType;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="AgentConfig", namespace="http://spin.org/xml/res")
@XmlRootElement(name="AgentConfig", namespace="http://spin.org/xml/res")
public class AgentConfig {
    public static final float defaultPollingFrequency = 1.0f;
    @XmlElement(name="peerGroupToQuery", required=false)
    protected String peerGroupToQuery;
    @XmlElement(name="rootAggregatorEndpoint", required=true)
    protected EndpointConfig rootAggregatorEndpoint;
    @XmlElement(name="nodeConnectorEndpoint", required=true)
    protected EndpointConfig nodeConnectorEndpoint;
    @XmlElement(name="authEndpoint", required=false)
    protected EndpointConfig authEndpoint;
    @XmlElement(name="maxWaitTime", required=false)
    protected long maxWaitTime = 90000L;
    @XmlElement(name="pollingFrequency", required=false)
    protected Float pollingFrequency = Float.valueOf(1.0f);

    public boolean shouldUseRemoteCache() {
        return this.nodeConnectorEndpoint != null && this.nodeConnectorEndpoint.getEndpointType() != EndpointType.Local && this.nodeConnectorEndpoint.getAddress().length() > 0;
    }

    public EndpointConfig getRootAggregatorEndpoint() {
        return this.rootAggregatorEndpoint;
    }

    public void setRootAggregatorEndpoint(EndpointConfig aggregator) {
        this.rootAggregatorEndpoint = aggregator;
    }

    public String getPeerGroupToQuery() {
        return this.peerGroupToQuery;
    }

    public void setPeerGroupToQuery(String peerGroupToQuery) {
        this.peerGroupToQuery = peerGroupToQuery;
    }

    public EndpointConfig getAuthEndpoint() {
        return this.authEndpoint;
    }

    public void setAuthEndpoint(EndpointConfig authEndpoint) {
        this.authEndpoint = authEndpoint;
    }

    public final EndpointConfig getNodeConnectorEndpoint() {
        return this.nodeConnectorEndpoint;
    }

    public final void setNodeConnectorEndpoint(EndpointConfig cache) {
        this.nodeConnectorEndpoint = cache;
    }

    public final long getMaxWaitTime() {
        return this.maxWaitTime;
    }

    public final void setMaxWaitTime(long maxWaitTime) {
        this.maxWaitTime = maxWaitTime;
    }

    public final Float getPollingFrequency() {
        return this.pollingFrequency;
    }

    public final void setPollingFrequency(Float pollingFrequency) {
        if (pollingFrequency != null && pollingFrequency.floatValue() <= 0.0f) {
            throw new IllegalArgumentException("polling frequency must be > 0");
        }
        this.pollingFrequency = pollingFrequency;
    }

    public static AgentConfig makeMinimalAgentConfig(String peerGroupToQuery) {
        return AgentConfig.makeMinimalAgentConfig(peerGroupToQuery, null);
    }

    public static AgentConfig makeMinimalAgentConfig(String peerGroupToQuery, Long maxWaitTime) {
        AgentConfig result = new AgentConfig();
        result.setPeerGroupToQuery(peerGroupToQuery);
        if (maxWaitTime != null) {
            result.setMaxWaitTime(maxWaitTime);
        }
        return result;
    }

    public int hashCode() {
        int result = this.peerGroupToQuery != null ? this.peerGroupToQuery.hashCode() : 0;
        result = 31 * result + (this.rootAggregatorEndpoint != null ? this.rootAggregatorEndpoint.hashCode() : 0);
        result = 31 * result + (this.nodeConnectorEndpoint != null ? this.nodeConnectorEndpoint.hashCode() : 0);
        result = 31 * result + (this.authEndpoint != null ? this.authEndpoint.hashCode() : 0);
        result = 31 * result + (int)(this.maxWaitTime ^ this.maxWaitTime >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AgentConfig other = (AgentConfig)obj;
        if (this.rootAggregatorEndpoint == null ? other.rootAggregatorEndpoint != null : !this.rootAggregatorEndpoint.equals(other.rootAggregatorEndpoint)) {
            return false;
        }
        if (this.maxWaitTime != other.maxWaitTime) {
            return false;
        }
        if (this.peerGroupToQuery == null ? other.peerGroupToQuery != null : !this.peerGroupToQuery.equals(other.peerGroupToQuery)) {
            return false;
        }
        if (this.nodeConnectorEndpoint == null ? other.nodeConnectorEndpoint != null : !this.nodeConnectorEndpoint.equals(other.nodeConnectorEndpoint)) {
            return false;
        }
        return !(this.authEndpoint == null ? other.authEndpoint != null : !this.authEndpoint.equals(other.authEndpoint));
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        String CRLF = System.getProperty("line.separator");
        sb.append("PeerGroup:\t" + this.getPeerGroupToQuery());
        sb.append(CRLF);
        sb.append("NodeConnector:\t\t" + this.getNodeConnectorEndpoint());
        sb.append(CRLF);
        sb.append("Root Aggregator:\t" + this.getRootAggregatorEndpoint());
        sb.append(CRLF);
        sb.append("Auth:\t\t\t" + this.getAuthEndpoint());
        sb.append(CRLF);
        sb.append("Max Wait TTL:\t\t" + this.getMaxWaitTime());
        return sb.toString();
    }
}

