/*
 * Decompiled with CFR 0.152.
 */
package org.spin.tools.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import javax.xml.bind.JAXBException;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;
import org.spin.tools.FileUtils;
import org.spin.tools.JAXBUtils;
import org.spin.tools.config.AgentConfig;
import org.spin.tools.config.ConfigException;
import org.spin.tools.config.FileConfig;
import org.spin.tools.config.JDBCConfig;
import org.spin.tools.config.KeyStoreConfig;
import org.spin.tools.config.MailToolConfig;
import org.spin.tools.config.Module;
import org.spin.tools.config.NodeConfig;
import org.spin.tools.config.RoutingTableConfig;
import org.spin.tools.config.SPINRuntimeConfig;
import org.spin.tools.config.URLConfig;
import org.spin.tools.filter.FileFilterTool;
import org.spin.tools.filter.XMLFileFilter;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigTool {
    private static final Logger log = Logger.getLogger(ConfigTool.class);
    private static final boolean INFO = log.isInfoEnabled();
    private static final boolean DEBUG = log.isDebugEnabled();

    public static final void initLog4J() {
        String log4JConfigFileName = "log4j.properties";
        try {
            PropertyConfigurator.configure((Properties)ConfigTool.getProperties(ConfigTool.getConfigFileStream("log4j.properties")));
        }
        catch (Exception e) {
            log.warn((Object)"'log4j.properties' not found");
        }
    }

    private static final boolean shouldFallBackToClassloader(File desiredConfigFile) {
        return !desiredConfigFile.exists();
    }

    public static final InputStream getClasspathResource(String resourceName) {
        return ConfigTool.getClassLoader().getResourceAsStream(resourceName);
    }

    public static final URL getClasspathResourceAsURL(String resourceName) {
        return ConfigTool.getClassLoader().getResource(resourceName);
    }

    private static final ClassLoader getClassLoader() {
        return ConfigTool.class.getClassLoader();
    }

    public static final URL getConfigFileAsURL(String desiredFileName) throws ConfigException {
        File desiredFile = ConfigTool.getConfigFile(desiredFileName);
        if (ConfigTool.shouldFallBackToClassloader(desiredFile)) {
            URL result = ConfigTool.getClasspathResourceAsURL(desiredFileName);
            if (result == null) {
                throw new ConfigException(desiredFileName + " was not found on the classpath or file system.");
            }
            return result;
        }
        try {
            return desiredFile.toURL();
        }
        catch (MalformedURLException e) {
            throw new ConfigException(e);
        }
    }

    private static final String makeXMLFileName(String module) {
        return module + ".xml";
    }

    public static File getConfigFile(Module moduleName) throws ConfigException {
        return ConfigTool.getConfigFile(ConfigTool.makeXMLFileName(moduleName.name()));
    }

    public static File getConfigFile(String filename) throws ConfigException {
        File rawFile = new File(filename);
        if (rawFile.isAbsolute()) {
            return rawFile;
        }
        return new File(SPINRuntimeConfig.getAbsolutePath() + File.separator + filename);
    }

    public static File getConfigFileWithFailover(String filename) throws ConfigException {
        File file = ConfigTool.getConfigFile(filename);
        if (file.exists()) {
            if (DEBUG) {
                log.debug((Object)("Found " + filename + " absolute path= " + file.getAbsolutePath()));
            }
            return file;
        }
        URL classLoaderURL = ConfigTool.getConfigFileAsURL(filename);
        if (classLoaderURL != null) {
            if (DEBUG) {
                log.debug((Object)("Found " + filename + " classloaded path= " + classLoaderURL.getPath()));
            }
            return new File(classLoaderURL.getFile());
        }
        String error = "Could not find " + filename + " on the filesystem or classpath ";
        log.error((Object)error);
        throw new ConfigException(error);
    }

    public static File getConfigFileFromClassloadedDir(String filename) throws ConfigException {
        String path = ConfigTool.getConfigFileAsURL(filename).getFile();
        File result = new File(path);
        if (!result.exists()) {
            throw new ConfigException("File at '" + path + "' is not accessible via normal means.  Perhaps it's inside an archive?");
        }
        return result;
    }

    public static Reader getConfigFileReader(Module module) throws ConfigException {
        return ConfigTool.getConfigFileReader(module.name());
    }

    public static Reader getConfigFileReader(String moduleName) throws ConfigException {
        return new InputStreamReader(ConfigTool.getXMLConfigFileStream(moduleName));
    }

    public static InputStream getXMLConfigFileStream(String moduleName) throws ConfigException {
        return ConfigTool.getConfigFileStream(ConfigTool.makeXMLFileName(moduleName));
    }

    public static InputStream getConfigFileStream(File desiredFile) throws ConfigException {
        if (desiredFile.isAbsolute() && !ConfigTool.shouldFallBackToClassloader(desiredFile)) {
            try {
                return new FileInputStream(desiredFile);
            }
            catch (FileNotFoundException e) {
                throw new ConfigException(e);
            }
        }
        return ConfigTool.getConfigFileStream(desiredFile.getName());
    }

    public static InputStream getConfigFileStream(String desiredFileName) throws ConfigException {
        File result = new File(desiredFileName);
        if (!result.isAbsolute()) {
            result = new File(SPINRuntimeConfig.getAbsolutePath() + File.separator + desiredFileName);
        }
        if (ConfigTool.shouldFallBackToClassloader(result)) {
            InputStream configStream = ConfigTool.getClasspathResource(desiredFileName);
            if (configStream == null) {
                throw new ConfigException("Couldn't find '" + desiredFileName + "' on the file system [ " + result.getAbsolutePath() + " ] or classpath.");
            }
            return configStream;
        }
        try {
            return new FileInputStream(result);
        }
        catch (FileNotFoundException e) {
            throw new ConfigException(e);
        }
    }

    public static String getConfigText(String filename) throws IOException, ConfigException {
        File desiredFile = new File(filename);
        return ConfigTool.shouldFallBackToClassloader(desiredFile) ? FileUtils.read(ConfigTool.getConfigFile(filename)) : FileUtils.read(ConfigTool.getConfigFileStream(desiredFile));
    }

    public static Properties getConfigProperties(String filename) throws IOException, ConfigException {
        return ConfigTool.getProperties(ConfigTool.getConfigFile(filename));
    }

    public static Properties getProperties(File propertiesFile) throws IOException {
        Properties props = new Properties();
        props.load(new FileInputStream(propertiesFile));
        return props;
    }

    public static Properties getProperties(InputStream propertiesFile) throws IOException {
        Properties props = new Properties();
        props.load(propertiesFile);
        return props;
    }

    public static final NodeConfig loadNodeConfig() throws ConfigException {
        return ConfigTool.load(Module.node, NodeConfig.class);
    }

    public static final void writeNodeConfig(NodeConfig config) throws ConfigException {
        ConfigTool.write(Module.node, (Object)config);
    }

    public static final AgentConfig loadAgentConfig() throws ConfigException {
        return ConfigTool.load(Module.agent, AgentConfig.class);
    }

    public static final void writeAgentConfig(AgentConfig config) throws ConfigException {
        ConfigTool.write(Module.agent, (Object)config);
    }

    public static final KeyStoreConfig loadKeyStoreConfig() throws ConfigException {
        return ConfigTool.load(Module.keystore, KeyStoreConfig.class);
    }

    public static final void writeKeyStoreConfig(KeyStoreConfig config) throws ConfigException {
        ConfigTool.write(Module.keystore, (Object)config);
    }

    public static final MailToolConfig loadMailToolConfig() throws ConfigException {
        return ConfigTool.load(Module.mail, MailToolConfig.class);
    }

    public static final void writeMailToolConfig(MailToolConfig config) throws ConfigException {
        ConfigTool.write(Module.mail, (Object)config);
    }

    public static final RoutingTableConfig loadRoutingTableConfig() throws ConfigException {
        RoutingTableConfig result = ConfigTool.load(Module.routingtable, RoutingTableConfig.class);
        result.ensureLocalPeerGroupIsPresent();
        return result;
    }

    public static final void writeRoutingTableConfig(RoutingTableConfig config) throws ConfigException {
        ConfigTool.write(Module.routingtable, (Object)config);
    }

    private static final <T> T load(Module moduleName, Class<T> configurationClass) throws ConfigException {
        return ConfigTool.load(ConfigTool.getConfigFileReader(moduleName), configurationClass);
    }

    private static final void write(Module moduleName, Object configurationClass) throws ConfigException {
        ConfigTool.write(ConfigTool.getConfigFile(moduleName), configurationClass);
    }

    protected static final <T> T load(File configFile, Class<T> configurationClass) throws ConfigException {
        log.info((Object)("Loading " + configFile.getAbsolutePath()));
        try {
            return ConfigTool.load(new FileReader(configFile), configurationClass);
        }
        catch (ConfigException e) {
            log.fatal((Object)("Failed to load! " + configFile.getAbsolutePath()), (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            log.fatal((Object)("Failed to load! " + configFile.getAbsolutePath()), (Throwable)e);
            throw new ConfigException(e);
        }
    }

    public static final <T> T load(Reader configFile, Class<T> configurationClass) throws ConfigException {
        try {
            return JAXBUtils.unmarshal(configFile, configurationClass);
        }
        catch (Exception e) {
            throw new ConfigException("Could not load config file!", e);
        }
    }

    public static final void write(File configFile, Object configurationClass) throws ConfigException {
        try {
            if (INFO) {
                log.info((Object)("Writing file " + configFile.getAbsolutePath()));
            }
            if (configFile.exists()) {
                File backup = new File(configFile + ".bak");
                if (backup.exists()) {
                    backup.delete();
                }
                configFile.renameTo(backup);
            }
            FileWriter writer = new FileWriter(configFile);
            JAXBUtils.marshalToWriter(configurationClass, writer);
        }
        catch (Exception e) {
            throw new ConfigException("Could not write file: " + configFile.getAbsoluteFile(), e);
        }
    }

    public static Connection getConnection(File jdbcConfig) throws ConfigException {
        try {
            return ConfigTool.getConnection(JAXBUtils.unmarshal(jdbcConfig, JDBCConfig.class));
        }
        catch (Exception e) {
            throw new ConfigException("Could not configure JDBC connection", e);
        }
    }

    public static Connection getConnection(Node jdbcConfig) throws ConfigException {
        try {
            return ConfigTool.getConnection(JAXBUtils.unmarshal(jdbcConfig, JDBCConfig.class));
        }
        catch (JAXBException e) {
            throw new ConfigException("Could not configure JDBC connection", e);
        }
    }

    public static Connection getConnection(JDBCConfig jdbcConfig) throws ConfigException {
        Connection connection;
        String driver = jdbcConfig.getDriver();
        String url = jdbcConfig.getUrl();
        String username = jdbcConfig.getUsername();
        String password = jdbcConfig.getPassword();
        try {
            if (driver == null || url == null || username == null || password == null) {
                throw new ConfigException("Invalid DBConnection options: driver: " + driver + " url: " + url + " username: " + username);
            }
            Class.forName(driver);
            connection = DriverManager.getConnection(url, username, password);
            if (DEBUG) {
                log.debug((Object)("Connection opened: driver: " + driver + " url: " + url + " username: " + username));
            }
        }
        catch (ClassNotFoundException e) {
            throw new ConfigException("Could not load driver: " + driver, e);
        }
        catch (SQLException e) {
            throw new ConfigException("Could not open connection: driver: " + driver + " url: " + url + " username: " + username, e);
        }
        return connection;
    }

    public static File getFileURL(Node fileConfig) throws ConfigException {
        try {
            return ConfigTool.getFileURL(JAXBUtils.unmarshal(fileConfig, FileConfig.class));
        }
        catch (JAXBException e) {
            throw new ConfigException("Could not find file resource", e);
        }
    }

    public static File getFileURL(FileConfig fileConfig) throws ConfigException {
        try {
            return new File(fileConfig.getFilename());
        }
        catch (Exception e) {
            throw new ConfigException("Could not find file resource " + fileConfig.getFilename(), e);
        }
    }

    public static File[] getXMLFiles(Node fileConfig) throws ConfigException {
        return ConfigTool.getXMLFiles(ConfigTool.getFileURL(fileConfig));
    }

    public static File[] getXMLFiles(FileConfig fileConfig) throws ConfigException {
        return ConfigTool.getXMLFiles(ConfigTool.getFileURL(fileConfig));
    }

    public static File[] getXMLFiles(File folder) throws ConfigException {
        try {
            return new FileFilterTool().recursiveFilter(folder, new XMLFileFilter());
        }
        catch (Exception e) {
            throw new ConfigException("Failed to get XML Files", e);
        }
    }

    public static URL getURL(Node urlConfig) throws ConfigException {
        try {
            return ConfigTool.getURL(JAXBUtils.unmarshal(urlConfig, URLConfig.class));
        }
        catch (JAXBException e) {
            throw new ConfigException("Could not parse URL", e);
        }
    }

    public static URL getURL(URLConfig urlConfig) throws ConfigException {
        try {
            return new URL(urlConfig.getUrl());
        }
        catch (MalformedURLException e) {
            throw new ConfigException("Malformed URL", e);
        }
    }

    public boolean isValid(FileConfig fileConfig) {
        return this.isValid(new File(fileConfig.getFilename()));
    }

    public boolean isValid(File file) {
        try {
            if (file.exists()) {
                log.debug((Object)("Found " + file.getAbsolutePath()));
                return true;
            }
            log.debug((Object)("File not found! " + file.getAbsolutePath()));
            return false;
        }
        catch (Exception e) {
            log.debug((Object)"Invalid file specified");
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isValid(JDBCConfig jdbc) {
        Connection conn = null;
        try {
            conn = ConfigTool.getConnection(jdbc);
            if (DEBUG) {
                log.debug((Object)"Test Connection successfull ! ");
                log.debug((Object)("driver=" + jdbc.getDriver()));
                log.debug((Object)("URL=" + jdbc.getUrl()));
                log.debug((Object)("username=" + jdbc.getUsername()));
                log.debug((Object)("password=" + jdbc.getPassword()));
            }
            boolean bl = true;
            return bl;
        }
        catch (ConfigException e) {
            log.debug((Object)"Test Connection FAILED!");
            boolean bl = false;
            return bl;
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException eaten) {}
            }
        }
    }

    public boolean isValid(KeyStoreConfig keystore) {
        try {
            log.warn((Object)"Currently have no way to test the keystore without reloading it application wide.");
            return true;
        }
        catch (Exception e) {
            log.warn((Object)"Could not load keystore !");
            return false;
        }
    }

    public boolean isValid(URLConfig url) {
        try {
            new URL(url.getUrl());
            if (DEBUG) {
                log.debug((Object)"URL is well formed.");
            }
            return true;
        }
        catch (MalformedURLException e) {
            log.warn((Object)"Malformed URL!");
            return false;
        }
    }

    public static URL buildURL(String suffix) {
        try {
            return new URL("https://" + ConfigTool.getHostName() + suffix);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String getHostName() {
        String hostname = null;
        try {
            hostname = InetAddress.getLocalHost().getCanonicalHostName();
        }
        catch (Exception e) {
            hostname = System.getProperty("HOSTNAME");
        }
        return hostname == null ? "localhost" : hostname;
    }

    static {
        try {
            ConfigTool.initLog4J();
        }
        catch (Exception e) {
            System.out.println("ConfigTool: could not initialize Log4J for Spin tools" + e.getMessage());
        }
    }
}

