/*
 * Decompiled with CFR 0.152.
 */
package org.spin.tools.config;

import java.io.File;
import java.util.Arrays;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="KeyStoreConfig")
@XmlRootElement(name="KeyStoreConfig")
public final class KeyStoreConfig {
    @XmlElement(required=true)
    protected final File file;
    @XmlElement(required=true)
    protected final String password;
    @XmlElement(required=false)
    protected final String keyAlias;
    @XmlElement(required=false)
    protected boolean setSystemProperties = true;

    public KeyStoreConfig() {
        this(null, null);
    }

    public KeyStoreConfig(File file, String password) {
        this(file, password, null);
    }

    public KeyStoreConfig(File file, String password, String keyAlias) {
        this(file, password, keyAlias, true);
    }

    public KeyStoreConfig(File file, String password, boolean setSystemProperties) {
        this(file, password, null, setSystemProperties);
    }

    public KeyStoreConfig(File file, String password, String keyAlias, boolean setSystemProperties) {
        this.file = file;
        this.password = password;
        this.keyAlias = keyAlias;
        this.setSystemProperties = setSystemProperties;
    }

    public File getFile() {
        return this.file;
    }

    public String getPassword() {
        return this.password;
    }

    public char[] getPasswordAsCharArray() {
        return this.password.toCharArray();
    }

    public boolean isSetSystemProperties() {
        return this.setSystemProperties;
    }

    public String getKeyAlias() {
        return this.keyAlias;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.file == null ? 0 : this.file.hashCode());
        result = 31 * result + (this.keyAlias == null ? 0 : this.keyAlias.hashCode());
        result = 31 * result + (this.password == null ? 0 : this.password.hashCode());
        result = 31 * result + (this.setSystemProperties ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        KeyStoreConfig other = (KeyStoreConfig)obj;
        if (this.file == null ? other.file != null : !this.file.equals(other.file)) {
            return false;
        }
        if (this.keyAlias == null ? other.keyAlias != null : !this.keyAlias.equals(other.keyAlias)) {
            return false;
        }
        if (this.password == null ? other.password != null : !this.password.equals(other.password)) {
            return false;
        }
        return this.setSystemProperties == other.setSystemProperties;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        String CRLF = System.getProperty("line.separator");
        char[] obscuredPassword = new char[this.getPassword().length()];
        Arrays.fill(obscuredPassword, '*');
        sb.append("File:\t\t" + this.getFile().getAbsolutePath());
        sb.append(CRLF);
        sb.append("Password:\t\t" + (this.getPassword().length() > 0 ? obscuredPassword : (char[])" NULL"));
        sb.append(CRLF);
        sb.append("Key alias:\t\t" + this.getKeyAlias());
        sb.append(CRLF);
        sb.append("Set system props?\t" + this.isSetSystemProperties());
        return sb.toString();
    }
}

