/*
 * Decompiled with CFR 0.152.
 */
package org.spin.tools.config;

import java.util.Collection;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.log4j.Logger;
import org.spin.tools.Util;
import org.spin.tools.config.KeyStoreConfig;
import org.spin.tools.config.QueryTypeConfig;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="NodeConfig", namespace="http://spin.org/xml/res")
@XmlRootElement(name="NodeConfig", namespace="http://spin.org/xml/res")
public class NodeConfig {
    private static final Logger log = Logger.getLogger(NodeConfig.class);
    private static final boolean DEBUG = log.isDebugEnabled();
    @Deprecated
    @XmlElement(name="version", required=true)
    public final float version = 1.6f;
    public static final long defaultCacheExpirationTime = 3600000L;
    @XmlElement(name="nodeName", required=true)
    protected String nodeName;
    @XmlElement(name="isAuthenticator", required=false)
    protected boolean isAuthenticator = true;
    @XmlElement(name="identityServiceClass", required=false)
    protected String identityServiceClass;
    @XmlElement(name="isBroadcaster", required=false)
    protected boolean isBroadcaster = true;
    @XmlElement(name="isAggregator", required=false)
    protected boolean isAggregator = true;
    @XmlElement(name="isQueryable", required=false)
    protected boolean isQueryable = true;
    @XmlElement(name="queries", required=false)
    protected final List<QueryTypeConfig> queries = Util.makeArrayList();
    @XmlElement(name="certificationTTL", required=false)
    protected long certificationTTL = 3600000L;
    @XmlElement(name="cacheTTL", required=false)
    protected long cacheTTL = 3600000L;
    @XmlElement(name="keyStoreConfig", required=true)
    protected KeyStoreConfig keyStoreConfig = null;

    public String getNodeName() {
        return this.nodeName;
    }

    public void setNodeName(String nodeName) {
        this.nodeName = nodeName;
    }

    public List<QueryTypeConfig> getQueries() {
        return this.queries;
    }

    public boolean hasQueryType(String queryType) {
        for (QueryTypeConfig qt : this.getQueries()) {
            if (!qt.getQueryType().equalsIgnoreCase(queryType)) continue;
            return true;
        }
        return false;
    }

    public void addQuery(QueryTypeConfig queryTypeConfig) {
        this.queries.add(queryTypeConfig);
    }

    public void addQueries(Collection<QueryTypeConfig> queryList) {
        this.queries.addAll(queryList);
    }

    public boolean isAuthenticator() {
        return this.isAuthenticator;
    }

    public void setAuthenticator(boolean isAuthenticator) {
        this.isAuthenticator = isAuthenticator;
    }

    public String getIdentityServiceClass() {
        return this.identityServiceClass;
    }

    public void setIdentityServiceClass(String identityServiceClass) {
        this.identityServiceClass = identityServiceClass;
    }

    public boolean isBroadcaster() {
        return this.isBroadcaster;
    }

    public void setBroadcaster(boolean isBroadcaster) {
        this.isBroadcaster = isBroadcaster;
    }

    public boolean isAggregator() {
        return this.isAggregator;
    }

    public void setAggregator(boolean isAggregator) {
        this.isAggregator = isAggregator;
    }

    public boolean isQueryable() {
        return this.isQueryable;
    }

    public void setQueryable(boolean isQueryable) {
        this.isQueryable = isQueryable;
    }

    public KeyStoreConfig getKeyStoreConfig() {
        return this.keyStoreConfig;
    }

    public void setKeyStoreConfig(KeyStoreConfig keyStoreConfig) {
        this.keyStoreConfig = keyStoreConfig;
    }

    public long getCertificationTTL() {
        return this.certificationTTL;
    }

    public void setCertificationTTL(long certificationTTL) {
        this.certificationTTL = certificationTTL;
    }

    public long getCacheTTL() {
        return this.cacheTTL;
    }

    public void setCacheTTL(long cacheTTL) {
        this.cacheTTL = cacheTTL;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.cacheTTL ^ this.cacheTTL >>> 32);
        result = 31 * result + (int)(this.certificationTTL ^ this.certificationTTL >>> 32);
        result = 31 * result + (this.identityServiceClass == null ? 0 : this.identityServiceClass.hashCode());
        result = 31 * result + (this.isAggregator ? 1231 : 1237);
        result = 31 * result + (this.isAuthenticator ? 1231 : 1237);
        result = 31 * result + (this.isBroadcaster ? 1231 : 1237);
        result = 31 * result + (this.isQueryable ? 1231 : 1237);
        result = 31 * result + (this.keyStoreConfig == null ? 0 : this.keyStoreConfig.hashCode());
        result = 31 * result + (this.nodeName == null ? 0 : this.nodeName.hashCode());
        result = 31 * result + (this.queries == null ? 0 : ((Object)this.queries).hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NodeConfig)) {
            return false;
        }
        NodeConfig other = (NodeConfig)obj;
        if (this.cacheTTL != other.cacheTTL) {
            return false;
        }
        if (this.certificationTTL != other.certificationTTL) {
            return false;
        }
        if (this.identityServiceClass == null ? other.identityServiceClass != null : !this.identityServiceClass.equals(other.identityServiceClass)) {
            return false;
        }
        if (this.isAggregator != other.isAggregator) {
            return false;
        }
        if (this.isAuthenticator != other.isAuthenticator) {
            return false;
        }
        if (this.isBroadcaster != other.isBroadcaster) {
            return false;
        }
        if (this.isQueryable != other.isQueryable) {
            return false;
        }
        if (this.keyStoreConfig == null ? other.keyStoreConfig != null : !this.keyStoreConfig.equals(other.keyStoreConfig)) {
            return false;
        }
        if (this.nodeName == null ? other.nodeName != null : !this.nodeName.equals(other.nodeName)) {
            return false;
        }
        return !(this.queries == null ? other.queries != null : !((Object)this.queries).equals(other.queries));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        String CRLF = System.getProperty("line.separator");
        sb.append("NodeName:\t\t").append(this.getNodeName());
        sb.append(CRLF);
        sb.append("isBroadcaster:\t\t").append(this.isBroadcaster);
        sb.append(CRLF);
        sb.append("isAggregator:\t\t").append(this.isAggregator);
        sb.append(CRLF);
        sb.append("Cache TTL:\t\t").append(this.getCacheTTL());
        sb.append(CRLF);
        sb.append("authenticator:\t\t").append(this.identityServiceClass);
        sb.append(CRLF);
        sb.append("Certification TTL:\t").append(this.getCertificationTTL());
        sb.append(CRLF);
        sb.append("isQueryable:\t\t").append(this.isQueryable);
        sb.append(CRLF);
        for (QueryTypeConfig q : this.queries) {
            sb.append("QueryType:\t\t").append(q.getQueryType());
            sb.append(CRLF);
        }
        return sb.toString();
    }
}

