/*
 * Decompiled with CFR 0.152.
 */
package org.spin.tools.config;

import java.util.HashMap;
import java.util.Set;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.spin.tools.Util;
import org.spin.tools.config.DefaultPeerGroups;
import org.spin.tools.config.EndpointConfig;
import org.spin.tools.config.PeerGroupConfig;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="RoutingTableConfig", namespace="http://spin.org/xml/res", propOrder={"peerGroups"})
@XmlRootElement(name="RoutingTableConfig", namespace="http://spin.org/xml/res")
public class RoutingTableConfig {
    protected final HashMap<String, PeerGroupConfig> peerGroups = Util.makeHashMap();

    public RoutingTableConfig() {
        this.ensureLocalPeerGroupIsPresent();
    }

    public RoutingTableConfig(RoutingTableConfig other) {
        for (String name : other.getPeerGroupNames()) {
            this.peerGroups.put(name, other.get(name));
        }
        this.ensureLocalPeerGroupIsPresent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void ensureLocalPeerGroupIsPresent() {
        HashMap<String, PeerGroupConfig> hashMap = this.peerGroups;
        synchronized (hashMap) {
            if (!this.peerGroups.containsKey(DefaultPeerGroups.LOCAL.name())) {
                this.peerGroups.put(DefaultPeerGroups.LOCAL.name(), new PeerGroupConfig(DefaultPeerGroups.LOCAL.name()));
            }
        }
    }

    public boolean contains(String peerGroupName) {
        return this.peerGroups.containsKey(peerGroupName);
    }

    public Set<String> getPeerGroupNames() {
        return this.peerGroups.keySet();
    }

    public PeerGroupConfig get(String peerGroupName) {
        return this.peerGroups.get(peerGroupName);
    }

    public void add(PeerGroupConfig peerGroup) {
        this.peerGroups.put(peerGroup.getGroupName(), peerGroup);
    }

    public void remove(String peerGroupName) {
        this.peerGroups.remove(peerGroupName);
    }

    public void clear() {
        this.peerGroups.clear();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        String CRLF = System.getProperty("line.separator");
        for (String name : this.peerGroups.keySet()) {
            sb.append("PeerGroup Name:" + name);
            sb.append(CRLF);
            for (EndpointConfig child : this.peerGroups.get(name).getChildren()) {
                sb.append("Child:" + child);
                sb.append(CRLF);
            }
            sb.append(CRLF);
            sb.append(CRLF);
        }
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.peerGroups == null ? 0 : this.peerGroups.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RoutingTableConfig other = (RoutingTableConfig)obj;
        return Util.mapsAreEqual(this.peerGroups, other.peerGroups);
    }
}

