/*
 * Decompiled with CFR 0.152.
 */
package org.spin.tools.config;

import java.io.File;
import java.util.Properties;
import org.spin.tools.config.ConfigException;

public class SPINRuntimeConfig {
    public static final String SPIN_HOME_UNIX_DEFAULT = "/opt/spin";
    public static final String SPIN_HOME_WIN_DEFAULT = "c:\\spin";
    public static final String main = "main";
    public static final String test = "test";
    public static final String runtimeProperites = "runtime.properties";
    private static String home = SPINRuntimeConfig.isWindows() ? "c:\\spin" : "/opt/spin";
    private static String runtime = "main";
    private static File absolute = null;

    public static final boolean isWindows() {
        return System.getProperty("os.name").toUpperCase().contains("WINDOWS");
    }

    public static final void setRuntimeMain() {
        runtime = main;
    }

    public static final void setRuntimeTest() {
        runtime = test;
    }

    public static final void setRuntime(String runtimeOverride) {
        runtime = runtimeOverride;
    }

    public static final String getRuntime() {
        if (runtime == null) {
            System.out.println("[SPINRuntimeConfig] getRuntime() was called before static initialization.");
        }
        return runtime;
    }

    public static final String getHome() {
        return home;
    }

    public static final void setHome(String userDefinedHome) {
        home = userDefinedHome;
    }

    public static File getAbsolutePath() throws ConfigException {
        String spinConfigPath;
        if (absolute == null && !(absolute = new File(spinConfigPath = home + File.separator + runtime + File.separator + "conf")).exists()) {
            System.out.println("[SPINRuntimeConfig] " + spinConfigPath + " doesn't exist.  Creating it...");
            if (!absolute.mkdirs()) {
                throw new ConfigException("Couldn't create '" + spinConfigPath + "'.  Please make it yourself.");
            }
        }
        return absolute;
    }

    public static void setAbsolutePath(File userProvidedAbsolutePath) {
        absolute = userProvidedAbsolutePath;
    }

    static {
        try {
            if (absolute != null) {
                System.out.println("[SPINRuntimeConfig] STATIC CONEXT REINITIALIZED? absolute path is already " + SPINRuntimeConfig.getAbsolutePath());
            } else {
                Properties properties = new Properties();
                properties.load(SPINRuntimeConfig.class.getClassLoader().getResourceAsStream(runtimeProperites));
                if (properties.containsKey("home")) {
                    home = properties.getProperty("home");
                    System.out.println("[SPINRuntimeConfig] runtime.properties contained user-defined home directory : " + home);
                } else {
                    System.out.println("[SPINRuntimeConfig] using default home directory " + home);
                }
                if (properties.containsKey("runtime")) {
                    runtime = properties.getProperty("runtime");
                    System.out.println("[SPINRuntimeConfig] using runtime " + runtime);
                } else {
                    System.out.println("[SPINRuntimeConfig] using default runtime " + runtime);
                }
                if (properties.containsKey("absolute")) {
                    absolute = new File(properties.getProperty("absolute"));
                    System.out.println("[SPINRuntimeConfig] using user-defined absolute path " + absolute);
                }
                absolute = SPINRuntimeConfig.getAbsolutePath();
            }
        }
        catch (Exception e) {
            System.out.println("[SPINRuntimeConfig] no runtime.properties found, using defaults.");
        }
    }
}

