/*
 * Decompiled with CFR 0.152.
 */
package org.spin.tools.crypto;

import javax.xml.bind.JAXBException;
import org.spin.tools.JAXBUtils;
import org.spin.tools.crypto.BadSignatureException;
import org.spin.tools.crypto.CryptoException;
import org.spin.tools.crypto.Decryptor;
import org.spin.tools.crypto.EncryptedData;
import org.spin.tools.crypto.Encryptor;
import org.spin.tools.crypto.SignerVerifier;
import org.spin.tools.crypto.signature.CertID;

public abstract class Cryptor
implements Encryptor,
Decryptor,
SignerVerifier {
    public String encryptAndSign(String plainText, CertID encryptFor) throws CryptoException {
        EncryptedData encrypted = this.encryptAndSignWithoutMarshalling(plainText, encryptFor);
        try {
            return JAXBUtils.marshalToString(encrypted);
        }
        catch (JAXBException e) {
            throw new CryptoException("Couldn't marshall result: ", e);
        }
    }

    public EncryptedData encryptAndSignWithoutMarshalling(String plainText, CertID encryptFor) throws CryptoException {
        return this.sign(this.encryptWithoutMarshalling(plainText, encryptFor));
    }

    public String decryptAndVerify(String cipherText) throws CryptoException {
        EncryptedData encrypted;
        try {
            encrypted = JAXBUtils.unmarshal(cipherText, EncryptedData.class);
        }
        catch (JAXBException e) {
            throw new CryptoException("Error unmarshalling cipherText: ", e);
        }
        return this.decryptAndVerify(encrypted);
    }

    public String decryptAndVerify(EncryptedData encrypted) throws CryptoException {
        if (!this.verify(encrypted)) {
            throw new BadSignatureException("Error verifying signature");
        }
        return this.decrypt(encrypted);
    }
}

