/*
 * Decompiled with CFR 0.152.
 */
package org.spin.tools.crypto;

import java.util.Arrays;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.spin.tools.crypto.signature.CertID;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="EncryptedData")
@XmlRootElement
public class EncryptedData {
    @XmlElement(required=true)
    protected byte[] encryptedKey;
    @XmlElement(required=true)
    protected byte[] data;
    @XmlElement(required=false)
    protected CertID encryptedFor;
    @XmlElement(required=false)
    protected byte[] signature;
    @XmlElement(required=false)
    protected CertID signedBy;

    public EncryptedData() {
    }

    public EncryptedData(byte[] encryptedKey, byte[] data, CertID encryptedFor, byte[] signature, CertID signedBy) {
        this.encryptedKey = encryptedKey;
        this.data = data;
        this.encryptedFor = encryptedFor;
        this.signature = signature;
        this.signedBy = signedBy;
    }

    public final byte[] getEncryptedKey() {
        return this.encryptedKey;
    }

    public final void setEncryptedKey(byte[] encryptedKey) {
        this.encryptedKey = encryptedKey;
    }

    public final byte[] getData() {
        return this.data;
    }

    public final void setData(byte[] data) {
        this.data = data;
    }

    public CertID getEncryptedFor() {
        return this.encryptedFor;
    }

    public void setEncryptedFor(CertID encryptedFor) {
        this.encryptedFor = encryptedFor;
    }

    public byte[] getSignature() {
        return this.signature;
    }

    public void setSignature(byte[] signature) {
        this.signature = signature;
    }

    public CertID getSignedBy() {
        return this.signedBy;
    }

    public void setSignedBy(CertID signedBy) {
        this.signedBy = signedBy;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.data);
        result = 31 * result + (this.encryptedFor == null ? 0 : this.encryptedFor.hashCode());
        result = 31 * result + Arrays.hashCode(this.encryptedKey);
        result = 31 * result + Arrays.hashCode(this.signature);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EncryptedData other = (EncryptedData)obj;
        if (!Arrays.equals(this.data, other.data)) {
            return false;
        }
        if (this.encryptedFor == null ? other.encryptedFor != null : !this.encryptedFor.equals(other.encryptedFor)) {
            return false;
        }
        if (!Arrays.equals(this.encryptedKey, other.encryptedKey)) {
            return false;
        }
        return Arrays.equals(this.signature, other.signature);
    }
}

