/*
 * Decompiled with CFR 0.152.
 */
package org.spin.tools.crypto;

import java.security.PublicKey;
import java.security.SignatureException;
import javax.crypto.SecretKey;
import javax.xml.bind.JAXBException;
import org.apache.log4j.Logger;
import org.spin.tools.JAXBUtils;
import org.spin.tools.PKITool;
import org.spin.tools.SymmetricCryptoTool;
import org.spin.tools.config.ConfigException;
import org.spin.tools.crypto.BadSignatureException;
import org.spin.tools.crypto.CryptoException;
import org.spin.tools.crypto.Cryptor;
import org.spin.tools.crypto.EncryptedData;
import org.spin.tools.crypto.signature.CertID;

public class PKCryptor
extends Cryptor {
    private static final Logger log = Logger.getLogger(PKCryptor.class);
    private static final boolean INFO = log.isInfoEnabled();
    private final PKITool pkiTool;

    public PKCryptor() throws ConfigException {
        this(PKITool.getInstance());
    }

    public PKCryptor(PKITool pkiTool) {
        this.pkiTool = pkiTool;
    }

    public String encrypt(String plainText, CertID encryptFor) throws CryptoException {
        if (plainText == null) {
            throw new CryptoException("Null plaintext; can't encrypt");
        }
        return this.encrypt(plainText.getBytes(), encryptFor);
    }

    public String encrypt(byte[] plainText, CertID keyIDToEncrypt) throws CryptoException {
        if (plainText == null) {
            throw new CryptoException("Null plaintext; can't encrypt");
        }
        EncryptedData encryptedData = this.encryptWithoutMarshalling(plainText, keyIDToEncrypt);
        try {
            return JAXBUtils.marshalToString(encryptedData);
        }
        catch (JAXBException e) {
            throw new CryptoException("Marshalling error: ", e);
        }
    }

    public EncryptedData encryptWithoutMarshalling(String plainText, CertID x509Serial) throws CryptoException {
        if (plainText == null) {
            throw new CryptoException("Null plaintext; can't encrypt");
        }
        return this.encryptWithoutMarshalling(plainText.getBytes(), x509Serial);
    }

    public EncryptedData encryptWithoutMarshalling(byte[] plainText, CertID x509Serial) throws CryptoException {
        if (plainText == null) {
            throw new CryptoException("Null plaintext; can't encrypt");
        }
        if (x509Serial == null) {
            throw new CryptoException("Null recipient x509 serial");
        }
        if (!this.pkiTool.containsX509Certificate(x509Serial)) {
            throw new CryptoException("No certificate found with key ID: " + x509Serial);
        }
        PublicKey publicKey = this.pkiTool.getX509Certificate(x509Serial).getPublicKey();
        EncryptedData encryptedData = new EncryptedData();
        SecretKey key = SymmetricCryptoTool.generateSecretKey();
        encryptedData.setEncryptedKey(this.pkiTool.encrypt(key.getEncoded(), publicKey));
        encryptedData.setData(SymmetricCryptoTool.encrypt(plainText, key));
        encryptedData.setEncryptedFor(x509Serial);
        return encryptedData;
    }

    public String decrypt(String cipherText) throws CryptoException {
        if (cipherText == null) {
            throw new CryptoException("Null ciphertext; can't decrypt");
        }
        try {
            return this.decrypt(JAXBUtils.unmarshal(cipherText, EncryptedData.class));
        }
        catch (JAXBException e) {
            throw new CryptoException("Unmarshalling error: ", e);
        }
    }

    public String decrypt(EncryptedData encryptedData) throws CryptoException {
        if (encryptedData == null) {
            throw new CryptoException("Null encrypted data passed in");
        }
        if (encryptedData.getSignature() != null) {
            try {
                this.pkiTool.verifySignature(encryptedData.getData(), encryptedData.getSignature());
            }
            catch (SignatureException e) {
                throw new BadSignatureException("Error verifying signature: ", e);
            }
        }
        SecretKey key = SymmetricCryptoTool.getSecretKey(this.pkiTool.decrypt(encryptedData.getEncryptedKey()));
        return new String(SymmetricCryptoTool.decrypt(encryptedData.getData(), key));
    }

    public EncryptedData sign(EncryptedData encryptedData) throws CryptoException {
        if (encryptedData == null) {
            throw new CryptoException("Null encrypted data passed in");
        }
        try {
            encryptedData.setSignature(this.pkiTool.sign(encryptedData.getData()));
            encryptedData.setSignedBy(this.pkiTool.getMyCertID());
            return encryptedData;
        }
        catch (SignatureException e) {
            throw new CryptoException("Error signing: ", e);
        }
    }

    public boolean verify(EncryptedData encryptedData) throws CryptoException {
        if (encryptedData == null) {
            throw new CryptoException("Null encrypted data passed in");
        }
        if (encryptedData.getSignature() != null) {
            if (encryptedData.signedBy == null) {
                log.warn((Object)"Data with signature, but no signedBy field. Can't verify signature");
                return false;
            }
            try {
                return this.pkiTool.verifySignature(encryptedData.getData(), encryptedData.getSignature(), encryptedData.getSignedBy());
            }
            catch (SignatureException e) {
                throw new CryptoException("Error verifying: ", e);
            }
        }
        log.warn((Object)"Encrypted data with no signature; verification 'succeeds'");
        return true;
    }

    public final PKITool getPKITool() {
        return this.pkiTool;
    }
}

