/*
 * Decompiled with CFR 0.152.
 */
package org.spin.tools.crypto.signature;

import java.math.BigInteger;
import java.security.cert.X509Certificate;
import javax.persistence.Entity;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.spin.tools.Util;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="X509IssuerSerialType")
@XmlRootElement(name="X509IssuerSerialType")
@Entity
public final class CertID {
    @XmlElement(name="X509IssuerName", required=false)
    protected final String certName;
    @XmlElement(name="X509SerialNumber", required=true)
    protected final BigInteger certSerial;

    public CertID() {
        this((BigInteger)null, null);
    }

    public CertID(String serial) {
        this(serial, null);
    }

    public CertID(BigInteger serial) {
        this(serial, null);
    }

    public CertID(String serial, String name) {
        this(new BigInteger(serial), name);
    }

    public CertID(X509Certificate certificate) {
        this(certificate.getSerialNumber(), certificate.getSubjectX500Principal().getName());
    }

    public CertID(BigInteger serial, String name) {
        this.certSerial = serial;
        this.certName = name;
    }

    public String getName() {
        return this.certName;
    }

    public BigInteger getSerial() {
        return this.certSerial;
    }

    public String toString() {
        return Util.concat("['", this.certName, "':", this.certSerial, "]");
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.certName == null ? 0 : this.certName.hashCode());
        result = 31 * result + (this.certSerial == null ? 0 : this.certSerial.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CertID other = (CertID)obj;
        if (this.certName == null ? other.certName != null : !this.certName.equals(other.certName)) {
            return false;
        }
        return !(this.certSerial == null ? other.certSerial != null : !this.certSerial.equals(other.certSerial));
    }
}

