/*
 * Decompiled with CFR 0.152.
 */
package org.spin.tools.crypto.signature;

import java.io.ByteArrayInputStream;
import java.math.BigInteger;
import java.security.Provider;
import java.security.PublicKey;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.xml.bind.JAXBException;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.XMLStructure;
import javax.xml.crypto.dsig.Reference;
import javax.xml.crypto.dsig.SignedInfo;
import javax.xml.crypto.dsig.XMLSignature;
import javax.xml.crypto.dsig.XMLSignatureException;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.crypto.dsig.dom.DOMSignContext;
import javax.xml.crypto.dsig.dom.DOMValidateContext;
import javax.xml.crypto.dsig.keyinfo.KeyInfo;
import javax.xml.crypto.dsig.keyinfo.KeyInfoFactory;
import javax.xml.crypto.dsig.keyinfo.X509Data;
import javax.xml.crypto.dsig.keyinfo.X509IssuerSerial;
import org.apache.log4j.Logger;
import org.spin.tools.ClassTools;
import org.spin.tools.DynamicLoadingException;
import org.spin.tools.JAXBUtils;
import org.spin.tools.PKITool;
import org.spin.tools.crypto.CryptoException;
import org.spin.tools.crypto.signature.Identity;
import org.spin.tools.crypto.signature.Signature;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLSignatureUtil {
    private static final String providerName = System.getProperty("jsr105Provider", "org.jcp.xml.dsig.internal.dom.XMLDSigRI");
    private static final Logger log = Logger.getLogger(XMLSignatureUtil.class);

    public static Identity sign(Identity identity) throws XMLSignatureException {
        return XMLSignatureUtil.sign(identity, false);
    }

    public static Identity sign(Identity identity, boolean attachMyPublicKey) throws XMLSignatureException {
        Element signedIdentityElement = XMLSignatureUtil.signObject(identity, attachMyPublicKey);
        try {
            return JAXBUtils.unmarshal(signedIdentityElement, Identity.class);
        }
        catch (JAXBException e) {
            throw new XMLSignatureException("Error unmarshalling signed Identity", e);
        }
    }

    public static Element signObject(Object rootXMLObject) throws XMLSignatureException {
        return XMLSignatureUtil.signObject(rootXMLObject, false);
    }

    public static Element signObject(Object toBeSigned, boolean attachMyPublicKey) throws XMLSignatureException {
        try {
            PKITool pkiTool = PKITool.getInstance();
            XMLSignatureFactory xmlSignatureFactory = XMLSignatureUtil.getXMLSignatureFactory();
            Reference reference = xmlSignatureFactory.newReference("", xmlSignatureFactory.newDigestMethod("http://www.w3.org/2000/09/xmldsig#sha1", null), Collections.singletonList(xmlSignatureFactory.newTransform("http://www.w3.org/2000/09/xmldsig#enveloped-signature", (XMLStructure)null)), null, null);
            SignedInfo signedInfo = xmlSignatureFactory.newSignedInfo(xmlSignatureFactory.newCanonicalizationMethod("http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments", (XMLStructure)null), xmlSignatureFactory.newSignatureMethod("http://www.w3.org/2000/09/xmldsig#rsa-sha1", null), Collections.singletonList(reference));
            Element element = JAXBUtils.marshalToElement(toBeSigned);
            DOMSignContext domSignContext = new DOMSignContext(pkiTool.getMyPrivateKey(), (Node)element);
            KeyInfoFactory keyInfoFactory = xmlSignatureFactory.getKeyInfoFactory();
            X509Certificate myX509PublicKeyCertificate = pkiTool.getX509Certificate(pkiTool.getMyCertID());
            X509IssuerSerial x509IssuerSerial = keyInfoFactory.newX509IssuerSerial(myX509PublicKeyCertificate.getIssuerX500Principal().getName(), myX509PublicKeyCertificate.getSerialNumber());
            List<Object> x509DataToInclude = attachMyPublicKey ? Arrays.asList(x509IssuerSerial, myX509PublicKeyCertificate) : Arrays.asList(x509IssuerSerial);
            X509Data x509Data = keyInfoFactory.newX509Data(x509DataToInclude);
            KeyInfo keyInfo = keyInfoFactory.newKeyInfo(Arrays.asList(x509Data));
            XMLSignature signature = xmlSignatureFactory.newXMLSignature(signedInfo, keyInfo);
            signature.sign(domSignContext);
            return element;
        }
        catch (Exception e) {
            throw new XMLSignatureException("Failed to sign object", e);
        }
    }

    public static final boolean verifySignature(Identity identity) throws XMLSignatureException {
        PublicKey signerKey;
        BigInteger keyID;
        try {
            keyID = identity.getSignature().getKeyInfo().getCertData().getCertID().getSerial();
        }
        catch (NullPointerException e) {
            log.warn((Object)"Can't determine signing key");
            return false;
        }
        try {
            signerKey = PKITool.getInstance().getPublicKey(keyID);
        }
        catch (CryptoException e) {
            log.warn((Object)("Error getting signer key with serial '" + keyID + "', can't verify signature"), (Throwable)e);
            return false;
        }
        catch (Exception e) {
            log.warn((Object)("Error getting signer key with serial '" + keyID + "', can't verify signature"), (Throwable)e);
            return false;
        }
        return XMLSignatureUtil.verifySignature(identity, signerKey);
    }

    public static final boolean verifySignature(Identity identity, PublicKey publicKey) throws XMLSignatureException {
        try {
            return XMLSignatureUtil.verifySignature(JAXBUtils.marshalToElement(identity), publicKey);
        }
        catch (JAXBException e) {
            throw new XMLSignatureException("Couldn't unmarshal signed identity", e);
        }
    }

    public static final boolean verifySignature(Element signedElement, PublicKey publicKey) throws XMLSignatureException {
        XMLSignature signature;
        NodeList signaturesNodeList = signedElement.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Signature");
        if (signaturesNodeList == null || signaturesNodeList.getLength() < 1) {
            throw new XMLSignatureException("No signature found!");
        }
        Node signatureNode = signaturesNodeList.item(0);
        if (signatureNode == null) {
            throw new XMLSignatureException("No signature found!");
        }
        DOMValidateContext domValidateContext = new DOMValidateContext(publicKey, signatureNode);
        try {
            signature = XMLSignatureUtil.getXMLSignatureFactory().unmarshalXMLSignature(domValidateContext);
        }
        catch (MarshalException e) {
            throw new XMLSignatureException("Couldn't unmarshal XML signature", e);
        }
        return signature.validate(domValidateContext);
    }

    public static final X509Certificate getX509Certificate(Signature signature) throws CertificateException {
        CertificateFactory certFactory = CertificateFactory.getInstance("X.509");
        return (X509Certificate)certFactory.generateCertificate(new ByteArrayInputStream(signature.getKeyInfo().getCertData().getX509Certificate()));
    }

    private static final XMLSignatureFactory getXMLSignatureFactory() throws XMLSignatureException {
        try {
            return XMLSignatureFactory.getInstance("DOM", ClassTools.createInstance(providerName, Provider.class));
        }
        catch (DynamicLoadingException e) {
            throw new XMLSignatureException("Couldn't create XMLSignatureFactory using provider class '" + providerName + "': ", e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SignerStrategy {
        AttachSigningKey,
        DoNotAttachSigningKey;

    }
}

