/*
 * Decompiled with CFR 0.152.
 */
package org.spin.tools.filter;

import java.io.File;
import java.io.FileFilter;
import org.apache.log4j.Logger;

public class CustomFileFilter
implements FileFilter {
    private static final Logger log = Logger.getLogger(CustomFileFilter.class);
    String fileType;
    long earliestModifiedTime;
    long latestModifiedTime;

    public CustomFileFilter() {
    }

    public CustomFileFilter(String fileType) {
        this.fileType = fileType;
    }

    public CustomFileFilter(long earliestModifiedTime, long latestModifiedTime) {
        this.earliestModifiedTime = earliestModifiedTime;
        this.latestModifiedTime = latestModifiedTime;
    }

    public CustomFileFilter(String fileType, long earliestModifiedTime, long latestModifiedTime) {
        this.fileType = fileType;
        this.earliestModifiedTime = earliestModifiedTime;
        this.latestModifiedTime = latestModifiedTime;
    }

    public long getEarliestModifiedTime() {
        return this.earliestModifiedTime;
    }

    public void setEarliestModifiedTime(long earliestModifiedTime) {
        this.earliestModifiedTime = earliestModifiedTime;
    }

    public String getFileType() {
        return this.fileType;
    }

    public void setFileType(String fileType) {
        this.fileType = fileType;
    }

    public long getLatestModifiedTime() {
        return this.latestModifiedTime;
    }

    public void setLatestModifiedTime(long latestModifiedTime) {
        this.latestModifiedTime = latestModifiedTime;
    }

    public boolean accept(File pathname) {
        if (!pathname.isFile()) {
            return false;
        }
        if (this.fileType != null && !pathname.getName().toLowerCase().endsWith(this.fileType)) {
            return false;
        }
        if (this.earliestModifiedTime > 0L && pathname.lastModified() < this.earliestModifiedTime) {
            return false;
        }
        return this.latestModifiedTime <= 0L || pathname.lastModified() <= this.latestModifiedTime;
    }
}

