/*
 * Decompiled with CFR 0.152.
 */
package org.spin.extension;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import org.apache.log4j.Logger;
import org.spin.tools.config.ConfigException;

public class HTTPClient {
    private static final Logger log = Logger.getLogger(HTTPClient.class);
    private static final boolean DEBUG = log.isDebugEnabled();
    private static final boolean INFO = log.isInfoEnabled();

    public static String post(String rawXML, URL url) throws ConfigException, IOException {
        return HTTPClient.post(rawXML, url.toExternalForm());
    }

    public static String post(String rawXML, String url) throws ConfigException, IOException {
        Protocol protocol;
        if (DEBUG) {
            log.debug((Object)("posting to host " + url));
            log.debug((Object)("content: " + rawXML));
        }
        URL host = new URL(url);
        try {
            protocol = Protocol.valueOf(host.getProtocol().toUpperCase());
        }
        catch (Exception e) {
            throw new MalformedURLException("Unsupported protocol:" + host.getProtocol());
        }
        if (protocol == Protocol.HTTP) {
            log.debug((Object)"Opening HTTP connection");
            URLConnection conn = host.openConnection();
            conn.setDoOutput(true);
            conn.setRequestProperty("Content-Type", "text/xml");
            OutputStreamWriter out = new OutputStreamWriter(conn.getOutputStream());
            out.write(rawXML);
            out.flush();
            InputStream inputStream = conn.getInputStream();
            String serverSaid = HTTPClient.readResponse(inputStream);
            inputStream.close();
            out.close();
            return serverSaid;
        }
        log.debug((Object)("Opening HTTPS (SSL ) connection to host " + host.getHost()));
        SSLSocketFactory factory = (SSLSocketFactory)SSLSocketFactory.getDefault();
        int port = host.getPort() == -1 ? 443 : host.getPort();
        SSLSocket socket = (SSLSocket)factory.createSocket(host.getHost(), port);
        socket.startHandshake();
        PrintWriter out = new PrintWriter(new BufferedWriter(new OutputStreamWriter(socket.getOutputStream())));
        InputStream inputStream = socket.getInputStream();
        out.println("POST " + url + " HTTP/1.0");
        out.println("Content-Length: " + rawXML.length());
        out.println("Content-Type: text/xml");
        out.println();
        if (out.checkError()) {
            log.error((Object)"SSLSocketClient java.io.PrintWriter error");
            throw new IOException("SSLSocketClient");
        }
        out.println(rawXML);
        out.flush();
        String serverSaid = HTTPClient.readResponse(inputStream);
        out.close();
        inputStream.close();
        socket.close();
        int startXMLIndex = serverSaid.indexOf("<");
        return serverSaid.substring(startXMLIndex);
    }

    private static String readResponse(InputStream inputStream) throws IOException {
        String line;
        BufferedReader bufferedInputReader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
        StringBuffer response = new StringBuffer();
        while ((line = bufferedInputReader.readLine()) != null) {
            response.append(line);
        }
        bufferedInputReader.close();
        if (DEBUG) {
            log.debug((Object)("response from host: " + response.toString()));
        }
        String raw = response.toString();
        return response.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Protocol {
        HTTP,
        HTTPS;

    }
}

