/*
 * Decompiled with CFR 0.152.
 */
package org.spin.extension;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamSource;
import org.apache.log4j.Logger;
import org.jaxen.JaxenException;
import org.jaxen.jdom.JDOMXPath;
import org.jdom.Attribute;
import org.jdom.CDATA;
import org.jdom.Comment;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.Text;
import org.jdom.input.SAXBuilder;
import org.jdom.output.XMLOutputter;
import org.jdom.transform.JDOMResult;
import org.jdom.transform.JDOMSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JDOMTool {
    private static final String defaultParser = "org.apache.xerces.parsers.SAXParser";
    private static final String noNamespaceSchemaLocationAttribute = "http://apache.org/xml/properties/schema/external-noNamespaceSchemaLocation";
    private static final Logger log = Logger.getLogger(JDOMTool.class);
    private static final boolean DEBUG = log.isDebugEnabled();
    private static final XMLOutputter outputter = new XMLOutputter();
    private static final SAXBuilder builder = new SAXBuilder("org.apache.xerces.parsers.SAXParser");
    private final Element rootElement;

    public JDOMTool(Element element) {
        this(element, true);
    }

    public JDOMTool(Element element, boolean workAroundJDOMBug) {
        this.rootElement = workAroundJDOMBug ? new Document((Element)element.clone()).getRootElement() : element;
    }

    public JDOMTool(Element element, File schema) throws JDOMException {
        throw new JDOMException("Validation not currently supported");
    }

    public JDOMTool(Document document) {
        this.rootElement = document.getRootElement();
    }

    public JDOMTool(Document document, File schema) throws JDOMException {
        throw new JDOMException("Validation not currently supported");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JDOMTool(File xmlFile) throws IOException, JDOMException {
        SAXBuilder sAXBuilder = builder;
        synchronized (sAXBuilder) {
            this.rootElement = builder.build(xmlFile).getRootElement();
        }
    }

    public JDOMTool(File xmlFile, File schema) throws JDOMException {
        throw new JDOMException("Validation not currently supported");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JDOMTool(String xmlString) throws IOException, JDOMException {
        SAXBuilder sAXBuilder = builder;
        synchronized (sAXBuilder) {
            this.rootElement = builder.build((Reader)new StringReader(xmlString)).getRootElement();
        }
    }

    public JDOMTool(String xmlString, File schema) throws JDOMException {
        throw new JDOMException("Validation not currently supported");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JDOMTool(Reader reader) throws IOException, JDOMException {
        SAXBuilder sAXBuilder = builder;
        synchronized (sAXBuilder) {
            this.rootElement = builder.build(reader).getRootElement();
        }
    }

    public JDOMTool(Reader reader, File schema) throws JDOMException {
        throw new JDOMException("Validation not currently supported");
    }

    public Document transform(File xslt) throws TransformerException {
        return this.transform(new StreamSource(xslt), null);
    }

    public Document transform(File xslt, HashMap params) throws TransformerException {
        return this.transform(new StreamSource(xslt), params);
    }

    public Document transform(Reader xslt) throws TransformerException {
        return this.transform(new StreamSource(xslt), null);
    }

    public Document transform(Reader xslt, HashMap params) throws TransformerException {
        return this.transform(new StreamSource(xslt), params);
    }

    public Document transform(InputStream xslt) throws TransformerException {
        return this.transform(new StreamSource(xslt), null);
    }

    public Document transform(InputStream xslt, HashMap params) throws TransformerException {
        return this.transform(new StreamSource(xslt), params);
    }

    private Document transform(StreamSource xslt, HashMap params) throws TransformerException {
        JDOMResult result;
        if (DEBUG) {
            log.debug((Object)"Transform Document using xsl stream and mapped params");
        }
        try {
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer processor = transformerFactory.newTransformer(xslt);
            if (params != null) {
                if (DEBUG) {
                    log.debug((Object)"Setting params");
                }
                for (Object key : params.keySet()) {
                    processor.setParameter((String)key, params.get(key));
                }
            }
            JDOMSource source = new JDOMSource(this.getRootElement());
            result = new JDOMResult();
            processor.transform((Source)source, (Result)result);
        }
        catch (TransformerConfigurationException e) {
            throw new TransformerException("Transformer Configuration exception", e);
        }
        return result.getDocument();
    }

    public Element getRootElement() {
        return this.rootElement;
    }

    private static final JDOMXPath getJDOMXPath(String xpath) throws JaxenException {
        return new JDOMXPath(xpath);
    }

    private static final JDOMXPath getJDOMXPath(String xpath, Namespace namespace) throws JaxenException {
        JDOMXPath jdom = new JDOMXPath(xpath);
        jdom.addNamespace(namespace.getPrefix(), namespace.getURI());
        return jdom;
    }

    private static final JDOMXPath getJDOMXPath(String xpath, List<Namespace> namespaces) throws JaxenException {
        JDOMXPath jdom = new JDOMXPath(xpath);
        for (Namespace n : namespaces) {
            jdom.addNamespace(n.getPrefix(), n.getURI());
        }
        return jdom;
    }

    public Object selectSingleNode(String xpath) throws JaxenException {
        return JDOMTool.getJDOMXPath(xpath).selectSingleNode((Object)this.rootElement);
    }

    public Object selectSingleNode(String xpath, Namespace namespace) throws JaxenException {
        return JDOMTool.getJDOMXPath(xpath, namespace).selectSingleNode((Object)this.rootElement);
    }

    public Object selectSingleNode(String xpath, List<Namespace> namespaces) throws JaxenException {
        return JDOMTool.getJDOMXPath(xpath, namespaces).selectSingleNode((Object)this.rootElement);
    }

    public Element selectSingleElement(String xpath) throws JaxenException {
        return (Element)this.selectSingleNode(xpath);
    }

    public Element selectSingleElement(String xpath, Namespace namespace) throws JaxenException {
        return (Element)this.selectSingleNode(xpath, namespace);
    }

    public Element selectSingleElement(String xpath, List<Namespace> namespaces) throws JaxenException {
        return (Element)this.selectSingleNode(xpath, namespaces);
    }

    public <T> List<T> selectNodes(String xpath) throws JaxenException {
        return JDOMTool.getJDOMXPath(xpath).selectNodes((Object)this.rootElement);
    }

    public <T> List<T> selectNodes(String xpath, Namespace namespace) throws JaxenException {
        return JDOMTool.getJDOMXPath(xpath, namespace).selectNodes((Object)this.rootElement);
    }

    public <T> List<T> selectNodes(String xpath, List<Namespace> namespaces) throws JaxenException {
        return JDOMTool.getJDOMXPath(xpath, namespaces).selectNodes((Object)this.rootElement);
    }

    public String getElementValue(String xpath) throws JaxenException {
        Element element = (Element)this.selectSingleNode(xpath);
        return element == null ? null : element.getTextTrim();
    }

    public String getElementValue(String xpath, Namespace namespace) throws JaxenException {
        Element element = (Element)this.selectSingleNode(xpath, namespace);
        return element == null ? null : element.getTextTrim();
    }

    public String getElementValue(String xpath, List<Namespace> namespaces) throws JaxenException {
        Element element = (Element)this.selectSingleNode(xpath, namespaces);
        return element == null ? null : element.getTextTrim();
    }

    public List<String> getElementValues(String xpath) throws JaxenException {
        return this.getElementValues(JDOMTool.getJDOMXPath(xpath).selectNodes((Object)this.rootElement));
    }

    public List<String> getElementValues(String xpath, Namespace namespace) throws JaxenException {
        return this.getElementValues(JDOMTool.getJDOMXPath(xpath, namespace).selectNodes((Object)this.rootElement));
    }

    public List<String> getElementValues(String xpath, List<Namespace> namespaces) throws JaxenException {
        return this.getElementValues(JDOMTool.getJDOMXPath(xpath, namespaces).selectNodes((Object)this.rootElement));
    }

    private List<String> getElementValues(List<Element> elements) {
        if (elements == null || elements.size() == 0) {
            return null;
        }
        ArrayList<String> values = new ArrayList<String>();
        for (Element element : elements) {
            values.add(element.getTextNormalize());
        }
        return values;
    }

    public String getAttributeValue(String xpath) throws JaxenException {
        Attribute attribute = (Attribute)this.selectSingleNode(xpath);
        return attribute == null ? null : attribute.getValue();
    }

    public String getAttributeValue(String xpath, Namespace namespace) throws JaxenException {
        Attribute attribute = (Attribute)this.selectSingleNode(xpath, namespace);
        return attribute == null ? null : attribute.getValue();
    }

    public String getAttributeValue(String xpath, List<Namespace> namespaces) throws JaxenException {
        Attribute attribute = (Attribute)this.selectSingleNode(xpath, namespaces);
        return attribute == null ? null : attribute.getValue();
    }

    public boolean isNodeNull(String xpath) throws JaxenException {
        return this.selectSingleNode(xpath) == null;
    }

    public boolean isNodeNull(String xpath, Namespace namespace) throws JaxenException {
        return this.selectSingleNode(xpath, namespace) == null;
    }

    public boolean isNodeNull(String xpath, List<Namespace> namespaces) throws JaxenException {
        return this.selectSingleNode(xpath, namespaces) == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String outputString(Document document) {
        XMLOutputter xMLOutputter = outputter;
        synchronized (xMLOutputter) {
            return outputter.outputString(document);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String outputString(Element element) {
        XMLOutputter xMLOutputter = outputter;
        synchronized (xMLOutputter) {
            return outputter.outputString(element);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String outputString(List content) {
        XMLOutputter xMLOutputter = outputter;
        synchronized (xMLOutputter) {
            return outputter.outputString(content);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String outputString(Text xmlTextNode) {
        XMLOutputter xMLOutputter = outputter;
        synchronized (xMLOutputter) {
            return outputter.outputString(xmlTextNode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String outputString(CDATA cdata) {
        XMLOutputter xMLOutputter = outputter;
        synchronized (xMLOutputter) {
            return outputter.outputString(cdata);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String outputString(Comment comment) {
        XMLOutputter xMLOutputter = outputter;
        synchronized (xMLOutputter) {
            return outputter.outputString(comment);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        XMLOutputter xMLOutputter = outputter;
        synchronized (xMLOutputter) {
            return outputter.outputString(this.rootElement);
        }
    }
}

