/*
 * Decompiled with CFR 0.152.
 */
package org.spin.extension;

import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.util.ByteArrayDataSource;
import org.apache.log4j.Logger;
import org.spin.tools.FileUtils;
import org.spin.tools.config.ConfigException;
import org.spin.tools.config.ConfigTool;
import org.spin.tools.config.MailToolConfig;

public class MailTool {
    public static final String JAVA_MAIL_SMTP_HOST = "mail.smtp.host";
    public static final String JAVA_MAIL_MIME_TYPE = "text/plain";
    private static final Logger log = Logger.getLogger(MailTool.class);
    private static final boolean DEBUG = log.isDebugEnabled();
    private static final boolean INFO = log.isInfoEnabled();
    private final MailToolConfig config;
    private final Properties javaMailProperties;
    private static MailTool instance;

    public static synchronized MailTool getInstance() throws ConfigException {
        return instance != null ? instance : MailTool.getInstance(ConfigTool.loadMailToolConfig());
    }

    public static synchronized MailTool getInstance(MailToolConfig config) throws ConfigException {
        if (instance != null) {
            throw new ConfigException("Are you attempting to reload the application wide keystore? ");
        }
        instance = new MailTool(config);
        return instance;
    }

    private MailTool(MailToolConfig mailToolConfig) throws ConfigException {
        try {
            this.config = mailToolConfig;
            this.javaMailProperties = new Properties();
            this.javaMailProperties.put(JAVA_MAIL_SMTP_HOST, this.config.getHost());
        }
        catch (Exception e) {
            throw new ConfigException("Could not load MailTool", (Throwable)e);
        }
    }

    public MailToolConfig getMailToolConfig() {
        return this.config;
    }

    public void sendAdminNotification(String subject, String message) throws MessagingException {
        this.sendMail(this.config.getSender(), this.config.getRecipient(), subject, message, null, null);
    }

    public void sendAdminNotification(String subject, String message, String textAttachment, String textAttachmentName) throws MessagingException {
        this.sendMail(this.config.getSender(), this.config.getRecipient(), subject, message, textAttachment, textAttachmentName);
    }

    public void sendAdminNotification(String subject, String message, File attachment) throws MessagingException {
        this.sendMail(this.config.getSender(), this.config.getRecipient(), subject, message, attachment);
    }

    public void sendMail(String sender, String recipient, String subject, String message) throws MessagingException {
        this.sendMail(sender, new String[]{recipient}, subject, message, null, null);
    }

    public void sendMail(String sender, String recipient, String subject, String message, File attachment) throws MessagingException {
        try {
            this.sendMail(sender, new String[]{recipient}, subject, message, FileUtils.read((File)attachment), attachment.getName());
        }
        catch (IOException e) {
            throw new MessagingException(e.getMessage());
        }
    }

    public void sendMail(String sender, String recipient, String subject, String message, String textAttachment, String textAttachmentName) throws MessagingException {
        this.sendMail(sender, new String[]{recipient}, subject, message, textAttachment, textAttachmentName);
    }

    public void sendMail(String sender, String[] recipients, String subject, String message, String textAttachment, String attachmentName) throws MessagingException {
        if (DEBUG) {
            log.debug((Object)("Sending mail message " + sender + "," + subject + "," + message));
        }
        MimeMultipart mimeMultiPart = new MimeMultipart();
        if (textAttachment != null && textAttachment.length() > 0) {
            try {
                ByteArrayDataSource attachment = new ByteArrayDataSource(textAttachment, JAVA_MAIL_MIME_TYPE);
                MimeBodyPart mimeAttachmentPart = new MimeBodyPart();
                mimeAttachmentPart.setDataHandler(new DataHandler((DataSource)attachment));
                mimeAttachmentPart.setFileName(attachmentName);
                mimeMultiPart.addBodyPart((BodyPart)mimeAttachmentPart);
            }
            catch (IOException e) {
                throw new MessagingException("Coult not attach: " + textAttachment, (Exception)e);
            }
        }
        MimeBodyPart mimeMesagePart = new MimeBodyPart();
        mimeMesagePart.setText(message);
        mimeMultiPart.addBodyPart((BodyPart)mimeMesagePart);
        Session session = Session.getDefaultInstance((Properties)this.javaMailProperties, null);
        session.setDebug(DEBUG);
        InternetAddress[] recipientAddresses = new InternetAddress[recipients.length];
        for (int i = 0; i < recipients.length; ++i) {
            recipientAddresses[i] = new InternetAddress(recipients[i]);
        }
        MimeMessage msg = new MimeMessage(session);
        msg.setFrom((Address)new InternetAddress(sender));
        msg.setRecipients(Message.RecipientType.TO, (Address[])recipientAddresses);
        msg.setSubject(subject);
        msg.setContent((Multipart)mimeMultiPart);
        msg.setSentDate(new Date());
        Transport.send((Message)msg);
        if (INFO) {
            log.info((Object)"MailTool: email sent");
        }
    }
}

