/*
 * Decompiled with CFR 0.152.
 */
package net.shrine.adapter;

import java.util.HashMap;
import java.util.List;
import javax.xml.bind.JAXBException;
import net.shrine.adapter.AdapterAuditEntryCriteria;
import net.shrine.adapter.AdapterAuditEntryResultItem;
import net.shrine.adapter.AdapterAuditEntryResults;
import net.shrine.adapter.AdapterConfig;
import net.shrine.adapter.guard.AdapterQueryActionResult;
import net.shrine.adapter.guard.serialization.AdapterDAO;
import net.shrine.adapter.guard.serialization.AdapterDAOException;
import net.shrine.adapter.mapping.util.Pair;
import org.apache.log4j.Logger;
import org.spin.node.SerializationException;
import org.spin.node.actions.QueryAction;
import org.spin.node.actions.QueryException;
import org.spin.tools.JAXBUtils;
import org.spin.tools.config.ConfigException;
import org.spin.tools.crypto.signature.Identity;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdapterAuditEntryQuery
extends QueryAction<AdapterAuditEntryCriteria> {
    private AdapterConfig adapterConfig;
    private static Logger log = Logger.getLogger(AdapterAuditEntryQuery.class);
    final boolean DEBUG = log.isDebugEnabled();

    public AdapterAuditEntryQuery(AdapterConfig config) throws ConfigException {
        this.adapterConfig = config;
    }

    public AdapterAuditEntryQuery() throws ConfigException {
        this(AdapterConfig.getDefaultInstance());
    }

    protected String doPerform(AdapterAuditEntryCriteria criteria, Identity identity) throws QueryException {
        String serializedResults = "";
        AdapterAuditEntryResults results = null;
        try {
            results = this.queryAdapterAuditLog(null);
            serializedResults = JAXBUtils.marshalToString((Object)results);
        }
        catch (Exception e) {
            log.error((Object)"Error performing query.", (Throwable)e);
        }
        return serializedResults;
    }

    AdapterAuditEntryResults queryAdapterAuditLog(AdapterAuditEntryCriteria queryCriteria) throws AdapterDAOException {
        AdapterDAO adapterDAO = new AdapterDAO();
        List<AdapterQueryActionResult> adapterQueryActionResults = adapterDAO.readAll();
        HashMap<Pair<String, String>, AdapterAuditEntryResultItem> resultMap = new HashMap<Pair<String, String>, AdapterAuditEntryResultItem>();
        for (AdapterQueryActionResult adapterQueryActionResult : adapterQueryActionResults) {
            Pair<String, String> key = new Pair<String, String>(adapterQueryActionResult.getDomain(), adapterQueryActionResult.getUsername());
            if (resultMap.containsKey(key)) {
                ((AdapterAuditEntryResultItem)resultMap.get(key)).incrementQueries();
                continue;
            }
            boolean isLockedOut = adapterDAO.isLockedOut(key.getFirst(), key.getSecond(), this.adapterConfig.getLockoutAfterAttempts());
            AdapterAuditEntryResultItem newEntry = new AdapterAuditEntryResultItem(key.getFirst(), key.getSecond(), 1, isLockedOut);
            resultMap.put(key, newEntry);
        }
        AdapterAuditEntryResults results = new AdapterAuditEntryResults(resultMap.values());
        return results;
    }

    protected AdapterAuditEntryCriteria unmarshalCriteria(String criteriaXML) throws SerializationException {
        try {
            return (AdapterAuditEntryCriteria)((Object)JAXBUtils.unmarshal((String)criteriaXML, AdapterAuditEntryCriteria.class));
        }
        catch (JAXBException e) {
            throw new SerializationException((Throwable)e);
        }
    }
}

