/*
 * Decompiled with CFR 0.152.
 */
package net.shrine.adapter;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import javax.xml.bind.annotation.XmlRootElement;
import net.shrine.adapter.LocalHiveCredentials;
import org.apache.log4j.Logger;
import org.spin.tools.JAXBUtils;
import org.spin.tools.StringTools;
import org.spin.tools.Util;
import org.spin.tools.config.ConfigException;
import org.spin.tools.config.ConfigTool;

@XmlRootElement
public class AdapterConfig {
    protected static Logger log = Logger.getLogger(AdapterConfig.class);
    private static boolean DEBUG = log.isDebugEnabled();
    private static boolean INFO = log.isInfoEnabled();
    private static AdapterConfig defaultInstance = null;
    public static final String FILENAME_CONFIG = "adapter.xml";
    public static final int LOCKOUT_MAX_RETRIES_PER_SET_SIZE = 12;
    public HashMap<String, LocalHiveCredentials> credentials = Util.makeHashMap();
    private String crcURL;
    private String defaultProjectID;
    private int lockoutAfterAttempts = 12;
    public ArrayList<LocalHiveCredentials> privilegedAccount = Util.makeArrayList();
    private Long resultWaitTimeMS = 180000L;
    private boolean requireExplicitMappingsForEachItemKey = true;

    public String getCrcURL() {
        return this.crcURL;
    }

    public void setCrcURL(String crcURL) {
        this.crcURL = crcURL;
    }

    public String getDefaultProjectID() {
        return this.defaultProjectID;
    }

    public void setDefaultProjectID(String defaultProjectID) {
        this.defaultProjectID = defaultProjectID;
    }

    public int getLockoutAfterAttempts() {
        return this.lockoutAfterAttempts;
    }

    public void setLockoutAfterAttempts(int lockoutAfterAttempts) {
        this.lockoutAfterAttempts = lockoutAfterAttempts;
    }

    public Long getResultWaitTimeMS() {
        return this.resultWaitTimeMS;
    }

    public void setResultWaitTimeMS(Long resultWaitTimeMS) {
        this.resultWaitTimeMS = resultWaitTimeMS;
    }

    public LocalHiveCredentials getDefaultLocalHiveCredentials() {
        return this.credentials.get(this.defaultProjectID);
    }

    public static AdapterConfig getDefaultInstance() throws ConfigException {
        if (defaultInstance != null) {
            if (DEBUG) {
                log.debug((Object)"Returning adapter config cached instance....");
            }
        } else {
            defaultInstance = AdapterConfig.loadFromDisk();
        }
        return defaultInstance;
    }

    private static AdapterConfig loadFromDisk() throws ConfigException {
        if (INFO) {
            log.info((Object)"Loading adapter config from disk....");
        }
        try {
            File adapterConfFile = ConfigTool.getConfigFileWithFailover((String)FILENAME_CONFIG);
            if (INFO) {
                log.info((Object)("using adapter.xml + from " + adapterConfFile.getAbsolutePath()));
            }
            return (AdapterConfig)JAXBUtils.unmarshal((File)adapterConfFile, AdapterConfig.class);
        }
        catch (Exception e) {
            throw new ConfigException("Failed to load adapter config", (Throwable)e);
        }
    }

    public boolean isRequireExplicitMappingsForEachItemKey() {
        return this.requireExplicitMappingsForEachItemKey;
    }

    public void setRequireExplicitMappingsForEachItemKey(boolean requireExplicitMappingsForEachItemKey) {
        this.requireExplicitMappingsForEachItemKey = requireExplicitMappingsForEachItemKey;
    }

    public String toString() {
        String CRLF = StringTools.CRLF();
        StringBuffer sb = new StringBuffer();
        sb.append("CRC URL :\t" + this.getCrcURL());
        sb.append(CRLF);
        sb.append("Lockout :\t" + this.getLockoutAfterAttempts());
        sb.append(CRLF);
        sb.append("Timeout :\t" + this.getResultWaitTimeMS() + " ms");
        sb.append(CRLF);
        sb.append("RequireExplicitMappingsForEachItemKey :\t" + this.isRequireExplicitMappingsForEachItemKey());
        sb.append(CRLF);
        for (String project : this.credentials.keySet()) {
            LocalHiveCredentials localHive = this.credentials.get(project);
            sb.append("Domain:\t\t" + localHive.getDomain());
            sb.append(CRLF);
            sb.append("Username:\t" + localHive.getUsername());
            sb.append(CRLF);
            sb.append("Project:\t" + localHive.getProject());
            sb.append(CRLF);
            sb.append("Password:\t********");
            sb.append(CRLF);
        }
        return sb.toString();
    }
}

