/*
 * Decompiled with CFR 0.152.
 */
package net.shrine.adapter;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.Date;
import java.util.TreeMap;
import javax.xml.bind.JAXBException;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import net.shrine.adapter.SingleAdapterMapping;
import net.shrine.shrimp.OntologyException;
import org.apache.log4j.Logger;
import org.spin.tools.JAXBUtils;
import org.spin.tools.NetworkTime;
import org.spin.tools.config.ConfigException;
import org.spin.tools.config.ConfigTool;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlRootElement(name="AdapterMappings")
public class AdapterMappings {
    public static final String FILENAME_MAPPINGS = "AdapterMappings.xml";
    private static AdapterMappings defaultInstance = null;
    private static Logger log = Logger.getLogger(AdapterMappings.class);
    private static boolean DEBUG = log.isDebugEnabled();
    private static boolean INFO = log.isInfoEnabled();
    String hostname = ConfigTool.getHostName();
    Date timestamp = new Date();
    protected TreeMap<String, SingleAdapterMapping> mappings = new TreeMap();

    public static AdapterMappings loadFromFile(String mappingsFileName) throws ConfigException {
        return AdapterMappings.loadFromFile(ConfigTool.getConfigFileWithFailover((String)mappingsFileName));
    }

    public static AdapterMappings loadFromFile(File mappingsFileName) throws ConfigException {
        try {
            if (INFO) {
                log.info((Object)("Loading adapter mappings from disk : " + mappingsFileName.getAbsolutePath()));
            }
            AdapterMappings mappings = (AdapterMappings)JAXBUtils.unmarshal((File)mappingsFileName, AdapterMappings.class);
            return mappings;
        }
        catch (FileNotFoundException e) {
            log.error((Object)("Adapter Mapping File [AdapterMappings.xml] error: " + e));
            throw new ConfigException((Throwable)e);
        }
        catch (JAXBException e) {
            log.error((Object)("AdapterMappings.xml Unmarsalling error: " + (Object)((Object)e)));
            throw new ConfigException((Throwable)e);
        }
    }

    public static AdapterMappings getDefaultInstance() throws ConfigException {
        if (defaultInstance != null) {
            if (DEBUG) {
                log.debug((Object)"Returning adapter mappings cached instance....");
            }
        } else {
            AdapterMappings.setDefaultInstance(AdapterMappings.loadFromFile(FILENAME_MAPPINGS));
        }
        return defaultInstance;
    }

    private static void setDefaultInstance(AdapterMappings mappings) throws ConfigException {
        if (defaultInstance != null) {
            throw new ConfigException("re-setting default AdapterMappings!");
        }
        defaultInstance = mappings;
    }

    public String getHostname() {
        return this.hostname;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public TreeMap<String, SingleAdapterMapping> getMappings() {
        return this.mappings;
    }

    private String applyI2B2Prefix(String local_key) {
        String I2B2_PREFIX = "\\\\i2b2";
        if (!local_key.startsWith("\\i2b2")) {
            local_key = "\\\\i2b2" + local_key;
            if (DEBUG) {
                log.debug((Object)("Adding i2b2 prefix for local_key : " + local_key));
            }
        }
        return local_key;
    }

    public void addMapping(String core_key, String local_key) {
        local_key = this.applyI2B2Prefix(local_key);
        if (this.mappings.containsKey(core_key)) {
            if (this.mappings.get(core_key).getLocals().contains(local_key)) {
                log.warn((Object)("Skipping duplicate mapping " + core_key + " for local concept " + local_key));
            } else {
                if (DEBUG) {
                    log.debug((Object)("adding mapping " + core_key + " --> " + local_key));
                }
                this.mappings.get(core_key).addLocalMapping(local_key);
            }
        } else {
            if (DEBUG) {
                log.debug((Object)("First time seeing core concept " + core_key + " new local key is " + local_key));
            }
            this.mappings.put(core_key, new SingleAdapterMapping(local_key));
        }
    }

    public void combine(AdapterMappings other) throws OntologyException {
        if (this.timestamp.before(other.timestamp)) {
            this.timestamp = other.timestamp;
            this.hostname = other.hostname;
        }
        for (String other_core_key : other.getMappings().keySet()) {
            if (!this.mappings.containsKey(other_core_key)) continue;
            String error = "Duplicate key, unsupported behavior!" + other_core_key;
            log.error((Object)error);
            throw new OntologyException(error);
        }
        this.mappings.putAll(other.mappings);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("generated @ hostname=" + this.hostname);
        if (this.timestamp == null) {
            sb.append(" timestamp was not set");
        } else {
            String time = NetworkTime.makeXMLGregorianCalendar((Date)this.timestamp).toString();
            sb.append(" timestamp=" + time);
        }
        if (this.mappings.size() == 0) {
            sb.append(" with no actual key=value mappings!");
        } else {
            sb.append(" with mappings for " + this.mappings.size() + " key concepts.");
        }
        return sb.toString();
    }
}

