/*
 * Decompiled with CFR 0.152.
 */
package net.shrine.adapter;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.xml.bind.JAXBException;
import net.shrine.adapter.AdapterConfig;
import net.shrine.adapter.AdapterMappingException;
import net.shrine.adapter.AdapterMappings;
import net.shrine.adapter.CDATAQueryCriteria;
import net.shrine.adapter.LocalHiveCredentials;
import net.shrine.adapter.StopWatch;
import net.shrine.adapter.guard.AdapterQueryActionResult;
import net.shrine.adapter.guard.PatientSetFishingException;
import net.shrine.adapter.guard.serialization.AdapterDAO;
import net.shrine.adapter.guard.serialization.AdapterDAOException;
import net.shrine.cell.serializers.CRCResponseReader;
import org.apache.log4j.Logger;
import org.jdom.Element;
import org.spin.extension.HTTPClient;
import org.spin.extension.JDOMTool;
import org.spin.node.SerializationException;
import org.spin.node.actions.QueryAction;
import org.spin.node.actions.QueryException;
import org.spin.query.message.serializer.SerializerException;
import org.spin.tools.JAXBUtils;
import org.spin.tools.config.ConfigException;
import org.spin.tools.crypto.signature.Identity;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdapterQueryAction
extends QueryAction<CDATAQueryCriteria> {
    protected static Logger log = Logger.getLogger(AdapterQueryAction.class);
    protected static boolean DEBUG = log.isDebugEnabled();
    protected static boolean INFO = log.isInfoEnabled();
    protected AdapterConfig adapterConfig;
    protected boolean ready;
    private AdapterDAO adapterDAO;
    protected AdapterMappings adapterMappings = null;

    public AdapterQueryAction() throws ConfigException {
        this(AdapterConfig.getDefaultInstance(), AdapterMappings.getDefaultInstance());
    }

    protected AdapterQueryAction(AdapterConfig config, AdapterMappings mappings) {
        this.adapterConfig = config;
        this.adapterMappings = mappings;
        this.adapterDAO = new AdapterDAO();
        if (INFO) {
            log.info((Object)this.adapterConfig);
            log.info((Object)this.adapterMappings);
        }
        this.setReady(true);
    }

    protected String doPerform(CDATAQueryCriteria criteria, Identity identity) throws QueryException {
        try {
            this.checkForLockout(identity);
            String translatedXML = this.translate(criteria.getText());
            StopWatch stopWatch = new StopWatch();
            stopWatch.restart();
            CRCResponseReader reader = this.callCRC(translatedXML);
            stopWatch.stop();
            String networkID = criteria.getNetworkID();
            this.logAdapterQueryActionResult(networkID, identity, reader, stopWatch.getElapsed());
            this.obfuscate(reader);
            return reader.toXMLString();
        }
        catch (Exception e) {
            String SHRINE_304 = "See http://jira.open.med.harvard.edu/browse/SHRINE-304, details " + e.getMessage();
            return SHRINE_304;
        }
    }

    protected AdapterQueryActionResult logAdapterQueryActionResult(String networkQueryID, Identity identity, CRCResponseReader reader, long elapsedTimeMS) throws SerializerException, AdapterDAOException {
        AdapterQueryActionResult result = new AdapterQueryActionResult();
        result.setDomain(identity.getDomain());
        result.setUsername(identity.getUsername());
        result.setNetworkQueryID(networkQueryID);
        result.setCrcMasterQueryID(reader.getQueryMasterIDValue());
        result.setCrcInstanceQueryID(reader.getQueryInstanceIDValue());
        result.setCrcMasterQueryName(reader.getQueryMasterNameValue());
        result.setResultStatus(reader.getStatusConditionType());
        result.setResultSetSize(reader.getPatientSetCount());
        result.setResultXML(reader.toXMLString());
        result.setResultTimeElapsed(elapsedTimeMS);
        this.adapterDAO.create(result);
        return result;
    }

    protected void checkForLockout(Identity identity) throws AdapterDAOException, PatientSetFishingException {
        if (this.adapterConfig.getLockoutAfterAttempts() == 0) {
            log.warn((Object)"Adapter lockout Patient Set Fishing Guard is currently disabled.");
        } else if (this.isPrivilegedUser(identity)) {
            log.info((Object)("Adapter lockout Patient Set Fishing Guard SKIPPED for privileged user: " + String.valueOf(identity)));
        } else if (this.adapterDAO.isLockedOut(identity.getDomain(), identity.getUsername(), this.adapterConfig.getLockoutAfterAttempts())) {
            throw new PatientSetFishingException("Max number of identical query results for user=" + identity.getUsername() + " domain=" + identity.getDomain());
        }
    }

    boolean isPrivilegedUser(Identity identity) {
        ArrayList<LocalHiveCredentials> credentials = this.adapterConfig.privilegedAccount;
        for (LocalHiveCredentials credential : credentials) {
            if (!this.sameDomainAndUsername(credential, identity)) continue;
            return true;
        }
        return false;
    }

    private boolean sameDomainAndUsername(LocalHiveCredentials credential, Identity identity) {
        return String.valueOf(credential.getUsername()).equalsIgnoreCase(String.valueOf(identity.getUsername())) && String.valueOf(credential.getDomain()).equalsIgnoreCase(String.valueOf(identity.getDomain()));
    }

    public String translate(String rawXML) throws QueryException, AdapterMappingException {
        JDOMTool request = this.readRequestXML(rawXML);
        try {
            Element project_id = request.selectSingleElement("//project_id");
            String incommingProjectName = project_id.getTextNormalize();
            LocalHiveCredentials localHive = this.getLocalHiveCredentials(incommingProjectName);
            project_id.setText(localHive.getProject());
            Element security = request.selectSingleElement("//security");
            security.getChild("domain").setText(localHive.getDomain());
            security.getChild("username").setText(localHive.getUsername());
            security.getChild("password").setText(localHive.getPassword());
            if (this.adapterConfig.getResultWaitTimeMS() != null) {
                log.debug((Object)("Setting result wait time to " + this.adapterConfig.getResultWaitTimeMS()));
                Element resultWaitTimeMSElement = request.selectSingleElement("//result_waittime_ms");
                resultWaitTimeMSElement.setText(this.adapterConfig.getResultWaitTimeMS().toString());
            } else {
                log.debug((Object)"using default result wait time ms, OK");
            }
        }
        catch (Exception e) {
            log.error((Object)("FATAL ERROR: " + e));
            throw new QueryException("Error replacing local hive credentials.", (Throwable)e);
        }
        try {
            if (this.adapterMappings.getMappings().isEmpty()) {
                if (DEBUG) {
                    log.debug((Object)"No Translations found, performing direct pass through");
                }
            } else {
                List panels = request.selectNodes("//panel");
                for (Object panel : panels) {
                    if (panel != null) {
                        this.translateMappings((Element)panel, this.adapterMappings, this.adapterConfig.isRequireExplicitMappingsForEachItemKey());
                        continue;
                    }
                    log.debug((Object)"no panel found on that message");
                }
            }
        }
        catch (AdapterMappingException e) {
            throw e;
        }
        catch (Exception e) {
            throw new QueryException("Error translating shrine keys to local keys.", (Throwable)e);
        }
        return request.toString();
    }

    private LocalHiveCredentials getLocalHiveCredentials(String incommingProjectName) throws AdapterMappingException {
        LocalHiveCredentials localHive;
        if (!this.adapterConfig.credentials.containsKey(incommingProjectName)) {
            log.debug((Object)("no explicit adapter project mapping for " + incommingProjectName + " attempting to use default."));
            if (this.adapterConfig.getDefaultProjectID() == null) {
                throw new AdapterMappingException("no explicit mapping for project name " + incommingProjectName + " and no default project was not set in adapter config.");
            }
            localHive = this.adapterConfig.getDefaultLocalHiveCredentials();
        } else {
            localHive = this.adapterConfig.credentials.get(incommingProjectName);
        }
        return localHive;
    }

    private JDOMTool readRequestXML(String rawXML) throws QueryException {
        JDOMTool request = null;
        if (DEBUG) {
            log.debug((Object)rawXML);
        }
        try {
            request = new JDOMTool(rawXML);
        }
        catch (Exception e) {
            throw new QueryException("Could not read raw input CRC XML ");
        }
        return request;
    }

    protected void translateMappings(Element panel, AdapterMappings mappings, boolean requireExplicitMappings) throws AdapterMappingException {
        if (DEBUG) {
            log.debug((Object)"translateMappings(...)");
        }
        HashSet<String> panelLocalKeys = new HashSet<String>();
        ArrayList<Element> newChildren = new ArrayList<Element>();
        ArrayList<Element> untranslatedShrineElement = new ArrayList<Element>();
        for (Object item : panel.getChildren("item")) {
            Element itemElement = (Element)item;
            String shrine_key = itemElement.getChildTextTrim("item_key");
            if (DEBUG) {
                log.debug((Object)("Looking up mappings for shrine_key:" + shrine_key));
            }
            if (mappings.getMappings().containsKey(shrine_key)) {
                if (DEBUG) {
                    log.debug((Object)("Found shrine_key: " + shrine_key));
                }
                List<String> local_keys = mappings.getMappings().get(shrine_key).getLocals();
                for (String local_key : local_keys) {
                    if (!panelLocalKeys.contains(local_key)) {
                        Element nextItem = (Element)itemElement.clone();
                        Element nextItemKey = nextItem.getChild("item_key");
                        nextItemKey.setText(local_key);
                        if (DEBUG) {
                            log.debug((Object)("Item cloned: " + nextItem.getName()));
                        }
                        newChildren.add(nextItem);
                        panelLocalKeys.add(local_key);
                        continue;
                    }
                    if (!DEBUG) continue;
                    log.debug((Object)("skipping panel-duplicate local key: " + local_key));
                }
                if (local_keys.size() > 0) {
                    untranslatedShrineElement.add(itemElement);
                    continue;
                }
                throw new AdapterMappingException(shrine_key + " was listed in the AdapterMappings as a shrine_key with no local mappings (Invalid AdapterMappings file)");
            }
            log.warn((Object)("No mapping found for shrine_key: " + shrine_key));
            if (!requireExplicitMappings) continue;
            throw new AdapterMappingException("Missing required mapping for key " + shrine_key);
        }
        if (!newChildren.isEmpty()) {
            panel.addContent(newChildren);
            newChildren.clear();
        }
        if (!untranslatedShrineElement.isEmpty()) {
            for (Element untranslatedShrineKey : untranslatedShrineElement) {
                untranslatedShrineKey.detach();
            }
        }
    }

    public CRCResponseReader callCRCandObfuscate(String criteria) throws QueryException {
        CRCResponseReader reader = this.callCRC(criteria);
        this.obfuscate(reader);
        return reader;
    }

    protected CRCResponseReader callCRC(String criteria) throws QueryException {
        log.debug((Object)("sending to the local hive CRC instance @ " + this.adapterConfig.getCrcURL()));
        try {
            String crcSaid = HTTPClient.post((String)criteria, (String)this.adapterConfig.getCrcURL());
            if (DEBUG) {
                log.debug((Object)("CRC said , loading response reader. " + crcSaid));
            }
            CRCResponseReader reader = new CRCResponseReader(crcSaid);
            if (DEBUG) {
                log.debug((Object)("CRCResponseReader.getStatusConditionType = " + reader.getStatusConditionType()));
            }
            if (DEBUG) {
                log.debug((Object)("CRCResponseReader.getPatientSetCount = " + reader.getPatientSetCount()));
            }
            return reader;
        }
        catch (SerializerException e) {
            throw new QueryException("Failed to read crc response", (Throwable)e);
        }
        catch (ConfigException e) {
            throw new QueryException("Failed to use keystore", (Throwable)e);
        }
        catch (IOException e) {
            throw new QueryException("IO failure contacting CRC @" + this.adapterConfig.getCrcURL(), (Throwable)e);
        }
    }

    protected void obfuscate(CRCResponseReader reader) {
        if (reader.getPatientSetCount() != null) {
            reader.gaussianObfuscatePatientSetSize();
            if (DEBUG) {
                log.debug((Object)("CRCResponseReader.gaussianObfuscatePatientSetSize = " + reader.getPatientSetCount()));
            }
            if (DEBUG) {
                log.debug((Object)"CRCResponseReader is Reserializing with obfuscated counts");
            }
        }
    }

    protected CDATAQueryCriteria unmarshalCriteria(String queryCriteria) throws SerializationException {
        try {
            return (CDATAQueryCriteria)((Object)JAXBUtils.unmarshal((String)queryCriteria, CDATAQueryCriteria.class));
        }
        catch (JAXBException e) {
            throw new SerializationException((Throwable)e);
        }
    }

    public boolean isReady() {
        return this.ready;
    }

    private void setReady(boolean ready) {
        this.ready = ready;
    }

    public AdapterConfig getAdapterConfig() {
        return this.adapterConfig;
    }

    public AdapterMappings getAdapterMappings() {
        return this.adapterMappings;
    }
}

