/*
 * Decompiled with CFR 0.152.
 */
package net.shrine.adapter;

import net.shrine.adapter.CDATAQueryCriteria;
import org.apache.log4j.Logger;
import org.spin.node.SpinNodeImpl;
import org.spin.node.actions.QueryAction;
import org.spin.node.actions.QueryException;
import org.spin.node.logging.QueryLogger;
import org.spin.query.message.headers.QueryInfo;
import org.spin.query.message.headers.Result;
import org.spin.tools.JAXBUtils;
import org.spin.tools.config.ConfigException;
import org.spin.tools.config.NodeConfig;
import org.spin.tools.config.QueryStatus;
import org.spin.tools.config.RoutingTableConfig;
import org.spin.tools.crypto.signature.CertID;

public class ShrineNodeImpl
extends SpinNodeImpl {
    public static Logger log = Logger.getLogger(ShrineNodeImpl.class);
    private boolean DEBUG = log.isDebugEnabled();
    CertID nodeID;
    QueryLogger queryLog;

    public ShrineNodeImpl() throws ConfigException {
        this.init();
    }

    public ShrineNodeImpl(NodeConfig nodeConfig, RoutingTableConfig routingTableConfig) throws ConfigException {
        super(nodeConfig, routingTableConfig);
        this.init();
    }

    private void init() throws ConfigException {
        this.nodeID = super.getNodeID();
        this.queryLog = super.getQueryLogger();
    }

    public String doQueryAction(QueryInfo queryInfo, String criteriaXML) throws QueryException {
        String queryID = queryInfo.getQueryID();
        try {
            if (this.DEBUG) {
                log.debug((Object)("Looking up query action for " + queryInfo.getQueryType()));
            }
            QueryAction queryAction = super.getQueryMapContext().getQueryAction(queryInfo.getQueryType());
            CDATAQueryCriteria criteria = (CDATAQueryCriteria)((Object)JAXBUtils.unmarshal((String)criteriaXML, CDATAQueryCriteria.class));
            criteria.setNetworkID(queryID);
            String modifiedCriteriaXML = JAXBUtils.marshalToString((Object)((Object)criteria));
            if (this.DEBUG) {
                log.debug((Object)("Checking ready status for " + queryInfo.getQueryType()));
            }
            if (!queryAction.isReady()) {
                throw new QueryException("query (" + queryAction.getClass().getSimpleName() + ") not performed, QueryAction was not ready.  Perhaps it requires booting?");
            }
            if (this.DEBUG) {
                log.debug((Object)("Performing query " + queryInfo.getQueryType() + " " + queryInfo.getQueryID()));
            }
            String result = queryAction.perform(modifiedCriteriaXML, queryInfo.getIdentity());
            this.queryLog.logQueryCompletion(this.nodeID, queryID, QueryStatus.Success);
            return result;
        }
        catch (Exception e) {
            log.error((Object)"Query Action failed, logging error and constructing a Result that wraps the underlying Exception.");
            this.queryLog.logQueryCompletion(this.nodeID, queryID, QueryStatus.Failure);
            return this.makeErrorStatus(e);
        }
    }

    private String makeErrorStatus(Exception e) {
        try {
            return new Result(this.getNodeID(), false, e.getMessage()).toXML();
        }
        catch (Exception another) {
            log.error((Object)"Failed to serialize error message, returning unwrapped Exception Message.", (Throwable)e);
            return e.getMessage();
        }
    }
}

