/*
 * Decompiled with CFR 0.152.
 */
package net.shrine.adapter.guard.serialization;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.shrine.adapter.guard.AdapterQueryActionResult;
import net.shrine.adapter.guard.serialization.AdapterDAOException;
import net.shrine.adapter.guard.serialization.AdapterHibernateUtil;
import org.apache.log4j.Logger;
import org.hibernate.Criteria;
import org.hibernate.SessionFactory;
import org.hibernate.classic.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.spin.tools.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdapterDAO {
    private static final Logger log = Logger.getLogger(AdapterDAO.class);
    private static final boolean DEBUG = log.isDebugEnabled();
    private static SessionFactory sessionFactory = null;
    public static String PRIMARY_KEY = "entryID";
    public static boolean ORDER_ASC = true;

    public AdapterDAO() {
        if (sessionFactory == null) {
            sessionFactory = AdapterHibernateUtil.Instance.getSessionFactory();
        }
    }

    public void create(AdapterQueryActionResult entry) throws AdapterDAOException {
        if (DEBUG) {
            log.debug((Object)("Creating Adapter Result." + entry));
        }
        Session session = sessionFactory.openSession();
        try {
            session.beginTransaction();
            session.save((Object)entry);
            session.getTransaction().commit();
            if (DEBUG) {
                log.debug((Object)("Created entry " + entry.toString()));
            }
        }
        catch (RuntimeException e) {
            this.rollbackTransaction((org.hibernate.Session)session);
            throw new AdapterDAOException("Could not create entry", e);
        }
        catch (Error e) {
            throw new AdapterDAOException("Holy Fatal error batman!", e);
        }
        finally {
            session.close();
        }
    }

    public List<AdapterQueryActionResult> readAll() throws AdapterDAOException {
        return this.readAll(PRIMARY_KEY, ORDER_ASC);
    }

    public List<AdapterQueryActionResult> readAll(String orderBY, boolean orderAsc) throws AdapterDAOException {
        if (DEBUG) {
            log.debug((Object)"readAll() Adapter entries. ");
        }
        HashMap clauses = Util.makeHashMap();
        return this.read(clauses, orderBY, orderAsc);
    }

    public List<AdapterQueryActionResult> read(HashMap<String, Object> clauses, String orderBY, boolean orderAsc) throws AdapterDAOException {
        Session session = sessionFactory.openSession();
        Criteria criteria = session.createCriteria(AdapterQueryActionResult.class);
        for (Map.Entry<String, Object> entry : clauses.entrySet()) {
            criteria.add((Criterion)Restrictions.eq((String)entry.getKey(), (Object)entry.getValue()));
        }
        if (orderAsc) {
            criteria.addOrder(Order.asc((String)orderBY));
        } else {
            criteria.addOrder(Order.desc((String)orderBY));
        }
        List results = criteria.list();
        session.close();
        return results;
    }

    public void update(AdapterQueryActionResult entry) throws AdapterDAOException {
        if (DEBUG) {
            log.debug((Object)("update() called " + entry));
        }
        Session session = sessionFactory.openSession();
        try {
            session.beginTransaction();
            session.update((Object)entry);
            session.getTransaction().commit();
        }
        catch (RuntimeException e) {
            this.rollbackTransaction((org.hibernate.Session)session);
            throw new AdapterDAOException("Could not update entry", e);
        }
        finally {
            session.close();
        }
    }

    public void delete(AdapterQueryActionResult entry) throws AdapterDAOException {
        this.deleteObject(entry);
    }

    private void deleteObject(Object entry) throws AdapterDAOException {
        if (DEBUG) {
            log.debug((Object)("delete() called " + entry));
        }
        Session session = sessionFactory.openSession();
        try {
            session.beginTransaction();
            session.delete(entry);
            session.getTransaction().commit();
        }
        catch (RuntimeException e) {
            this.rollbackTransaction((org.hibernate.Session)session);
            throw new AdapterDAOException("Could not remove", e);
        }
        finally {
            session.close();
        }
    }

    private void rollbackTransaction(org.hibernate.Session session) {
        try {
            session.getTransaction().rollback();
        }
        catch (Exception e) {
            log.error((Object)"Failed to rollback Transaction", (Throwable)e);
        }
    }

    public static SessionFactory getSessionFactory() {
        return sessionFactory;
    }

    public void truncateTable() throws AdapterDAOException {
        log.warn((Object)"Truncating DB");
        for (AdapterQueryActionResult entry : this.readAll()) {
            this.delete(entry);
        }
    }

    public AdapterQueryActionResult findEntry(String username, String domain, int setSize) throws AdapterDAOException {
        HashMap clauses = Util.makeHashMap();
        clauses.put("username", username);
        clauses.put("domain", domain);
        clauses.put("resultSetSize", setSize);
        List<AdapterQueryActionResult> results = this.read(clauses, "entryID", true);
        if (results.size() > 1) {
            throw new AdapterDAOException("Multiple results for query!");
        }
        if (results.size() == 1) {
            return results.get(0);
        }
        log.debug((Object)("no entry found for user=" + username + " domain=" + domain + " resultSetSize=" + setSize));
        return null;
    }

    public boolean isLockedOut(String domain, String username, int greaterThan) throws AdapterDAOException {
        Session session = sessionFactory.openSession();
        Criteria criteria = session.createCriteria(AdapterQueryActionResult.class);
        criteria.add((Criterion)Restrictions.eq((String)"domain", (Object)domain));
        criteria.add((Criterion)Restrictions.eq((String)"username", (Object)username));
        HashMap userSpecificCounts = Util.makeHashMap();
        List results = criteria.list();
        for (AdapterQueryActionResult entry : results) {
            if (entry.getResultSetSize() == 0) {
                if (!DEBUG) continue;
                log.debug((Object)"not guarding set size 0, special case");
                continue;
            }
            if (userSpecificCounts.containsKey(entry.getResultSetSize())) {
                int occurences = (Integer)userSpecificCounts.get(entry.getResultSetSize());
                userSpecificCounts.put(entry.getResultSetSize(), ++occurences);
                if (occurences <= greaterThan) continue;
                log.warn((Object)("Max number of identical query results for user=" + username + " domain=" + domain));
                return true;
            }
            userSpecificCounts.put(entry.getResultSetSize(), 1);
        }
        session.close();
        return false;
    }

    public void deleteAll() throws AdapterDAOException {
        log.warn((Object)"Truncating Adapter Database!");
        for (AdapterQueryActionResult x : this.readAll()) {
            this.delete(x);
        }
    }
}

