/*
 * Decompiled with CFR 0.152.
 */
package net.shrine.adapter.guard.serialization;

import java.net.URL;
import net.shrine.adapter.guard.AdapterQueryActionResult;
import org.apache.log4j.Logger;
import org.hibernate.HibernateException;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.AnnotationConfiguration;
import org.hibernate.cfg.Configuration;
import org.spin.tools.config.ConfigTool;

public class AdapterHibernateUtil {
    private static final Logger log = Logger.getLogger(AdapterHibernateUtil.class);
    private static final boolean INFO = log.isInfoEnabled();
    private static final boolean DEBUG = log.isDebugEnabled();
    public static final String hibernateConfigFileName = "hibernate-admin.cfg.xml";
    public static final AdapterHibernateUtil Instance = new AdapterHibernateUtil();
    private final SessionFactory sessionFactory;
    private final String dbDriver;
    private final String dbUrl;
    private final String dataSourceName;

    private AdapterHibernateUtil() {
        this.addShutdownHook();
        try {
            URL configFile = ConfigTool.getConfigFileAsURL((String)hibernateConfigFileName);
            if (DEBUG) {
                log.debug((Object)("Initializing Hibernate with '" + configFile.getFile() + "'"));
            }
            Configuration config = new AnnotationConfiguration().addAnnotatedClass(AdapterQueryActionResult.class).configure(configFile);
            this.sessionFactory = config.buildSessionFactory();
            this.dbDriver = config.getProperty("connection.driver_class");
            this.dbUrl = config.getProperty("connection.url");
            this.dataSourceName = config.getProperty("connection.datasource");
        }
        catch (Throwable e) {
            log.error((Object)("Initial SessionFactory creation failed: " + e.getMessage()));
            throw new ExceptionInInitializerError(e);
        }
    }

    private void addShutdownHook() {
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            public void run() {
                try {
                    AdapterHibernateUtil.this.shutdownHibernate();
                }
                catch (Throwable e) {
                    log.error((Object)"Failed shutting down Spin query logging - the Node may take longer to start up next time, or the admin database may be corrupted: ", e);
                }
            }
        }));
    }

    public final SessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    public final String getDataSourceName() {
        return this.dataSourceName;
    }

    public final String getDBUrl() {
        return this.dbUrl;
    }

    public final String getDBDriver() {
        return this.dbDriver;
    }

    private void shutdownHibernate() {
        try {
            this.sessionFactory.close();
            if (INFO) {
                log.info((Object)"Shut down Spin Admin Hibernate SessionFactory");
            }
        }
        catch (HibernateException e) {
            log.error((Object)"Error shutting down Spin admin Hibernate SessionFactory");
            throw e;
        }
    }
}

