/*
 * Decompiled with CFR 0.152.
 */
package net.shrine.adapter.mapping.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import net.shrine.adapter.mapping.util.Pair;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdapterMappingTrieNode
implements Comparable<AdapterMappingTrieNode>,
Iterable<AdapterMappingTrieNode> {
    private static Logger log = Logger.getLogger(AdapterMappingTrieNode.class);
    private AdapterMappingTrieNode parent;
    private List<AdapterMappingTrieNode> children = new ArrayList<AdapterMappingTrieNode>();
    private String segment;
    private List<AdapterMappingTrieNode> mappings = new ArrayList<AdapterMappingTrieNode>();
    private String cachedPath = null;

    public AdapterMappingTrieNode() {
        this(null, null);
    }

    public AdapterMappingTrieNode(AdapterMappingTrieNode parent, String segment) {
        this.segment = segment;
        this.parent = parent;
        this.cachedPath = this.getPath();
    }

    public AdapterMappingTrieNode getParent() {
        return this.parent;
    }

    public List<AdapterMappingTrieNode> getMappings() {
        return this.mappings;
    }

    public List<AdapterMappingTrieNode> getChildren() {
        return Collections.unmodifiableList(this.children);
    }

    public boolean hasChildren() {
        return this.children.size() > 0;
    }

    public String getPath() {
        if (this.cachedPath != null) {
            return this.cachedPath;
        }
        return this.parent == null ? "\\\\" : this.parent.getPath() + this.segment;
    }

    public void addMapping(AdapterMappingTrieNode mapping) {
        this.mappings.add(mapping);
    }

    public AdapterMappingTrieNode getNode(String path) {
        Pair<String, String> segments = AdapterMappingTrieNode.splitNextSegment(path);
        String segment = segments.getFirst();
        String subpath = segments.getSecond();
        AdapterMappingTrieNode child = this.getChild(segment);
        if (child == null) {
            return child;
        }
        return subpath.length() == 0 ? child : child.getNode(subpath);
    }

    public AdapterMappingTrieNode addPath(String path) {
        Pair<String, String> segments = AdapterMappingTrieNode.splitNextSegment(path);
        String segment = segments.getFirst();
        String subpath = segments.getSecond();
        AdapterMappingTrieNode child = this.getChild(segment);
        if (child == null) {
            child = new AdapterMappingTrieNode(this, segment);
            this.children.add(child);
        }
        return subpath.length() == 0 ? child : child.addPath(subpath);
    }

    protected static Pair<String, String> splitNextSegment(String path) {
        int slashIdx;
        if (path == null) {
            return new Pair<String, String>("", "");
        }
        if (path.length() > 0) {
            while (path.charAt(0) == '\\') {
                path = path.substring(1);
            }
        }
        if ((slashIdx = path.indexOf(92)) == -1) {
            return new Pair<String, String>(path, "");
        }
        String segment = path.substring(0, slashIdx + 1);
        String subpath = path.substring(slashIdx + 1);
        return new Pair<String, String>(segment, subpath);
    }

    protected AdapterMappingTrieNode getChild(String segment) {
        for (AdapterMappingTrieNode child : this.children) {
            if (!child.segment.equals(segment)) continue;
            return child;
        }
        return null;
    }

    public String toString() {
        return "TrieNode [path=" + this.getPath() + "]";
    }

    public int hashCode() {
        return this.getPath().hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AdapterMappingTrieNode other = (AdapterMappingTrieNode)obj;
        return this.getPath().equals(other.getPath());
    }

    @Override
    public int compareTo(AdapterMappingTrieNode o) {
        return this.getPath().compareTo(o.getPath());
    }

    @Override
    public Iterator<AdapterMappingTrieNode> iterator() {
        return new TrieWalker(this);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class TrieWalker
    implements Iterator<AdapterMappingTrieNode> {
        private Stack<Pair<AdapterMappingTrieNode, Integer>> treePointer = new Stack();

        public TrieWalker(AdapterMappingTrieNode root) {
            this.pushLeftMostChildren(root);
        }

        private void pushLeftMostChildren(AdapterMappingTrieNode root) {
            AdapterMappingTrieNode current = root;
            this.push(new Pair<AdapterMappingTrieNode, Integer>(current, 0));
            while (current.hasChildren()) {
                current = current.getChildren().get(0);
                this.push(new Pair<AdapterMappingTrieNode, Integer>(current, 0));
            }
        }

        @Override
        public boolean hasNext() {
            boolean ret = false;
            if (!this.treePointer.empty()) {
                ret = this.treePointer.peek().getFirst().getParent() != null;
            }
            return ret;
        }

        private void push(Pair<AdapterMappingTrieNode, Integer> item) {
            this.treePointer.push(item);
        }

        private Pair<AdapterMappingTrieNode, Integer> pop() {
            return this.treePointer.pop();
        }

        @Override
        public AdapterMappingTrieNode next() {
            Pair<AdapterMappingTrieNode, Integer> nextPair = this.pop();
            AdapterMappingTrieNode nextNode = nextPair.getFirst();
            if (this.hasNext()) {
                Pair<AdapterMappingTrieNode, Integer> currentPair = this.pop();
                AdapterMappingTrieNode currentNode = currentPair.getFirst();
                int currentChild = currentPair.getSecond();
                this.push(new Pair<AdapterMappingTrieNode, Integer>(currentNode, currentChild + 1));
                if (currentNode.getChildren().size() > currentChild + 1) {
                    this.pushLeftMostChildren(currentNode.getChildren().get(currentChild + 1));
                }
            }
            return nextNode;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

