/*
 * Decompiled with CFR 0.152.
 */
package net.shrine.adapter.mapping.util;

import java.util.List;
import net.shrine.adapter.AdapterMappings;
import net.shrine.adapter.SingleAdapterMapping;
import net.shrine.adapter.mapping.util.AdapterMappingTrieNode;
import net.shrine.adapter.mapping.util.Pair;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdapterMappingsReducer {
    private static Logger log = Logger.getLogger(AdapterMappingsReducer.class);
    private static boolean DEBUG = false;
    private static boolean INFO = false;

    public static AdapterMappings reduce(AdapterMappings adapterMappings) {
        AdapterMappings result = new AdapterMappings();
        Pair<AdapterMappingTrieNode, AdapterMappingTrieNode> tries = AdapterMappingsReducer.loadMappings(adapterMappings);
        AdapterMappingTrieNode globalTrie = tries.getFirst();
        int found = 0;
        int mappingsSaved = 0;
        for (AdapterMappingTrieNode node : globalTrie) {
            String nodePath = node.getPath();
            List<AdapterMappingTrieNode> localMappings = node.getMappings();
            int nodeMappingSize = localMappings.size();
            if (nodeMappingSize <= 0) continue;
            if (DEBUG) {
                log.debug((Object)("Considering: (" + nodeMappingSize + ") " + nodePath + ": " + localMappings));
            }
            for (int i = 0; i < localMappings.size(); ++i) {
                AdapterMappingTrieNode mapping = localMappings.get(i);
                List<AdapterMappingTrieNode> siblings = mapping.getParent().getChildren();
                if (siblings.size() < 2) {
                    if (!DEBUG) continue;
                    log.debug((Object)("\tLocal Mapping:" + mapping.getPath() + " has sibling size < 2"));
                    continue;
                }
                if (!localMappings.containsAll(siblings)) {
                    if (!DEBUG) continue;
                    log.debug((Object)("\tLocal Mapping:" + mapping.getPath() + " !localMappings.containsAll(siblings): " + siblings));
                    continue;
                }
                AdapterMappingTrieNode parent = mapping.getParent();
                if (DEBUG) {
                    log.debug((Object)("\tLocal Mapping:" + mapping.getPath() + " is reducible to " + parent.getPath() + " removing [" + siblings.size() + "] " + siblings));
                }
                ++found;
                mappingsSaved += siblings.size() - 1;
                localMappings.removeAll(siblings);
                if (!localMappings.contains(parent)) {
                    localMappings.add(parent);
                }
                i = 0;
            }
            if (DEBUG) {
                log.debug((Object)("Returning: (" + nodeMappingSize + ") " + nodePath + " " + localMappings));
            }
            result.getMappings().put(nodePath, AdapterMappingsReducer.createSingleAdapterMapping(node));
        }
        log.debug((Object)("Reduce Found " + found + " potential matches, saving up to " + mappingsSaved + " keys."));
        return result;
    }

    private static SingleAdapterMapping createSingleAdapterMapping(AdapterMappingTrieNode node) {
        SingleAdapterMapping ret = null;
        for (AdapterMappingTrieNode mapping : node.getMappings()) {
            if (null == ret) {
                ret = new SingleAdapterMapping(mapping.getPath());
                continue;
            }
            ret.addLocalMapping(mapping.getPath());
        }
        return ret;
    }

    private static Pair<AdapterMappingTrieNode, AdapterMappingTrieNode> loadMappings(AdapterMappings adapterMappings) {
        if (DEBUG) {
            log.debug((Object)"Consuming adapter mappings");
        }
        AdapterMappingTrieNode globalTrie = new AdapterMappingTrieNode();
        AdapterMappingTrieNode localTrie = new AdapterMappingTrieNode();
        for (String globalKey : adapterMappings.getMappings().keySet()) {
            AdapterMappingTrieNode global = globalTrie.addPath(globalKey);
            for (String localKey : adapterMappings.getMappings().get(globalKey).getLocals()) {
                AdapterMappingTrieNode local = localTrie.addPath(localKey);
                global.addMapping(local);
            }
        }
        return new Pair<AdapterMappingTrieNode, AdapterMappingTrieNode>(globalTrie, localTrie);
    }
}

