/*
 * Decompiled with CFR 0.152.
 */
package net.shrine.cell.serializers;

import net.shrine.cell.serializers.CRCXpath;
import net.shrine.cell.serializers.I2B2CustomJDOMReader;
import org.apache.log4j.Logger;
import org.spin.query.message.serializer.SerializerException;

public class CRCRequestReader
extends I2B2CustomJDOMReader {
    protected static Logger log = Logger.getLogger(CRCRequestReader.class);
    protected static boolean DEBUG = log.isDebugEnabled();
    protected static boolean INFO = log.isInfoEnabled();

    public CRCRequestReader(String xml) throws SerializerException {
        super(xml);
    }

    public RequestTypeAliases getRequestType() throws SerializerException {
        try {
            String requestType = this.jdom.getElementValue(CRCXpath.REQUEST_TYPE.xpath);
            if (requestType.equals(RequestTypeAliases.AdapterQueryAction.i2b2Equivilant)) {
                return RequestTypeAliases.AdapterQueryAction;
            }
            if (requestType.equals(RequestTypeAliases.getQueryInstanceList.i2b2Equivilant)) {
                return RequestTypeAliases.getQueryInstanceList;
            }
            if (requestType.equals(RequestTypeAliases.getResultInstanceList.i2b2Equivilant)) {
                return RequestTypeAliases.getResultInstanceList;
            }
            if (requestType.equals(RequestTypeAliases.getPreviousQueries.i2b2Equivilant)) {
                return RequestTypeAliases.getPreviousQueries;
            }
            if (requestType.equals(RequestTypeAliases.readApprovedEntries.i2b2Equivilant)) {
                return RequestTypeAliases.readApprovedEntries;
            }
            return RequestTypeAliases.unsupported;
        }
        catch (Exception e) {
            throw new SerializerException("Failed to read query type from i2b2 request", e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum RequestTypeAliases {
        AdapterQueryAction("CRC_QRY_runQueryInstance_fromQueryDefinition"),
        getResultInstanceList("CRC_QRY_getQueryResultInstanceList_fromQueryInstanceId"),
        getQueryInstanceList("CRC_QRY_getQueryInstanceList_fromQueryMasterId"),
        getPreviousQueries("CRC_QRY_getQueryMasterList_fromUserId"),
        readApprovedEntries("SHERIFF_QRY_readApprovedEntries"),
        unsupported(null);

        public String i2b2Equivilant;

        private RequestTypeAliases(String i2b2Equivilant) {
            this.i2b2Equivilant = i2b2Equivilant;
        }
    }
}

