/*
 * Decompiled with CFR 0.152.
 */
package net.shrine.cell.serializers;

import net.shrine.adapter.guard.GaussianObfuscator;
import net.shrine.cell.serializers.CRCXpath;
import net.shrine.cell.serializers.I2B2CustomJDOMReader;
import org.apache.log4j.Logger;
import org.jdom.Element;
import org.spin.query.message.serializer.SerializerException;

public class CRCResponseReader
extends I2B2CustomJDOMReader {
    protected static Logger log = Logger.getLogger(CRCResponseReader.class);
    protected static boolean DEBUG = log.isDebugEnabled();
    protected static boolean INFO = log.isInfoEnabled();
    private String statusConditionType;
    private Element queryResultInstance;
    private Element setSizeElement;

    public CRCResponseReader(String xml) throws SerializerException {
        block9: {
            super(xml);
            try {
                this.statusConditionType = this.jdom.selectSingleElement(CRCXpath.QUERY_STATUS_TYPE_DESCRIPTION.xpath).getTextNormalize();
                if (DEBUG) {
                    log.debug((Object)("statusConditionType is " + this.statusConditionType));
                }
                if (this.isError()) {
                    log.error((Object)("status condition from the CRC was error: " + this.getStatusConditionType()));
                }
            }
            catch (Exception e) {
                throw new SerializerException("Could not read response body status code.", e);
            }
            try {
                this.queryResultInstance = this.jdom.selectSingleElement(CRCXpath.QUERY_RESULT_INSTANCE.xpath);
                String queryResultTypeName = this.queryResultInstance.getChild(CRCXpath.QUERY_RESULT_TYPE.xpath).getChildText("name");
                boolean isVersion1dot2 = queryResultTypeName.equals(CRCXpath.I2B2_1_2_RESULT_INSTANCE_TYPE.xpath);
                boolean isVersion1dot3 = queryResultTypeName.equals(CRCXpath.I2B2_1_3_RESULT_INSTANCE_TYPE.xpath);
                if (DEBUG) {
                    log.debug((Object)("Result instance for i2b2 version " + (isVersion1dot2 ? "1.2" : (isVersion1dot3 ? "1.3" : "Unknown"))));
                }
                if (isVersion1dot2 || isVersion1dot3) {
                    this.setSizeElement = this.queryResultInstance.getChild("set_size");
                    if (DEBUG) {
                        log.debug((Object)("patientSetCount " + this.getPatientSetCount()));
                    }
                    break block9;
                }
                throw new SerializerException("Could not determine query_result_instance for unknown i2b2 version.");
            }
            catch (Exception e) {
                throw new SerializerException("Could not read patient count.", e);
            }
        }
    }

    public String getStatusConditionType() {
        return this.statusConditionType;
    }

    public boolean isCompleted() {
        return this.getStatusConditionType().equals("COMPLETED");
    }

    public boolean isIncomplete() {
        return this.getStatusConditionType().equals("INCOMPLETE");
    }

    public boolean isError() {
        return this.getStatusConditionType().equals("ERROR");
    }

    public void gaussianObfuscatePatientSetSize() {
        Integer blurred = GaussianObfuscator.obfuscate(this.getPatientSetCount());
        this.setSizeElement.setText(blurred.toString());
    }

    public Integer getPatientSetCount() {
        if (this.setSizeElement == null) {
            log.error((Object)"Patient set size was not returned in the XML");
            return null;
        }
        try {
            return new Integer(this.setSizeElement.getValue());
        }
        catch (Exception e) {
            log.error((Object)"Patient set size was invalid");
            return null;
        }
    }

    public Element getQueryResultInstance() {
        return this.queryResultInstance;
    }
}

