/*
 * Decompiled with CFR 0.152.
 */
package net.shrine.cell.serializers;

import net.shrine.cell.serializers.CRCXpath;
import org.apache.log4j.Logger;
import org.jdom.Element;
import org.spin.extension.JDOMTool;
import org.spin.query.message.serializer.SerializerException;

public class I2B2CustomJDOMReader {
    protected static Logger log = Logger.getLogger(I2B2CustomJDOMReader.class);
    protected static boolean DEBUG = log.isDebugEnabled();
    protected static boolean INFO = log.isInfoEnabled();
    protected JDOMTool jdom;

    public I2B2CustomJDOMReader(String xml) throws SerializerException {
        if (xml == null) {
            throw new SerializerException("input XML was null, cannot read i2b2 message.");
        }
        try {
            this.jdom = new JDOMTool(xml);
            if (DEBUG) {
                log.debug((Object)("I2B2CustomResponseReader:" + this.jdom.toString()));
            }
        }
        catch (Exception e) {
            throw new SerializerException("Failed to read i2b2 response.", e);
        }
    }

    public Element getRootElement() {
        return this.jdom.getRootElement();
    }

    public String toXMLString() {
        return JDOMTool.outputString((Element)this.getRootElement());
    }

    private Element getSingleElement(String xpath) throws SerializerException {
        try {
            if (this.jdom.isNodeNull(xpath)) {
                log.warn((Object)("xpath was null " + xpath));
                return null;
            }
            return this.jdom.selectSingleElement(xpath);
        }
        catch (Exception e) {
            throw new SerializerException("could not read from xpath " + xpath, e);
        }
    }

    private Integer getElementIntegerValue(String xpath) throws SerializerException {
        Element element = this.getSingleElement(xpath);
        return element == null ? null : new Integer(element.getValue());
    }

    private String getElementStringValue(String xpath) throws SerializerException {
        Element element = this.getSingleElement(xpath);
        return element == null ? null : element.getValue();
    }

    public Element getQueryMasterIDElement() throws SerializerException {
        return this.getSingleElement(CRCXpath.QUERY_MASTER_ID.xpath);
    }

    public Integer getQueryMasterIDValue() throws SerializerException {
        return this.getElementIntegerValue(CRCXpath.QUERY_MASTER_ID.xpath);
    }

    public Element getQueryInstanceIDElement() throws SerializerException {
        return this.getSingleElement(CRCXpath.QUERY_INSTANCE_ID.xpath);
    }

    public Integer getQueryInstanceIDValue() throws SerializerException {
        return this.getElementIntegerValue(CRCXpath.QUERY_INSTANCE_ID.xpath);
    }

    public Integer getQueryTopicID() throws SerializerException {
        return this.getElementIntegerValue(CRCXpath.SHERIFF_QUERY_TOPIC_ID.xpath);
    }

    public String getQueryMasterNameValue() throws SerializerException {
        return this.getElementStringValue(CRCXpath.QUERY_MASTER_NAME.xpath);
    }
}

