/*
 * Decompiled with CFR 0.152.
 */
package net.shrine.cell.serializers;

import java.util.HashMap;
import net.shrine.cell.serializers.I2B2CustomJDOMReader;
import net.shrine.cell.serializers.PMXpath;
import org.jdom.Element;
import org.spin.query.message.serializer.SerializerException;
import org.spin.tools.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PMResponseReader
extends I2B2CustomJDOMReader {
    public static final String SHERIFF_BROADCASTER = "SHERIFF_BROADCASTER";
    private String resultStatusType;
    private String ecommonsUsername;
    private HashMap<String, String> cellURLs = Util.makeHashMap();

    public PMResponseReader(String response) throws SerializerException {
        super(response);
        try {
            Element status = this.jdom.selectSingleElement(PMXpath.STATUS.xpath);
            this.resultStatusType = status.getAttributeValue("type");
            log.debug((Object)("resultStatusType=" + this.resultStatusType));
            if (this.isDone()) {
                Element ecommons;
                if (!this.jdom.isNodeNull(PMXpath.ECOMMONS.xpath)) {
                    this.ecommonsUsername = this.jdom.getElementValue("//param[@name='ecommons_username']");
                }
                if (DEBUG) {
                    log.debug((Object)("ecommonsUsername " + this.ecommonsUsername));
                }
                if ((ecommons = this.jdom.selectSingleElement(PMXpath.ECOMMONS.xpath)) != null) {
                    this.ecommonsUsername = ecommons.getTextNormalize();
                    if (DEBUG) {
                        log.debug((Object)("ecommonsUsername " + this.ecommonsUsername));
                    }
                }
                Element cell_datas = this.jdom.selectSingleElement(PMXpath.CELL_DATAS.xpath);
                for (Object child : cell_datas.getChildren()) {
                    Element cell_data = (Element)child;
                    if (!cell_data.getName().equalsIgnoreCase("cell_data")) {
                        throw new SerializerException("invalid XML " + cell_data.getName());
                    }
                    String id = cell_data.getAttribute("id").getValue();
                    String url = cell_data.getChildTextNormalize("url");
                    log.debug((Object)("Found CELL id=" + id + " url=" + url));
                    this.cellURLs.put(id, url);
                }
            }
        }
        catch (Exception e) {
            throw new SerializerException("Could not read PM result status", e);
        }
    }

    public String getResultStatusType() {
        return this.resultStatusType;
    }

    public boolean isDone() {
        return this.resultStatusType.equalsIgnoreCase("DONE");
    }

    public boolean isError() {
        return this.resultStatusType.equalsIgnoreCase("ERROR");
    }

    public HashMap<String, String> getCellUrls() {
        return this.cellURLs;
    }

    public String getSheriffBroadcasterCellURL() {
        return PMResponseReader.stripTrailingSlashFromWebserviceURL(this.cellURLs.get(SHERIFF_BROADCASTER));
    }

    public static String stripTrailingSlashFromWebserviceURL(String url) {
        if (url.endsWith("webservice/")) {
            if (DEBUG) {
                log.debug((Object)("Sheriff URL contained bad trailing slash, removing now..." + url));
            }
            String cleaned = url.replace("webservice/", "webservice");
            if (DEBUG) {
                log.debug((Object)("Sheriff URL cleaned = " + cleaned));
            }
            return cleaned;
        }
        if (DEBUG) {
            log.debug((Object)("is clean url = " + url));
        }
        return url;
    }

    public String getEcommonsUsername() {
        return this.ecommonsUsername;
    }
}

