/*
 * Decompiled with CFR 0.152.
 */
package net.shrine.shrimp;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import net.shrine.shrimp.OntologyException;
import org.apache.log4j.Logger;
import org.jaxen.JaxenException;
import org.jdom.JDOMException;
import org.spin.extension.HTTPClient;
import org.spin.extension.JDOMTool;
import org.spin.tools.NetworkTime;
import org.spin.tools.Util;
import org.spin.tools.config.ConfigException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OntologyClient {
    protected static Logger log = Logger.getLogger(OntologyClient.class);
    protected static boolean DEBUG = log.isDebugEnabled();
    protected static boolean INFO = log.isInfoEnabled();
    private static final String SLASH = "\\\\";
    private String domain;
    private String username;
    private String password;
    private String project;
    private String baseURL;
    private static HashMap<String, String> cachedVisualAttributes = new HashMap();
    private static final String ONT_REQUEST_OPEN = "<ns3:request xmlns:ns3=\"http://www.i2b2.org/xsd/hive/msg/1.1/\" xmlns:ns4=\"http://www.i2b2.org/xsd/cell/ont/1.1/\" xmlns:ns2=\"http://www.i2b2.org/xsd/hive/plugin/\">\n    <message_header>\n        <i2b2_version_compatible>1.1</i2b2_version_compatible>\n        <hl7_version_compatible>2.4</hl7_version_compatible>\n        <sending_application>\n            <application_name>i2b2 Ontology </application_name>\n            <application_version>1.2</application_version>\n        </sending_application>\n        <sending_facility>\n            <facility_name>i2b2 Hive</facility_name>\n        </sending_facility>\n        <receiving_application>\n            <application_name>Ontology Cell</application_name>\n            <application_version>1.0</application_version>\n        </receiving_application>\n        <receiving_facility>\n            <facility_name>i2b2 Hive</facility_name>\n        </receiving_facility>\n        <datetime_of_message>@@@DATETIME_OF_MESSAGE@@@</datetime_of_message>\n\t\t<security>\n\t\t\t<domain>@@@DOMAIN@@@</domain>\n\t\t\t<username>@@@USERNAME@@@</username>\n\t\t\t<password>@@@PASSWORD@@@</password>\n\t\t</security>\n        <processing_id>\n            <processing_id>P</processing_id>\n            <processing_mode>I</processing_mode>\n        </processing_id>\n        <accept_acknowledgement_type>AL</accept_acknowledgement_type>\n        <application_acknowledgement_type>AL</application_acknowledgement_type>\n        <country_code>US</country_code>\n        <project_id>@@@PROJECT@@@</project_id>\n    </message_header>\n    <request_header>\n        <result_waittime_ms>180000</result_waittime_ms>\n    </request_header>";
    private static final String ONT_GET_CODE_INFO_MESSAGE_BODY = "    <message_body>\n        <ns4:get_code_info blob=\"false\" type=\"core\" max=\"300\" synonyms=\"false\" hiddens=\"true\">\n           <match_str strategy=\"exact\">@@@CODE@@@</match_str>        </ns4:get_code_info>\n    </message_body>";
    private static final String ONT_REQUEST_CLOSE = "</ns3:request>";
    private static final String ONT_GET_CODE_INFO_REQUEST = "<ns3:request xmlns:ns3=\"http://www.i2b2.org/xsd/hive/msg/1.1/\" xmlns:ns4=\"http://www.i2b2.org/xsd/cell/ont/1.1/\" xmlns:ns2=\"http://www.i2b2.org/xsd/hive/plugin/\">\n    <message_header>\n        <i2b2_version_compatible>1.1</i2b2_version_compatible>\n        <hl7_version_compatible>2.4</hl7_version_compatible>\n        <sending_application>\n            <application_name>i2b2 Ontology </application_name>\n            <application_version>1.2</application_version>\n        </sending_application>\n        <sending_facility>\n            <facility_name>i2b2 Hive</facility_name>\n        </sending_facility>\n        <receiving_application>\n            <application_name>Ontology Cell</application_name>\n            <application_version>1.0</application_version>\n        </receiving_application>\n        <receiving_facility>\n            <facility_name>i2b2 Hive</facility_name>\n        </receiving_facility>\n        <datetime_of_message>@@@DATETIME_OF_MESSAGE@@@</datetime_of_message>\n\t\t<security>\n\t\t\t<domain>@@@DOMAIN@@@</domain>\n\t\t\t<username>@@@USERNAME@@@</username>\n\t\t\t<password>@@@PASSWORD@@@</password>\n\t\t</security>\n        <processing_id>\n            <processing_id>P</processing_id>\n            <processing_mode>I</processing_mode>\n        </processing_id>\n        <accept_acknowledgement_type>AL</accept_acknowledgement_type>\n        <application_acknowledgement_type>AL</application_acknowledgement_type>\n        <country_code>US</country_code>\n        <project_id>@@@PROJECT@@@</project_id>\n    </message_header>\n    <request_header>\n        <result_waittime_ms>180000</result_waittime_ms>\n    </request_header>    <message_body>\n        <ns4:get_code_info blob=\"false\" type=\"core\" max=\"300\" synonyms=\"false\" hiddens=\"true\">\n           <match_str strategy=\"exact\">@@@CODE@@@</match_str>        </ns4:get_code_info>\n    </message_body></ns3:request>";
    private static final String ONT_GET_TERM_INFO_MESSAGE_BODY = "    <message_body>\n        <ns4:get_term_info max=\"200\" hiddens=\"false\" synonyms=\"false\" type=\"default\" blob=\"true\">\n           <self>@@@TERM@@@</self>        </ns4:get_term_info>\n    </message_body>";
    private static final String ONT_GET_TERM_INFO_REQUEST = "<ns3:request xmlns:ns3=\"http://www.i2b2.org/xsd/hive/msg/1.1/\" xmlns:ns4=\"http://www.i2b2.org/xsd/cell/ont/1.1/\" xmlns:ns2=\"http://www.i2b2.org/xsd/hive/plugin/\">\n    <message_header>\n        <i2b2_version_compatible>1.1</i2b2_version_compatible>\n        <hl7_version_compatible>2.4</hl7_version_compatible>\n        <sending_application>\n            <application_name>i2b2 Ontology </application_name>\n            <application_version>1.2</application_version>\n        </sending_application>\n        <sending_facility>\n            <facility_name>i2b2 Hive</facility_name>\n        </sending_facility>\n        <receiving_application>\n            <application_name>Ontology Cell</application_name>\n            <application_version>1.0</application_version>\n        </receiving_application>\n        <receiving_facility>\n            <facility_name>i2b2 Hive</facility_name>\n        </receiving_facility>\n        <datetime_of_message>@@@DATETIME_OF_MESSAGE@@@</datetime_of_message>\n\t\t<security>\n\t\t\t<domain>@@@DOMAIN@@@</domain>\n\t\t\t<username>@@@USERNAME@@@</username>\n\t\t\t<password>@@@PASSWORD@@@</password>\n\t\t</security>\n        <processing_id>\n            <processing_id>P</processing_id>\n            <processing_mode>I</processing_mode>\n        </processing_id>\n        <accept_acknowledgement_type>AL</accept_acknowledgement_type>\n        <application_acknowledgement_type>AL</application_acknowledgement_type>\n        <country_code>US</country_code>\n        <project_id>@@@PROJECT@@@</project_id>\n    </message_header>\n    <request_header>\n        <result_waittime_ms>180000</result_waittime_ms>\n    </request_header>    <message_body>\n        <ns4:get_term_info max=\"200\" hiddens=\"false\" synonyms=\"false\" type=\"default\" blob=\"true\">\n           <self>@@@TERM@@@</self>        </ns4:get_term_info>\n    </message_body></ns3:request>";

    public OntologyClient(String domain, String username, String password, String project, String baseURL) {
        this.domain = domain;
        this.username = username;
        this.password = password;
        this.project = project;
        this.baseURL = baseURL;
    }

    public List<String> getParentFoldersPathsInKey(String key) throws OntologyException, ConfigException, IOException, JDOMException, JaxenException {
        ArrayList parentFolders = Util.makeArrayList();
        for (String path : OntologyClient.getAllPathsInKey(key)) {
            String visualAttribute;
            if (cachedVisualAttributes.containsKey(path = OntologyClient.escapeSlash(path))) {
                visualAttribute = cachedVisualAttributes.get(path);
            } else {
                visualAttribute = this.getTermInfoVisualAttribute(path);
                cachedVisualAttributes.put(path, visualAttribute);
            }
            if (visualAttribute == null) {
                throw new OntologyException("Failed to get_term_info for " + key);
            }
            if (visualAttribute.startsWith("FA") || visualAttribute.startsWith("LA")) {
                log.debug((Object)"Folder, continue searching the hierarchy. ");
                path = OntologyClient.unEscapeSlash(path);
                parentFolders.add(path);
                continue;
            }
            if (visualAttribute.startsWith("C")) {
                log.debug((Object)"Container found, breaking now.... ");
                break;
            }
            throw new OntologyException("Impossible visual attribute type " + visualAttribute);
        }
        return parentFolders;
    }

    public static String escapeSlash(String string) {
        return string.replaceAll(SLASH, "\\\\\\\\");
    }

    public static String unEscapeSlash(String string) {
        return string.replaceAll("\\\\\\\\", SLASH);
    }

    public static List<String> getAllPathsInKey(String key) {
        if (key == null) {
            log.warn((Object)"WARNING! getAllPathsInKey was provided a NULL key!");
            return new ArrayList<String>();
        }
        List<String> tokens = Arrays.asList(key.split(SLASH));
        ArrayList<String> paths = new ArrayList<String>();
        String last = null;
        for (String path : tokens) {
            if (path.length() < 2) continue;
            last = last == null ? SLASH + path : last + "\\" + path;
            paths.add(last + "\\");
        }
        if (DEBUG) {
            log.debug((Object)"Reverse sorting path info....");
        }
        ArrayList<String> reverseSorted = new ArrayList<String>();
        for (int i = paths.size() - 1; i > 0; --i) {
            String path = (String)paths.get(i);
            if (DEBUG) {
                log.debug((Object)path);
            }
            reverseSorted.add(path);
        }
        return reverseSorted;
    }

    public List<String> getKeyByCode(String code) throws OntologyException, ConfigException, IOException, JDOMException, JaxenException {
        if (DEBUG) {
            log.debug((Object)("getKeyByCode " + code));
        }
        String request = this.getGenericOntRequest(ONT_GET_CODE_INFO_REQUEST).replaceFirst("@@@CODE@@@", code);
        if (DEBUG) {
            log.debug((Object)request);
        }
        String response = HTTPClient.post((String)request, (URL)new URL(this.baseURL + "getCodeInfo"));
        if (DEBUG) {
            log.debug((Object)("response: " + response));
        }
        JDOMTool jdom = new JDOMTool(response);
        return jdom.getElementValues("//concept/key");
    }

    public String getTermInfoVisualAttribute(String term) throws ConfigException, IOException, JDOMException, JaxenException {
        String request = this.getGenericOntRequest(ONT_GET_TERM_INFO_REQUEST);
        request = request.replaceFirst("@@@TERM@@@", term);
        if (DEBUG) {
            log.debug((Object)request);
        }
        String response = HTTPClient.post((String)request, (URL)new URL(this.baseURL + "getTermInfo"));
        if (DEBUG) {
            log.debug((Object)("response: " + response));
        }
        JDOMTool jdom = new JDOMTool(response);
        return jdom.getElementValue("//concept/visualattributes");
    }

    private String getGenericOntRequest(String XML) {
        XML = XML.replaceFirst("@@@DATETIME_OF_MESSAGE@@@", new NetworkTime().toString());
        XML = XML.replaceFirst("@@@DOMAIN@@@", this.domain);
        XML = XML.replaceFirst("@@@USERNAME@@@", this.username);
        XML = XML.replaceFirst("@@@PASSWORD@@@", this.password);
        XML = XML.replaceFirst("@@@PROJECT@@@", this.project);
        return XML;
    }
}

