/*
 * Decompiled with CFR 0.152.
 */
package net.shrine.shrimp;

import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.List;
import javax.xml.bind.JAXBException;
import net.shrine.adapter.AdapterMappings;
import net.shrine.shrimp.FragmentMapping;
import net.shrine.shrimp.OntologyClient;
import net.shrine.shrimp.OntologyException;
import net.shrine.shrimp.ShrimpETLConfig;
import org.apache.log4j.Logger;
import org.jaxen.JaxenException;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.spin.extension.JDOMTool;
import org.spin.tools.FileUtils;
import org.spin.tools.Guard;
import org.spin.tools.JAXBUtils;
import org.spin.tools.StringTools;
import org.spin.tools.config.ConfigException;
import org.spin.tools.config.ConfigTool;
import org.spin.tools.filter.FileFilterTool;
import org.spin.tools.filter.XMLFileFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShrimpETL {
    protected static Logger log = Logger.getLogger(ShrimpETL.class);
    protected static boolean DEBUG = log.isDebugEnabled();
    protected static boolean INFO = log.isInfoEnabled();
    private OntologyClient ontClient = null;
    private AdapterMappings adapterMappings = new AdapterMappings();
    private StringBuffer adapterErrors = new StringBuffer();

    public static void main(String[] args) {
        Command command = Command.help;
        if (args.length < 1) {
            ShrimpETL.showUsage();
        } else {
            try {
                command = Command.valueOf(args[0]);
            }
            catch (Exception e) {
                System.out.println("Invalid command " + args[0]);
            }
            switch (command) {
                case help: {
                    ShrimpETL.showUsage();
                    break;
                }
                case count: {
                    File inputFile = null;
                    StringBuffer output = new StringBuffer();
                    try {
                        inputFile = new File(args[1]);
                        AdapterMappings input = (AdapterMappings)JAXBUtils.unmarshal((File)inputFile, AdapterMappings.class);
                        for (String core_key : input.getMappings().keySet()) {
                            output.append(input.getMappings().get(core_key).getLocals().size());
                            output.append(",");
                            output.append(core_key);
                            output.append(StringTools.CRLF());
                        }
                    }
                    catch (FileNotFoundException e) {
                        System.out.println("File not found" + inputFile.getAbsolutePath());
                    }
                    catch (JAXBException e) {
                        System.out.println("Failed to read AdapterMappings file");
                    }
                    try {
                        FileUtils.write((File)new File("AdapterMappingSummary.txt"), (String)output.toString());
                    }
                    catch (IOException e) {
                        System.out.println("Could not output counts " + e.getMessage());
                    }
                    break;
                }
                case map: {
                    ShrimpETLConfig config = null;
                    try {
                        config = (ShrimpETLConfig)JAXBUtils.unmarshal((File)new File(args[1]), ShrimpETLConfig.class);
                    }
                    catch (Exception e) {
                        System.out.println("Invalid config file :" + args[1]);
                        ShrimpETL.showUsage();
                    }
                    try {
                        ShrimpETL etl = new ShrimpETL(config);
                        etl.doMapping(config.getFragments());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        System.out.println("Unchecked exception");
                        ShrimpETL.showUsage();
                    }
                    break;
                }
                case merge: {
                    try {
                        ShrimpETL pipeline = new ShrimpETL();
                        pipeline.doMerge(new File(args[1]));
                        break;
                    }
                    catch (Exception e) {
                        ShrimpETL.showUsage();
                    }
                }
            }
        }
    }

    public ShrimpETL() {
    }

    public ShrimpETL(ShrimpETLConfig config) {
        this.ontClient = new OntologyClient(config.getDomain(), config.getUsername(), config.getPassword(), config.getProject(), config.getBaseURL());
    }

    public static void showUsage() {
        System.out.println("map ShrimpETLConfig.xml");
        System.out.println("count AdapterMappings.xml");
        System.out.println("merge /my/xml/files/");
        System.out.println("merge /my/xml/files/ output.xml");
    }

    public void doMapping(List<FragmentMapping> mappings) {
        for (FragmentMapping fm : mappings) {
            try {
                this.doMapping(fm);
            }
            catch (ConfigException e) {
                System.out.println("Error loading resource for fragment " + fm.fragment);
            }
            catch (JDOMException e) {
                System.out.println("Error reading SHRIMP input file " + fm.filename);
            }
            catch (Exception e) {
                System.out.println("General exception during mapping of " + fm.fragment);
                e.printStackTrace();
            }
        }
        try {
            FileUtils.write((File)new File("AdapterMappings.xml"), (String)JAXBUtils.marshalToString((Object)this.adapterMappings));
            if (this.adapterErrors.length() > 1) {
                FileUtils.write((File)new File("AdapterMappings.err"), (String)this.adapterErrors.toString());
            }
        }
        catch (Exception e) {
            System.out.println("Could not save AdapterMappings.xml or AdapterMappings.err , reason: " + e.getMessage());
            e.printStackTrace();
        }
    }

    public void doMapping(FragmentMapping mapping) throws ConfigException, JDOMException, JaxenException, IOException, OntologyException {
        File chbMeds = ConfigTool.getConfigFileWithFailover((String)mapping.filename);
        Guard.notNull((Object)chbMeds);
        JDOMTool jdom = new JDOMTool(chbMeds);
        Element root = jdom.getRootElement();
        Guard.notNull((Object)root);
        List concepts = root.getChild("concepts").getChildren("concept");
        for (Element concept : concepts) {
            String local_key = concept.getChildText("local_key");
            List mappings = concept.getChild("mappings").getChildren("concept");
            for (Element core2local : mappings) {
                String core_key = core2local.getChildText("local_key");
                List<String> multipleMappings = this.ontClient.getKeyByCode(mapping.prefix + core_key);
                if (multipleMappings == null) {
                    this.adapterErrors.append(mapping.fragment + "---> " + core_key + " , ");
                    continue;
                }
                for (String fullyQualifiedCoreConcept : multipleMappings) {
                    this.adapterMappings.addMapping(fullyQualifiedCoreConcept, local_key);
                    for (String coreParentFolder : this.ontClient.getParentFoldersPathsInKey(fullyQualifiedCoreConcept)) {
                        if (INFO) {
                            log.info((Object)("coreParentFolder " + coreParentFolder));
                        }
                        this.adapterMappings.addMapping(coreParentFolder, local_key);
                    }
                }
            }
        }
    }

    public void doMerge(File path) throws JAXBException, IOException, OntologyException {
        FileFilterTool filter = new FileFilterTool();
        AdapterMappings completeMap = new AdapterMappings();
        for (File xmlFile : filter.recursiveFilter(path, (FileFilter)new XMLFileFilter())) {
            System.out.println("Combining " + xmlFile.getAbsolutePath());
            AdapterMappings singleMap = (AdapterMappings)JAXBUtils.unmarshal((File)xmlFile, AdapterMappings.class);
            completeMap.combine(singleMap);
        }
        JAXBUtils.marshalToFile((Object)completeMap, (File)new File("AdapterMappings.xml"));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Command {
        merge,
        map,
        count,
        help;

    }
}

