/*
 * Decompiled with CFR 0.152.
 */
package org.spin.query.message.cache;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlType;
import org.spin.query.message.cache.Count;
import org.spin.tools.Util;
import org.spin.tools.crypto.signature.CertID;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="CacheEntry")
@XmlRootElement
public final class CacheEntry {
    public static final int MinLevel = 1;
    protected final Map<Integer, ResponsesByCertID> responsesBylevel = Collections.synchronizedMap(Util.makeHashMap());
    @XmlElement(required=true)
    @XmlSchemaType(name="dateTime")
    protected volatile Calendar timestamp;
    protected transient Object lock = new Object();

    public CacheEntry() {
        this((Map<Integer, ResponsesByCertID>)null);
    }

    protected CacheEntry(Map<Integer, ResponsesByCertID> responsesByLevel) {
        if (responsesByLevel != null) {
            this.responsesBylevel.putAll(responsesByLevel);
        }
        this.updateTimestamp();
    }

    private CacheEntry(CacheEntry other) {
        Util.guardNotNull((Object)other);
        for (Integer level : other.getResponsesByLevel().keySet()) {
            this.responsesBylevel.put(level, new ResponsesByCertID(other.getResponsesByLevel().get(level)));
        }
    }

    public static final CacheEntry copyOf(CacheEntry other) {
        return new CacheEntry(other);
    }

    protected Map<Integer, ResponsesByCertID> getResponsesByLevel() {
        return this.responsesBylevel;
    }

    protected Set<Integer> getKnownLevels() {
        return Util.asSet(this.responsesBylevel.keySet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ResponsesByCertID getResponsesAtLevel(Integer level) {
        ResponsesByCertID responsesForLevel;
        Util.require((level >= 1 ? 1 : 0) != 0);
        Object object = this.lock;
        synchronized (object) {
            if (this.responsesBylevel.containsKey(level)) {
                responsesForLevel = this.responsesBylevel.get(level);
            } else {
                responsesForLevel = new ResponsesByCertID();
                this.responsesBylevel.put(level, responsesForLevel);
            }
        }
        return responsesForLevel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final Count getExpectedCountForLevel(int level) {
        Util.require((level >= 1 ? 1 : 0) != 0);
        Object object = this.lock;
        synchronized (object) {
            if (this.hasAnyInfoAboutLevel(level)) {
                return this.responsesBylevel.get(level).getExpectedCount();
            }
        }
        return null;
    }

    protected final boolean hasAnyInfoAboutLevel(int level) {
        Util.require((level >= 1 ? 1 : 0) != 0);
        ResponsesByCertID forLevel = this.responsesBylevel.get(level);
        return forLevel != null && forLevel.getExpectedCount() != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final boolean levelIsUnknown(int level) {
        Util.require((level >= 1 ? 1 : 0) != 0);
        Object object = this.lock;
        synchronized (object) {
            return !this.hasAnyInfoAboutLevel(level) || this.responsesBylevel.get(level).getExpectedCount().isUnknown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<String> getResponses() {
        ArrayList results = Util.makeArrayList();
        Object object = this.lock;
        synchronized (object) {
            for (int level : this.responsesBylevel.keySet()) {
                if (!this.hasAnyInfoAboutLevel(level)) continue;
                results.addAll(this.responsesBylevel.get(level).values());
            }
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getNumResponsesAtLevel(int level) {
        Util.require((level >= 1 ? 1 : 0) != 0);
        Object object = this.lock;
        synchronized (object) {
            if (this.responsesBylevel.containsKey(level)) {
                return this.responsesBylevel.get(level).size();
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addResponse(int level, CertID nodeID, String response) {
        ResponsesByCertID responsesForLevel;
        Util.require((level >= 1 ? 1 : 0) != 0);
        Util.guardNotNull((Object)nodeID);
        ResponsesByCertID responsesByCertID = responsesForLevel = this.getResponsesAtLevel(level);
        synchronized (responsesByCertID) {
            responsesForLevel.put(nodeID, response);
        }
        this.updateTimestamp();
    }

    private void updateTimestamp() {
        this.timestamp = new GregorianCalendar();
    }

    public Calendar getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(Calendar timestamp) {
        this.timestamp = timestamp;
    }

    public boolean isExpired(long maxAgeInMillis) {
        Util.require((maxAgeInMillis > 0L ? 1 : 0) != 0);
        long now = new GregorianCalendar().getTimeInMillis();
        long delta = 1000L;
        return this.timestamp.getTimeInMillis() + maxAgeInMillis < now - 1000L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumExpectedResponses() {
        int total = 0;
        Object object = this.lock;
        synchronized (object) {
            for (Integer level : this.responsesBylevel.keySet()) {
                Count expectedForLevel = this.responsesBylevel.get(level).getExpectedCount();
                if (expectedForLevel == Count.Unknown) continue;
                total += expectedForLevel.getValue();
            }
        }
        return total;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumResponses() {
        int total = 0;
        Object object = this.lock;
        synchronized (object) {
            for (Integer level : this.responsesBylevel.keySet()) {
                total += this.responsesBylevel.get(level).size();
            }
        }
        return total;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.responsesBylevel == null ? 0 : ((Object)this.responsesBylevel).hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CacheEntry other = (CacheEntry)obj;
        return !(this.responsesBylevel == null ? other.responsesBylevel != null : !((Object)this.responsesBylevel).equals(other.responsesBylevel));
    }

    public String toString() {
        return Util.concat((Object[])new Object[]{"timestamp: ", this.getTimestamp(), " num responses: ", this.getNumResponses(), " responses: ", this.responsesBylevel});
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @XmlAccessorType(value=XmlAccessType.FIELD)
    @XmlType(name="ResponsesByCertID")
    @XmlRootElement
    protected static class ResponsesByCertID
    implements Map<CertID, String> {
        private volatile Count expected = Count.Unknown;
        private final Map<CertID, String> responses = Collections.synchronizedMap(Util.makeHashMap());
        private final transient Object lock = new Object();

        ResponsesByCertID(ResponsesByCertID other) {
            Util.guardNotNull((Object)other);
            this.expected = other.expected == null ? Count.Unknown : other.expected;
            this.responses.putAll(other.responses);
        }

        public ResponsesByCertID() {
        }

        public Count getExpectedCount() {
            return this.expected;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setExpectedCount(Count expected) {
            Object object = this.lock;
            synchronized (object) {
                this.expected = expected == null ? Count.Unknown : expected;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setExpectedCount(int expected) {
            Object object = this.lock;
            synchronized (object) {
                this.expected = Count.valueOf(expected);
            }
        }

        @Override
        public void clear() {
            this.responses.clear();
        }

        @Override
        public boolean containsKey(Object key) {
            return this.responses.containsKey(key);
        }

        @Override
        public boolean containsValue(Object value) {
            return this.responses.containsValue(value);
        }

        @Override
        public Set<Map.Entry<CertID, String>> entrySet() {
            return this.responses.entrySet();
        }

        @Override
        public boolean equals(Object o) {
            return ((Object)this.responses).equals(o);
        }

        @Override
        public String get(Object key) {
            return this.responses.get(key);
        }

        @Override
        public int hashCode() {
            return ((Object)this.responses).hashCode();
        }

        @Override
        public boolean isEmpty() {
            return this.responses.isEmpty();
        }

        @Override
        public Set<CertID> keySet() {
            return this.responses.keySet();
        }

        @Override
        public String put(CertID key, String value) {
            return this.responses.put(key, value);
        }

        @Override
        public void putAll(Map<? extends CertID, ? extends String> m) {
            this.responses.putAll(m);
        }

        @Override
        public String remove(Object key) {
            return this.responses.remove(key);
        }

        @Override
        public int size() {
            return this.responses.size();
        }

        public String toString() {
            return this.responses.toString();
        }

        @Override
        public Collection<String> values() {
            return this.responses.values();
        }
    }
}

