/*
 * Decompiled with CFR 0.152.
 */
package org.spin.query.message.cache;

import java.util.Iterator;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.log4j.Logger;
import org.spin.tools.Util;

@XmlRootElement
@XmlType(name="Count")
@XmlAccessorType(value=XmlAccessType.FIELD)
public final class Count {
    private static final Logger log = Logger.getLogger(Count.class);
    private static final boolean INFO = log.isInfoEnabled();
    private static final boolean DEBUG = log.isDebugEnabled();
    public static final Count Unknown = new Count(-1);
    private static final Count[] flyweightCache = Count.makeCountArray(25);
    private final int value;

    private Count() {
        this(0);
    }

    private Count(int value) {
        this.value = value;
    }

    public static final Count valueOf(int count) {
        if (count < 0) {
            if (DEBUG) {
                log.debug((Object)Util.concat((Object[])new Object[]{"Negative count received: ", count, ", returning Unknown."}));
            }
            return Unknown;
        }
        if (count < flyweightCache.length) {
            return flyweightCache[count];
        }
        return new Count(count);
    }

    private static final Count[] makeCountArray(int size) {
        Util.require((size > 0 ? 1 : 0) != 0);
        Count[] result = new Count[size];
        Iterator i$ = Util.range((int)size).iterator();
        while (i$.hasNext()) {
            int i = (Integer)i$.next();
            result[i] = new Count(i);
        }
        return result;
    }

    public boolean isUnknown() {
        return this.equals(Unknown);
    }

    public int getValue() {
        return this.value;
    }

    public Count plus(Count count) {
        Util.guardNotNull((Object)count);
        if (count.isUnknown() && this.isUnknown()) {
            return Unknown;
        }
        if (!count.isUnknown() && !this.isUnknown()) {
            return Count.valueOf(this.value + count.value);
        }
        if (this.isUnknown()) {
            return count;
        }
        return this;
    }

    public Count plus(int increment) {
        if (this.isUnknown()) {
            return Count.valueOf(increment);
        }
        return Count.valueOf(this.value + increment);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.value;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Count other = (Count)obj;
        return this.value == other.value;
    }

    public String toString() {
        if (this.isUnknown()) {
            return "Unknown";
        }
        return Util.concat((Object[])new Object[]{"Count(", this.value, ")"});
    }
}

