/*
 * Decompiled with CFR 0.152.
 */
package org.spin.query.message.cache;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.xml.crypto.dsig.XMLSignatureException;
import org.apache.log4j.Logger;
import org.spin.query.message.cache.Cache;
import org.spin.query.message.cache.CacheEntry;
import org.spin.query.message.cache.CacheException;
import org.spin.query.message.cache.QueryNotFoundException;
import org.spin.query.message.cache.ResponseNode;
import org.spin.query.message.cache.RootResponseNode;
import org.spin.query.message.cache.StatusCode;
import org.spin.query.message.headers.QueryInfo;
import org.spin.tools.PKITool;
import org.spin.tools.Util;
import org.spin.tools.config.ConfigException;
import org.spin.tools.config.ConfigTool;
import org.spin.tools.config.NodeConfig;
import org.spin.tools.crypto.signature.CertID;
import org.spin.tools.crypto.signature.Identity;
import org.spin.tools.crypto.signature.XMLSignatureUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MemoryResidentCache
implements Cache {
    private static final Logger log = Logger.getLogger(MemoryResidentCache.class);
    private static final boolean INFO = log.isInfoEnabled();
    private static final boolean DEBUG = log.isDebugEnabled();
    private final long maxAgeBeforeExpiration;
    private CertID nodeID;
    private final Map<String, RootResponseNode> responseNodes = Collections.synchronizedMap(new HashMap());

    public MemoryResidentCache() throws ConfigException {
        this(MemoryResidentCache.getMyCertID());
    }

    public MemoryResidentCache(CertID nodeID) throws ConfigException {
        this(MemoryResidentCache.getNodeConfig().getCacheTTL(), nodeID);
    }

    public MemoryResidentCache(long maxAgeBeforeExpiration) throws ConfigException {
        this(maxAgeBeforeExpiration, MemoryResidentCache.getMyCertID());
    }

    public MemoryResidentCache(long maxAgeBeforeExpiration, CertID nodeID) {
        Util.require((maxAgeBeforeExpiration > 0L ? 1 : 0) != 0);
        Util.guardNotNull((Object)nodeID);
        this.maxAgeBeforeExpiration = maxAgeBeforeExpiration;
        this.nodeID = nodeID;
    }

    protected static final NodeConfig getNodeConfig() {
        try {
            return ConfigTool.loadNodeConfig();
        }
        catch (ConfigException e) {
            log.warn((Object)"Error loading Node config; using defaults");
            return new NodeConfig();
        }
    }

    private static final CertID getMyCertID() throws ConfigException {
        return PKITool.getInstance().getMyCertID();
    }

    public CertID getNodeID() {
        return this.nodeID;
    }

    public void setNodeID(CertID nodeID) {
        Util.guardNotNull((Object)nodeID);
        this.nodeID = nodeID;
    }

    @Override
    public void initQuery(QueryInfo queryInfo) {
        try {
            this.ensureRootResponseNode(queryInfo);
        }
        catch (CacheException e) {
            log.warn((Object)"Failed to initialize the query!", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkCacheExpiry() {
        ArrayList queriesToRemove = Util.makeArrayList();
        Map<String, RootResponseNode> map = this.responseNodes;
        synchronized (map) {
            for (String queryID : this.responseNodes.keySet()) {
                try {
                    ResponseNode entry = this.getRootResponseNode(queryID);
                    if (!entry.isExpired(this.maxAgeBeforeExpiration)) continue;
                    if (INFO) {
                        log.info((Object)Util.concat((Object[])new Object[]{"Removing expired query: ", queryID, ", created on: ", entry.getTimestamp(), ", current time: ", Calendar.getInstance()}));
                    }
                    queriesToRemove.add(queryID);
                }
                catch (QueryNotFoundException e) {
                    log.error((Object)Util.concat((Object[])new Object[]{"Error deleting expired query: ", queryID}), (Throwable)e);
                }
            }
            for (String queryID : queriesToRemove) {
                this.responseNodes.remove(queryID);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void aggregate(CertID nodeID, QueryInfo queryInfo, String resultData) throws CacheException {
        try {
            if (DEBUG) {
                log.debug((Object)("Setting reply for query: " + queryInfo.getQueryID()));
                log.debug((Object)("Query results: " + resultData));
            }
            ResponseNode rootNode = this.ensureRootResponseNode(queryInfo);
            try {
                ResponseNode leafnode = rootNode.updateTree(queryInfo);
                leafnode.setPayload(resultData);
            }
            catch (QueryNotFoundException e) {
                throw new CacheException(Util.concat((Object[])new Object[]{"Unknown query: ", queryInfo.getQueryID(), "(This should NEVER happen !!!!)"}), e);
            }
        }
        finally {
            this.checkCacheExpiry();
        }
    }

    private ResponseNode ensureRootResponseNode(QueryInfo queryInfo) throws CacheException {
        Map<String, RootResponseNode> map = this.responseNodes;
        synchronized (map) {
            if (!this.responseNodes.containsKey(queryInfo.getQueryID())) {
                RootResponseNode rootNode = new RootResponseNode(this.nodeID, queryInfo);
                this.responseNodes.put(queryInfo.getQueryID(), rootNode);
                return rootNode;
            }
            try {
                return this.getRootResponseNode(queryInfo.getQueryID());
            }
            catch (QueryNotFoundException qnfe) {
                throw new CacheException(qnfe);
            }
        }
    }

    private ResponseNode getRootResponseNode(String queryID) throws QueryNotFoundException {
        ResponseNode r = this.responseNodes.get(queryID);
        if (r == null) {
            throw new QueryNotFoundException(Util.concat((Object[])new Object[]{"Cannot find query: ", queryID}));
        }
        return r;
    }

    @Override
    public CacheEntry getResult(String queryID, Identity requestorID) throws CacheException, QueryNotFoundException {
        return this.getResult(queryID, requestorID, true);
    }

    @Override
    public CacheEntry getResultNoDelete(String queryID, Identity requestorID) throws CacheException, QueryNotFoundException {
        return this.getResult(queryID, requestorID, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CacheEntry getResult(String queryID, Identity requestorID, boolean deleteFromCache) throws CacheException, QueryNotFoundException {
        this.guardQueryIDIsPresent(queryID);
        this.guardQueryIDBelongsToRequestor(queryID, requestorID);
        this.guardIsAuthorizedRequestor(queryID, requestorID);
        try {
            Object object;
            if (INFO) {
                log.info((Object)Util.concat((Object[])new Object[]{"Getting result for queryID: ", queryID}));
            }
            ResponseNode resultRoot = this.getRootResponseNode(queryID);
            Util.guardNotNull((Object)resultRoot);
            boolean complete = resultRoot.isComplete();
            if (complete && deleteFromCache) {
                object = this.responseNodes;
                synchronized (object) {
                    this.responseNodes.remove(queryID);
                }
            }
            object = resultRoot.toCacheEntry();
            return object;
        }
        finally {
            this.checkCacheExpiry();
        }
    }

    @Override
    public final boolean isComplete(String queryID) throws CacheException, QueryNotFoundException {
        this.guardQueryIDIsPresent(queryID);
        ResponseNode root = this.getRootResponseNode(queryID);
        return root.isComplete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int countResponses(String queryID) throws QueryNotFoundException {
        this.guardQueryIDIsPresent(queryID);
        try {
            int numResponders;
            Map<String, RootResponseNode> map = this.responseNodes;
            synchronized (map) {
                numResponders = this.getRootResponseNode(queryID).getNumResponses();
            }
            if (INFO) {
                log.info((Object)Util.concat((Object[])new Object[]{"countResponses: Found ", numResponders, " responders for query ", queryID}));
            }
            int n = numResponders;
            return n;
        }
        finally {
            this.checkCacheExpiry();
        }
    }

    @Override
    public boolean hasUpdate(String queryID, int numResponders) throws CacheException, QueryNotFoundException {
        this.guardQueryIDIsPresent(queryID);
        return this.countResponses(queryID) > numResponders;
    }

    @Override
    public void expectResponse(QueryInfo queryInfo, Collection<StatusCode> statuses, int numChildren) throws CacheException {
        Util.guardNotNull((Object)queryInfo);
        String queryID = queryInfo.getQueryID();
        Util.guardNotNull((Object)queryID);
        ResponseNode rootNode = this.ensureRootResponseNode(queryInfo);
        try {
            ResponseNode leafNode = rootNode.updateTree(queryInfo);
            leafNode.expectResponse(queryInfo, statuses, numChildren);
        }
        catch (QueryNotFoundException e) {
            throw new CacheException(Util.concat((Object[])new Object[]{"Couldn't find query ", queryID, " (This should NEVER happen !!!!)"}), e);
        }
    }

    private void guardQueryIDIsPresent(String queryID) throws QueryNotFoundException {
        boolean queryPresent = this.responseNodes.containsKey(queryID);
        if (!queryPresent) {
            throw new QueryNotFoundException(Util.concat((Object[])new Object[]{"Unknown Query: ", queryID}));
        }
    }

    private void guardQueryIDBelongsToRequestor(String queryID, Identity requestorID) throws CacheException {
        String requestor;
        RootResponseNode root = this.responseNodes.get(queryID);
        String owner = root.getIdentity().getUsername();
        if (owner.equalsIgnoreCase(requestor = requestorID.getUsername())) {
            if (DEBUG) {
                log.debug((Object)Util.concat((Object[])new Object[]{"queryID ", queryID, " indeed belongs to ", requestor}));
            }
        } else {
            throw new CacheException(Util.concat((Object[])new Object[]{"queryID ", queryID, " was issued by a different user, expected: ", owner}));
        }
    }

    private void guardIsAuthorizedRequestor(String queryID, Identity requestorID) throws CacheException {
        boolean valid;
        Util.guardNotNull((Object)requestorID);
        try {
            valid = XMLSignatureUtil.verifySignature((Identity)requestorID);
        }
        catch (XMLSignatureException e) {
            throw new CacheException(Util.concat((Object[])new Object[]{"Error validating signature for user '", requestorID.getUsername(), "'; requested query ", queryID}), e);
        }
        if (valid) {
            if (DEBUG) {
                log.debug((Object)Util.concat((Object[])new Object[]{"Signature was valid for queryId ", queryID}));
            }
        } else {
            throw new CacheException(Util.concat((Object[])new Object[]{"Signature was invalid for queryId ", queryID}));
        }
    }
}

