/*
 * Decompiled with CFR 0.152.
 */
package org.spin.query.message.cache;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.spin.query.message.cache.CacheEntry;
import org.spin.query.message.cache.CacheException;
import org.spin.query.message.cache.QueryNotFoundException;
import org.spin.query.message.cache.StatusCode;
import org.spin.query.message.headers.QueryInfo;
import org.spin.tools.Util;
import org.spin.tools.crypto.signature.CertID;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ResponseNode {
    private static final Logger log = Logger.getLogger(ResponseNode.class);
    private static final boolean DEBUG = log.isDebugEnabled();
    private static final boolean INFO = log.isInfoEnabled();
    protected static final CertID Anonymous = new CertID();
    private boolean waitingForExpectResponse = true;
    private boolean waitingForAggregate = true;
    private final CertID id;
    private Calendar timestamp;
    private NodePayload payload = NodePayload.EmptyPayload;
    protected final List<ResponseNode> children = Collections.synchronizedList(new ArrayList());

    public Calendar getTimestamp() {
        return this.timestamp;
    }

    private void updateTimestamp() {
        this.timestamp = new GregorianCalendar();
    }

    public ResponseNode(CertID id) {
        this.id = id;
        this.updateTimestamp();
    }

    public static final ResponseNode anonymous() {
        return new ResponseNode(Anonymous);
    }

    public boolean isAnonymous() {
        return Anonymous.equals((Object)this.id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResponseNode getChild(CertID childID) {
        List<ResponseNode> list = this.children;
        synchronized (list) {
            for (ResponseNode child : this.children) {
                if (!child.id.equals((Object)childID)) continue;
                return child;
            }
        }
        return null;
    }

    public ResponseNode updateTree(QueryInfo queryInfo) throws CacheException, QueryNotFoundException {
        ResponseNode rootResponseNode;
        ArrayList path = new ArrayList(queryInfo.getRoutedByNodes());
        List trimmed = null;
        for (int i = 0; i < path.size(); ++i) {
            CertID test = (CertID)path.get(i);
            if (!test.equals((Object)this.id)) continue;
            trimmed = path.subList(i, path.size());
            break;
        }
        if (trimmed == null || trimmed.isEmpty()) {
            trimmed = new ArrayList(path);
        } else {
            trimmed.remove(0);
        }
        ResponseNode parent = rootResponseNode = this;
        for (CertID childID : trimmed) {
            ResponseNode child = parent.getChild(childID);
            if (child == null) {
                child = new ResponseNode(childID);
                parent.addChild(child);
            }
            parent = child;
        }
        return parent;
    }

    public void ensurePlaceholderChildren(int desiredTotalNumberOfChildren) {
        Util.require((desiredTotalNumberOfChildren >= 0 ? 1 : 0) != 0);
        int currentNumChildren = this.children.size();
        if (currentNumChildren == desiredTotalNumberOfChildren) {
            if (DEBUG) {
                log.debug((Object)("Num Children same as desired: " + currentNumChildren + " / " + desiredTotalNumberOfChildren));
            }
            return;
        }
        if (desiredTotalNumberOfChildren < currentNumChildren) {
            if (DEBUG) {
                log.debug((Object)("Num Children > desired: " + currentNumChildren + " / " + desiredTotalNumberOfChildren));
            }
            int howManyToRemove = Math.max(0, currentNumChildren - desiredTotalNumberOfChildren);
            for (Integer i : Util.range((int)howManyToRemove)) {
                this.children.remove(this.getChild(Anonymous));
            }
        } else {
            if (DEBUG) {
                log.debug((Object)("Num Children < desired: " + currentNumChildren + " / " + desiredTotalNumberOfChildren));
            }
            int howManyToAdd = Math.max(0, desiredTotalNumberOfChildren - currentNumChildren);
            for (Integer i : Util.range((int)howManyToAdd)) {
                try {
                    this.addChild();
                }
                catch (CacheException ce) {
                    log.error((Object)"This should NEVER happen - error ensuring sufficient children", (Throwable)ce);
                }
            }
        }
    }

    private void addChild() throws CacheException {
        this.addChild(new ResponseNode(Anonymous));
    }

    public void addChild(ResponseNode child) throws CacheException {
        Util.guardNotNull((Object)child);
        if (child.isAnonymous()) {
            this.children.add(child);
        } else if (!this.children.contains(child)) {
            ResponseNode toReUse = this.findFirstPlaceholderChild();
            if (toReUse != null) {
                this.children.remove(toReUse);
            }
            this.children.add(child);
        } else {
            throw new CacheException("Duplicate Child!");
        }
    }

    protected ResponseNode findFirstPlaceholderChild() {
        return this.getChild(Anonymous);
    }

    public CertID getId() {
        return this.id;
    }

    public NodePayload getPayload() {
        return this.payload;
    }

    public void setPayload(String payload) {
        this.setPayload(new NodePayload(payload));
    }

    public void setPayload(NodePayload payload) {
        Util.guardNotNull((Object)payload);
        if (DEBUG) {
            log.debug((Object)("SetPayload for NODE: " + this.id.toString() + " = " + payload.value));
        }
        this.waitingForAggregate = false;
        this.payload = payload;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ResponseNode other = (ResponseNode)obj;
        return !(this.id == null ? other.id != null : !this.id.equals((Object)other.id));
    }

    public boolean isExpired(long maxAgeInMillis) {
        Util.require((maxAgeInMillis > 0L ? 1 : 0) != 0);
        long now = new GregorianCalendar().getTimeInMillis();
        long delta = 1000L;
        return this.getTimestamp().getTimeInMillis() + maxAgeInMillis < now - 1000L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isComplete() {
        if (this.waitingForExpectResponse || this.waitingForAggregate) {
            return false;
        }
        List<ResponseNode> list = this.children;
        synchronized (list) {
            for (ResponseNode child : this.children) {
                if (child.isComplete()) continue;
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumResponses() {
        int count = 0;
        if (this.payload != NodePayload.EmptyPayload) {
            count = 1;
        }
        List<ResponseNode> list = this.children;
        synchronized (list) {
            for (ResponseNode child : this.children) {
                count += child.getNumResponses();
            }
        }
        return count;
    }

    public void expectResponse(QueryInfo queryInfo, Collection<StatusCode> statuses, int numChildren) {
        if (DEBUG) {
            log.debug((Object)("ExpectResponse for NODE: " + this.id.toString()));
        }
        this.waitingForExpectResponse = false;
        if (!statuses.contains((Object)StatusCode.QueryStarted)) {
            this.waitingForAggregate = false;
        }
        if (statuses.contains((Object)StatusCode.BroadcastStarted) || numChildren != this.children.size()) {
            this.ensurePlaceholderChildren(numChildren);
        }
    }

    public CacheEntry toCacheEntry() {
        CacheEntry c = new CacheEntry();
        this.cacheEntryAddDataRecurse(c, 1);
        return c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cacheEntryAddDataRecurse(CacheEntry c, int level) {
        Util.guardNotNull((Object)c);
        Util.require((level > 0 ? 1 : 0) != 0);
        if (!this.payload.equals(NodePayload.EmptyPayload)) {
            Map<Integer, CacheEntry.ResponsesByCertID> map = c.getResponsesByLevel();
            c.addResponse(level, this.id, this.payload.getValue());
            CacheEntry.ResponsesByCertID response = map.get(level);
            int expectedCount = 0;
            if (response.getExpectedCount().isUnknown()) {
                expectedCount = 1;
            } else {
                int previousExpectedVal = response.getExpectedCount().getValue();
                expectedCount = previousExpectedVal + 1;
            }
            response.setExpectedCount(expectedCount);
        }
        List<ResponseNode> list = this.children;
        synchronized (list) {
            for (ResponseNode child : this.children) {
                child.cacheEntryAddDataRecurse(c, level + 1);
            }
        }
    }

    public static class NodePayload {
        public static final String EMPTY_PAYLOAD_FLAG_VALUE = "SPECIAL_EMPTY_PAYLOAD_FLAG_VALUE_WHICH_IS_UNLIKELY_TO_COLLIDE_WITH_ACTUAL_DATA";
        public static final NodePayload EmptyPayload = new NodePayload();
        private final String value;

        private NodePayload() {
            this.value = EMPTY_PAYLOAD_FLAG_VALUE;
        }

        public NodePayload(String value) {
            Util.require((!EMPTY_PAYLOAD_FLAG_VALUE.equals(value) ? 1 : 0) != 0);
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            NodePayload other = (NodePayload)obj;
            return !(this.value == null ? other.value != null : !this.value.equals(other.value));
        }
    }
}

