/**
 * @projectDescription	View controller for the history viewport. (CRC's "previous queries" window)
 * @inherits 	i2b2.CRC.view
 * @namespace	i2b2.CRC.view.history
 * @author		Nick Benik, Griffin Weber MD PhD
 * @version 	1.3
 * ----------------------------------------------------------------------------------------
 * updated 9-15-08: RC4 launch [Nick Benik]
 */
console.group('Load & Execute component file: CRC > view > History');
console.time('execute time');

// create and save the screen objects
i2b2.CRC.view.history = new i2b2Base_cellViewController(i2b2.CRC, 'history');
i2b2.CRC.view.history.visible = false;
// define the option functions
// ================================================================================================== //
i2b2.CRC.view.history.showOptions = function (subScreen) {
  if (!this.modalOptions) {
    const handleSubmit = function () {
      // submit value(s)
      if (this.submit()) {
        if ($('HISTsortOrderASC').checked) {
          tmpValue = 'ASC';
        } else {
          tmpValue = 'DESC';
        }
        i2b2.CRC.view.history.params.sortOrder = tmpValue;
        if ($('HISTsortByNAME').checked) {
          tmpValue = 'NAME';
        } else {
          tmpValue = 'DATE';
        }
        i2b2.CRC.view.history.params.sortBy = tmpValue;
        tmpValue = parseInt($('HISTMaxQryDisp').value, 10);
        i2b2.CRC.view.history.params.maxQueriesDisp = tmpValue;
        // requery the history list
        i2b2.CRC.ctrlr.history.Refresh();
      }
    };
    const handleCancel = function () {
      this.cancel();
    };
    this.modalOptions = new YAHOO.widget.SimpleDialog('optionsHistory', {
      width: '400px',
      fixedcenter: true,
      constraintoviewport: true,
      modal: true,
      zindex: 700,
      buttons: [
        {
          text: 'OK',
          handler: handleSubmit,
          isDefault: true,
        },
        {
          text: 'Cancel',
          handler: handleCancel,
        },
      ],
    });
    $('optionsHistory').show();
    this.modalOptions.validate = function () {
      // now process the form data
      const tmpValue = parseInt($('HISTMaxQryDisp').value, 10);
      if (!isNaN(tmpValue) && tmpValue <= 0) {
        alert('The max number of Queries must be a whole number larger then zero.');
        return false;
      }
      return true;
    };
    this.modalOptions.render(document.body);
  }
  this.modalOptions.show();
  // load settings
  if (this.params.sortOrder == 'ASC') {
    $('HISTsortOrderASC').checked = true;
  } else {
    $('HISTsortOrderDESC').checked = true;
  }
  if (this.params.sortBy == 'NAME') {
    $('HISTsortByNAME').checked = true;
  } else {
    $('HISTsortByDATE').checked = true;
  }
  $('HISTMaxQryDisp').value = this.params.maxQueriesDisp;
};

// ================================================================================================== //
i2b2.CRC.view.history.ToggleNode = function (divTarg, divTreeID) {
  // get the i2b2 data from the yuiTree node
  const tvTree = YAHOO.widget.TreeView.getTree(divTreeID);
  const tvNode = tvTree.getNodeByProperty('nodeid', divTarg.id);
  tvNode.toggle();
};

// ================================================================================================== //
i2b2.CRC.view.history.Resize = function (e) {
  // this function provides the resize functionality needed for this screen
  const viewObj = i2b2.CRC.view.history;
  let ve = $('crcHistoryBox');
  if (viewObj.visible) {
    ve.show();
    // var ds = document.viewport.getDimensions();
    let w = window.innerWidth || (window.document.documentElement.clientWidth || window.document.body.clientWidth);
    let h = window.innerHeight || (window.document.documentElement.clientHeight || window.document.body.clientHeight);
    if (w < 840) {
      w = 840;
    }
    if (h < 517) {
      h = 517;
    }
    ve = ve.style;
    // resize our visual components
    switch (i2b2.hive.MasterView.getViewMode()) {
      case 'Patients':
        if (i2b2.WORK && i2b2.WORK.isLoaded) {
          // make room for the workspace window
          ve.width = Math.max(initBrowserViewPortDim.width - rightSideWidth, 0);
          ve.top = h - 196 + 44;
          $('crcHistoryData').style.height = '100px';
        } else {
          ve.width = w - 578;
          ve.top = h - 196;
          $('crcHistoryData').style.height = '144px';
        }
        break;
      case 'Analysis':
        if (i2b2.WORK && i2b2.WORK.isLoaded) {
          // make room for the workspace window
          w = parseInt(w / 3) - 10;
          ve.width = w;
          ve.top = h - 196 + 44;
          $('crcHistoryData').style.height = '100px';
        } else {
          w = parseInt(w / 3) - 10;
          ve.width = w;
          ve.top = h - 196;
          $('crcHistoryData').style.height = '144px';
        }
        break;
    }
    if (viewObj.isZoomed) {
      ve.top = '';
      $('crcHistoryData').style.height = h - 97;
    }
    $$('DIV#crcHistoryBox DIV#crcHistoryData')[0].style.width = `100%`;

    this.splitterDragged();
    this.ResizeHeight();
  } else {
    ve.hide();
  }
};

// YAHOO.util.Event.addListener(window, "resize", i2b2.CRC.view.history.Resize, i2b2.CRC.view.history); // tdw9
i2b2.CRC.view.history.Resize();

//= ================================================================================================= //
i2b2.CRC.view.history.splitterDragged = function () {
  const splitter = $(i2b2.hive.mySplitter.name);
  const CRCHist = $('crcHistoryBox');
  CRCHist.style.width = `${Math.max(parseInt(splitter.style.left) - CRCHist.offsetLeft - 3, 0)}px`;
  $$('DIV#crcHistoryBox DIV#crcHistoryData')[0].style.width = `100%`;
};

//= ================================================================================================= //
i2b2.CRC.view.history.ResizeHeight = function () {
  // this function provides the resize functionality needed for this screen
  const viewObj = i2b2.CRC.view.history;
  let ve = $('crcHistoryBox');
  if (viewObj.visible) {
    ve.show();
    // var ds = document.viewport.getDimensions();
    let h = window.innerHeight || (window.document.documentElement.clientHeight || window.document.body.clientHeight);
    if (h < 517) {
      h = 517;
    }
    ve = ve.style;
    // resize our visual components
    switch (i2b2.hive.MasterView.getViewMode()) {
      case 'Patients':
        if (i2b2.WORK && i2b2.WORK.isLoaded) {
          // make room for the workspace window
          ve.top = h - 196 + 44;
          $('crcHistoryData').style.height = '100px';
        } else {
          ve.top = h - 196;
          $('crcHistoryData').style.height = '144px';
        }
        break;
      case 'Analysis':
        if (i2b2.WORK && i2b2.WORK.isLoaded) {
          // make room for the workspace window
          ve.top = h - 196 + 44;
          $('crcHistoryData').style.height = '100px';
        } else {
          ve.top = h - 196;
          $('crcHistoryData').style.height = '144px';
        }
        break;
    }
    if (viewObj.isZoomed) {
      ve.top = '';
      $('crcHistoryData').style.height = h - 97;
    }
  } else {
    ve.hide();
  }
};

// ================================================================================================== //
i2b2.CRC.view.history.PopulateQueryMasters = function (dm_ptr, dm_name, options) {
  const thisview = i2b2.CRC.view.history;
  // clear the data first
  const tvTree = i2b2.CRC.view.history.yuiTree;
  const tvRoot = tvTree.getRoot();
  tvTree.removeChildren(tvRoot);
  tvTree.locked = false;

  // sort by the options
  if (Object.isUndefined(options)) {
    var options = {};
  }
  if (!options.sortBy) {
    options.sortBy = 'DATE';
  }
  if (!options.sortOrder) {
    options.sortBy = 'DESC';
  }
  if (options.sortBy == 'NAME') {
    var compareAttrib = 'name';
  } else {
    var compareAttrib = 'created';
  }
  if (options.sortOrder == 'ASC') {
    var reverseSort = false;
  } else {
    var reverseSort = true;
  }

  // NEW SORT METHOD USING prototype Enumerators
  const QM_sortVal = function (rec) {
    const hash_key = rec[0];
    const sdxExtObj = rec[1];
    const cl_compareAttrib = compareAttrib; // <---- closure var
    let t = sdxExtObj.origData[cl_compareAttrib];
    if (cl_compareAttrib == 'created') {
      // proper date handling (w/improper handling for latest changes to output format)
      const sd = t.toUpperCase();
      if (sd.indexOf('Z') != -1 || sd.indexOf('T') != -1) {
        t = t.toLowerCase();
      } else {
        t = Date.parse(t);
      }
    } else {
      t = String(t.toLowerCase());
    }
    return t;
  };
  const sortFinal = i2b2.CRC.model.QueryMasters.sortBy(QM_sortVal);
  // reverse if needed
  if (reverseSort) {
    sortFinal.reverse(true);
  }

  // populate the Query Masters into the treeview
  for (let i = 0; i < sortFinal.length; i++) {
    // add categories to ONT navigate tree
    const sdxDataNode = sortFinal[i][1];

    if (sdxDataNode.origData.master_type_cd == 'TEMPORAL') {
      icon = 'sdx_CRC_QMT.gif';
      iconExp = 'sdx_CRC_QMT_exp.gif';
    } else {
      icon = 'sdx_CRC_QM.gif';
      iconExp = 'sdx_CRC_QM_exp.gif';
    }
    const renderOptions = {
      title: sdxDataNode.origData.name,
      dragdrop: 'i2b2.sdx.TypeControllers.QM.AttachDrag2Data',
      dblclick: `i2b2.CRC.view.history.ToggleNode(this,'${tvTree.id}')`,
      icon,
      iconExp,
    };
    const sdxRenderData = i2b2.sdx.Master.RenderHTML(tvTree.id, sdxDataNode, renderOptions);
    i2b2.sdx.Master.AppendTreeNode(tvTree, tvRoot, sdxRenderData);
  }
  tvTree.draw();
};

// ================================================================================================== //
// TODO: remove per SHRINE-2905
i2b2.CRC.view.history.ZoomView = function (elementId) {
  i2b2.hive.MasterView.toggleZoomWindow('HISTORY', elementId);
};

// =========== Context Menu Suff ===========
// ================================================================================================== //
// TODO: remove per SHRINE-2905
i2b2.CRC.view.history.doRename = function () {
  const op = i2b2.CRC.view.history.contextRecord; // object path
  i2b2.CRC.ctrlr.history.queryRename(op.sdxInfo.sdxKeyValue, false, op);
};

// ================================================================================================== //
// TODO: remove per SHRINE-2905
i2b2.CRC.view.history.doDelete = function () {
  i2b2.CRC.ctrlr.history.queryDelete(i2b2.CRC.view.history.contextRecord.sdxInfo.sdxKeyValue);
};

// ================================================================================================== //
// TODO: remove per SHRINE-2905
i2b2.CRC.view.history.doRefreshAll = function () {
  i2b2.CRC.ctrlr.history.Refresh();
};

// ================================================================================================== //
/**
 * Method for flagging a saved query.
 */
function openQueryFlagPrompt(networkId) {
  const dialogue = new YAHOO.widget.SimpleDialog('dialogQryFlag', {
    width: '400px',
    fixedcenter: true,
    constraintoviewport: true,
    modal: true,
    zindex: 700,
    buttons: [
      {
        text: 'OK',
        handler() {
          const message = document.getElementById('inputQueryFlagMessage').value;
          i2b2.CRC.ctrlr.history.Flag({ queryId: networkId, message });

          this.cancel();
          document.getElementById('inputQueryFlagMessage').value = '';
        },
        isDefault: true,
      },
      {
        text: 'Cancel',
        handler() {
          this.cancel();
          document.getElementById('inputQueryFlagMessage').value = '';
        },
      },
    ],
  });
  $('dialogQryFlag').show();
  $('dialogQryFlag').show();
  dialogue.render(document.body);
  dialogue.center();
  dialogue.show();
}

// ================================================================================================== //
i2b2.CRC.view.history.doQueryFlagPrompt = function (networkId) {
  openQueryFlagPrompt(networkId);
};

// ================================================================================================== //
/**
 * Method for unflagging a saved query.
 */
i2b2.CRC.view.history.doUnflag = function () {
  i2b2.CRC.ctrlr.history.Unflag({
    queryId: i2b2.CRC.view.history.contextRecord.sdxInfo.sdxKeyValue,
  });
};

// ================================================================================================== //
i2b2.CRC.view.history.ContextMenuValidate = function (p_oEvent) {
  let clickId = null;
  let currentNode = this.contextEventTarget;
  while (!currentNode.id) {
    if (currentNode.parentNode) {
      currentNode = currentNode.parentNode;
    } else {
      // we have recursed up the tree to the window/document DOM... it's a bad click
      this.cancel();
      return;
    }
  }
  clickId = currentNode.id;
  // see if the ID maps back to a treenode with SDX data
  const tvNode = i2b2.CRC.view.history.yuiTree.getNodeByProperty('nodeid', clickId);
  if (tvNode) {
    if (tvNode.data.i2b2_SDX) {
      if (tvNode.data.i2b2_SDX.sdxInfo.sdxType == 'QM') {
        i2b2.CRC.view.history.contextRecord = tvNode.data.i2b2_SDX;
      } else {
        this.cancel();
      }
    }
  }
};

//= ================================================================================================= //
i2b2.events.initView.subscribe(
  function (eventTypeName, newMode) {
    // -------------------------------------------------------
    this.visible = true;
    if (i2b2.WORK && i2b2.WORK.isLoaded) {
      $('crcHistoryData').style.height = '100px';
    } else {
      $('crcHistoryData').style.height = '144px';
    }
    $('crcHistoryBox').show();
    this.Resize();
    // -------------------------------------------------------
  },
  '',
  i2b2.CRC.view.history,
);

// ================================================================================================== //
i2b2.events.changedViewMode.subscribe(
  function (eventTypeName, newMode) {
    newMode = newMode[0];
    this.viewMode = newMode;
    switch (newMode) {
      case 'Patients':
      case 'Analysis':
        var wlst = i2b2.hive.MasterView.getZoomWindows();
        if (wlst.indexOf('ONT') != -1 || wlst.indexOf('WORK') != -1) {
          return;
        }
        this.visible = true;
        if (i2b2.WORK && i2b2.WORK.isLoaded) {
          $('crcHistoryData').style.height = '100px';
        } else {
          $('crcHistoryData').style.height = '144px';
        }
        $('crcHistoryBox').show();
        // this.Resize(); // tdw9
        this.splitterDragged();
        this.ResizeHeight();
        break;
      default:
        this.visible = false;
        $('crcHistoryBox').hide();
        break;
    }
  },
  '',
  i2b2.CRC.view.history,
);

// ================================================================================================== //
// TODO: remove per SHRINE-2905
i2b2.events.changedZoomWindows.subscribe(
  function (eventTypeName, zoomMsg) {
    newMode = zoomMsg[0];
    if (!newMode.action) {
      return;
    }
    if (newMode.action == 'ADD') {
      switch (newMode.window) {
        case 'HISTORY':
          this.isZoomed = true;
          this.visible = true;
          break;
        case 'ONT':
        case 'WORK':
          this.visible = false;
          this.isZoomed = false;
      }
    } else {
      switch (newMode.window) {
        case 'HISTORY':
        case 'ONT':
        case 'WORK':
          this.isZoomed = false;
          this.visible = true;
      }
    }
    this.ResizeHeight();
    this.splitterDragged();
  },
  '',
  i2b2.CRC.view.history,
);

console.timeEnd('execute time');
console.groupEnd();
