# I2B2 Core Source

Up until Shrine Release/1.23.5 we have maintained a clean separation of i2b2 source code and decorated any existing functionality in the shrine-cell project. This readme is a manifest of any direct changes to i2b2 source for bug fixes. The fixes will also be noted as a comment in the code with the Jira ticket number.

### **[SHRINE-2599](https://open.med.harvard.edu/jira/browse/SHRINE-2599)**

- `i2b2-src/hive/i2b2_cell_communicator.js`

### **[SHRINE-2703](https://open.med.harvard.edu/jira/browse/SHRINE-2703)**

- `i2b2-src/js-i2b2/cells/ONT/ONT_sdx_CONCPT.js`

### **[SHRINE-2751](https://open.med.harvard.edu/jira/browse/SHRINE-2751)**

- `i2b2-src/js-i2b2/cells/PM/PM_ctrlr.js`

### **[SHRINE-2911](https://open.med.harvard.edu/jira/browse/SHRINE-2911)**

- `i2b2-src/js-i2b2/cells/CRC/CRC_view_History.js`

```javascript
// Relevant snippet from CRC_view_History.js
 i2b2.CRC.view.history.ContextMenu = new YAHOO.widget.ContextMenu(
                "divContextMenu-History",
                { lazyload: true,
                    trigger: $('crcHistoryBox'),
                    itemdata: [
                        { text: "Rename", 	onclick: { fn: i2b2.CRC.view.history.doRename } },
                        { text: "Delete", 		onclick: { fn: i2b2.CRC.view.history.doDelete } },
                        { text: "Refresh All",	onclick: { fn: i2b2.CRC.view.history.doRefreshAll } },
                        { text: "Flag",  onclick: { fn: i2b2.CRC.view.history.doQueryFlagPrompt }},
                        { text: "Unflag",  onclick: { fn: i2b2.CRC.view.history.doUnflag}}
                    ] }
            );
            i2b2.CRC.view.history.ContextMenu.subscribe("triggerContextMenu",i2b2.CRC.view.history.ContextMenuValidate);

// =========================================================
        }
    })
```
