(function () {
    'use strict';

    angular
        .module('shrine.steward.login')
        .factory('LoginService', LoginService);

    LoginService.$inject = ['$http','StewardService', '$rootScope', '$location', '$interval'];
    function LoginService($http, StewardService, $rootScope, $location, $interval) {
        var svc = StewardService;

        idleHandle();

        return {
            setBearerAuthHeader: setBearerAuthHeader,
            userToBase64: userToBase64,
            setCredentials: setCredentials,
            clearCredentials: clearCredentials
        };

        function userToBase64(username, password) {
            return svc.commonService.toBase64(username + ':' + password);
        }

        function toBase64(token) {
            return svc.commonService.toBase64(JSON.stringify(token));
        }

        function setBearerAuthHeader(token) {
            $http.defaults.headers.common['Authorization'] =  'Bearer ' + toBase64(token);
        }

        function setCredentials(username, roles) {
            svc.setAppUser(username, roles);
        }

        function clearCredentials() {
            svc.deleteAppUser();
            $http.defaults.headers.common.Authorization = ' Bearer ';
        }

        function idleHandle() {
            // -- auto logout on idle -- //
            var twentyMinutes = 20*60*1000;
            var logoutPromise = $interval(timeout, twentyMinutes);
            var idleEvent = 'idleEvent';
            $rootScope.$on('$destroy', function () {
                $interval.cancel(logoutPromise);
            });
            $rootScope.$on(idleEvent, function () {
                $interval.cancel(logoutPromise);
                logoutPromise = $interval(timeout, twentyMinutes);
            });


            /**
             * When the interval is called, that means the user has gone idle, so we
             * clear their credentials then navigate them back to the home page.
             */
            function timeout() {
                clearCredentials();
                $location.url("/login");
            }

            $rootScope.idleBroadcast = function() {
                $rootScope.$broadcast(idleEvent);
            }
        }

    }
})();
