/*
 * Decompiled with CFR 0.152.
 */
package net.shrine.api.ontology;

import cats.Applicative;
import cats.Apply;
import cats.data.NonEmptyList;
import cats.data.Validated;
import cats.effect.ContextShift;
import cats.effect.IO;
import cats.effect.IO$;
import cats.effect.Sync;
import cats.implicits$;
import ch.qos.logback.classic.Logger;
import io.circe.Decoder;
import io.circe.Decoder$;
import io.circe.DecodingFailure;
import io.circe.HCursor;
import io.circe.generic.decoding.DerivedDecoder;
import io.circe.generic.decoding.DerivedDecoder$;
import io.circe.generic.decoding.ReprDecoder;
import io.circe.generic.decoding.ReprDecoder$;
import io.circe.parser.package$;
import java.io.File;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.nio.file.Path;
import net.shrine.api.ontology.CODE_CATEGORY;
import net.shrine.api.ontology.CODE_SET;
import net.shrine.api.ontology.CaseInsensitiveSort$;
import net.shrine.api.ontology.CodeCategory;
import net.shrine.api.ontology.CodeCategoryTerm;
import net.shrine.api.ontology.CodeCategoryTerm$;
import net.shrine.api.ontology.ConceptInfo;
import net.shrine.api.ontology.ConceptInfo$;
import net.shrine.api.ontology.ConceptType;
import net.shrine.api.ontology.FilterData;
import net.shrine.api.ontology.FilterOption;
import net.shrine.api.ontology.FilterType;
import net.shrine.api.ontology.FilterableType;
import net.shrine.api.ontology.HtmlHighlighter$;
import net.shrine.api.ontology.LuceneSearcher;
import net.shrine.api.ontology.NO_FILTER;
import net.shrine.api.ontology.OntologyPath;
import net.shrine.api.ontology.OntologyTerm;
import net.shrine.api.ontology.SearchQuery;
import net.shrine.api.ontology.SearchResults;
import net.shrine.api.ontology.SearchResultsMetadata;
import net.shrine.api.ontology.Trie;
import net.shrine.api.ontology.TrieNode;
import net.shrine.api.ontology.VisualAttributes;
import net.shrine.api.ontology.VisualAttributes$;
import net.shrine.config.ConfigSource$;
import net.shrine.http4s.catsio.ExecutionContexts$;
import net.shrine.log.Loggable;
import net.shrine.ontology.LabDetail;
import net.shrine.problem.RawProblem;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.queryparser.classic.QueryParserBase;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.FieldDoc;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopFieldDocs;
import org.apache.lucene.search.TotalHits;
import org.apache.lucene.search.highlight.Highlighter;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.util.BytesRef;
import org.http4s.EntityDecoder;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Symbol;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.SortedMap;
import scala.collection.immutable.SortedMap$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.concurrent.ExecutionContext;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import shapeless.;
import shapeless.DefaultSymbolicLabelling;
import shapeless.Generic;
import shapeless.HList;
import shapeless.HNil;
import shapeless.HNil$;
import shapeless.LabelledGeneric$;
import shapeless.Lazy$;
import shapeless.Witness$;
import shapeless.lazily$;
import shapeless.ops.hlist;

public final class LuceneSearcher$
implements Loggable {
    public static LuceneSearcher$ MODULE$;
    private String indexFileLocation;
    private File indexDir;
    private FSDirectory directory;
    private IndexSearcher searcher;
    private Logger net$shrine$log$Loggable$$internalLogger;
    private volatile byte bitmap$0;

    static {
        new LuceneSearcher$();
    }

    public Logger logger() {
        return Loggable.logger$((Loggable)this);
    }

    public final boolean debugEnabled() {
        return Loggable.debugEnabled$((Loggable)this);
    }

    public final boolean infoEnabled() {
        return Loggable.infoEnabled$((Loggable)this);
    }

    public void debug(Function0<String> s) {
        Loggable.debug$((Loggable)this, s);
    }

    public final void debug(Function0<String> s, Throwable e) {
        Loggable.debug$((Loggable)this, s, (Throwable)e);
    }

    public void info(Function0<String> s) {
        Loggable.info$((Loggable)this, s);
    }

    public final void info(Function0<String> s, Throwable e) {
        Loggable.info$((Loggable)this, s, (Throwable)e);
    }

    public void warn(Function0<String> s) {
        Loggable.warn$((Loggable)this, s);
    }

    public final void warn(Function0<String> s, Throwable e) {
        Loggable.warn$((Loggable)this, s, (Throwable)e);
    }

    public void error(Function0<String> s) {
        Loggable.error$((Loggable)this, s);
    }

    public final void error(Function0<String> s, Throwable e) {
        Loggable.error$((Loggable)this, s, (Throwable)e);
    }

    public void log(RawProblem problem) {
        Loggable.log$((Loggable)this, (RawProblem)problem);
    }

    public <T> T logDuration(String taskName, Function1<String, BoxedUnit> log, Function0<T> f) {
        return (T)Loggable.logDuration$((Loggable)this, (String)taskName, log, f);
    }

    private Logger net$shrine$log$Loggable$$internalLogger$lzycompute() {
        LuceneSearcher$ luceneSearcher$ = this;
        synchronized (luceneSearcher$) {
            if ((byte)(this.bitmap$0 & 0x10) == 0) {
                this.net$shrine$log$Loggable$$internalLogger = Loggable.net$shrine$log$Loggable$$internalLogger$((Loggable)this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x10);
            }
        }
        return this.net$shrine$log$Loggable$$internalLogger;
    }

    public Logger net$shrine$log$Loggable$$internalLogger() {
        return (byte)(this.bitmap$0 & 0x10) == 0 ? this.net$shrine$log$Loggable$$internalLogger$lzycompute() : this.net$shrine$log$Loggable$$internalLogger;
    }

    private String indexFileLocation$lzycompute() {
        LuceneSearcher$ luceneSearcher$ = this;
        synchronized (luceneSearcher$) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.indexFileLocation = ConfigSource$.MODULE$.config().getString("shrine.lucene.directory");
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.indexFileLocation;
    }

    private String indexFileLocation() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.indexFileLocation$lzycompute() : this.indexFileLocation;
    }

    private File indexDir$lzycompute() {
        LuceneSearcher$ luceneSearcher$ = this;
        synchronized (luceneSearcher$) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.indexDir = new File(this.indexFileLocation());
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.indexDir;
    }

    private File indexDir() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.indexDir$lzycompute() : this.indexDir;
    }

    private FSDirectory directory$lzycompute() {
        LuceneSearcher$ luceneSearcher$ = this;
        synchronized (luceneSearcher$) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.directory = FSDirectory.open((Path)this.indexDir().toPath());
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.directory;
    }

    private FSDirectory directory() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.directory$lzycompute() : this.directory;
    }

    private IndexSearcher searcher$lzycompute() {
        LuceneSearcher$ luceneSearcher$ = this;
        synchronized (luceneSearcher$) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                this.searcher = new IndexSearcher((IndexReader)DirectoryReader.open((Directory)this.directory()));
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
        }
        return this.searcher;
    }

    public IndexSearcher searcher() {
        return (byte)(this.bitmap$0 & 8) == 0 ? this.searcher$lzycompute() : this.searcher;
    }

    private CodeCategoryTerm createCodeCategoryTerm(String displayName, List<OntologyTerm> children) {
        String x$1 = displayName;
        List<OntologyTerm> x$2 = children;
        ConceptType x$3 = CodeCategoryTerm$.MODULE$.apply$default$2();
        boolean x$4 = CodeCategoryTerm$.MODULE$.apply$default$3();
        return new CodeCategoryTerm(x$1, x$3, x$4, x$2);
    }

    public IO<List<CodeCategoryTerm>> getRootTerms() {
        IO<TopFieldDocs> foundDocsIO = this.getRootFieldDocs();
        return foundDocsIO.map((Function1 & Serializable & scala.Serializable)foundDocs -> {
            Map docsToCodeCategories = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])foundDocs.scoreDocs)).groupBy((Function1 & Serializable & scala.Serializable)sd -> MODULE$.searcher().doc(sd.doc).get("codeCategory"));
            SortedMap sortedDocsToCategories = (SortedMap)SortedMap$.MODULE$.apply((Seq)docsToCodeCategories.toSeq().sortBy((Function1 & Serializable & scala.Serializable)x$1 -> (String)x$1._1(), (Ordering)Ordering.String$.MODULE$), (Ordering)Ordering.String$.MODULE$);
            Iterable codeCategoryTerms = (Iterable)sortedDocsToCategories.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                String string;
                ScoreDoc[] scoreDocs;
                block3: {
                    Tuple2 tuple2;
                    block2: {
                        tuple2 = x0$1;
                        if (tuple2 == null) break block2;
                        String codeCategory = (String)tuple2._1();
                        scoreDocs = (ScoreDoc[])tuple2._2();
                        if (codeCategory == null) break block2;
                        string = codeCategory;
                        if (scoreDocs != null) break block3;
                    }
                    throw new MatchError((Object)tuple2);
                }
                ScoreDoc[] scoreDocArray = scoreDocs;
                List ontologyTermsList = (List)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])scoreDocArray)).toList().map((Function1 & Serializable & scala.Serializable)sd -> MODULE$.extractOntologyTermFromScoreDoc((ScoreDoc)sd, MODULE$.extractOntologyTermFromScoreDoc$default$2()), List$.MODULE$.canBuildFrom());
                CodeCategoryTerm codeCategoryTerm = MODULE$.createCodeCategoryTerm(string, (List<OntologyTerm>)ontologyTermsList);
                return codeCategoryTerm;
            }, Iterable$.MODULE$.canBuildFrom());
            return codeCategoryTerms.toList();
        });
    }

    public IO<Option<OntologyTerm>> getSingleTermByPathAndDisplayName(String path, String displayName) {
        BooleanQuery pathAndNameQuery = new BooleanQuery.Builder().add((Query)new TermQuery(new Term("path", path)), BooleanClause.Occur.MUST).build();
        IO<List<ScoreDoc>> scoreDocsIO = this.getRawSearchResults((Query)pathAndNameQuery);
        return scoreDocsIO.map((Function1 & Serializable & scala.Serializable)sds -> {
            Option option;
            if (sds.size() > 1) {
                MODULE$.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(104).append("displayName and path should be unique to an ontology term. ").append("For path (").append(path).append(") and displayName (").append(displayName).append(") found ").append(sds.size()).append(" results").toString());
                Option displayNameOrisRootMatch = sds.find((Function1 & Serializable & scala.Serializable)scoreDoc -> BoxesRunTime.boxToBoolean((boolean)LuceneSearcher$.$anonfun$getSingleTermByPathAndDisplayName$3(displayName, scoreDoc)));
                option = (Option)displayNameOrisRootMatch.fold((Function0 & Serializable & scala.Serializable)() -> sds.headOption().map((Function1 & Serializable & scala.Serializable)x$2 -> MODULE$.extractOntologyTermFromScoreDoc((ScoreDoc)x$2, MODULE$.extractOntologyTermFromScoreDoc$default$2())), (Function1 & Serializable & scala.Serializable)x$3 -> displayNameOrisRootMatch.map((Function1 & Serializable & scala.Serializable)x$4 -> MODULE$.extractOntologyTermFromScoreDoc((ScoreDoc)x$4, MODULE$.extractOntologyTermFromScoreDoc$default$2())));
            } else {
                option = sds.headOption().map((Function1 & Serializable & scala.Serializable)x$5 -> MODULE$.extractOntologyTermFromScoreDoc((ScoreDoc)x$5, MODULE$.extractOntologyTermFromScoreDoc$default$2()));
            }
            return option;
        });
    }

    public IO<List<FilterOption>> getFilterOptions() {
        FilterOption defaultOption = new FilterOption(new NO_FILTER(), "All Concepts", "All Concepts");
        IO<TopFieldDocs> foundDocsIO = this.getRootFieldDocs();
        return foundDocsIO.map((Function1 & Serializable & scala.Serializable)foundDocs -> {
            String[] allCodeCategories = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])foundDocs.scoreDocs)).map((Function1 & Serializable & scala.Serializable)sd -> MODULE$.searcher().doc(sd.doc).get("codeCategory"), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).distinct();
            List codeCategoryOptions = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])allCodeCategories)).map((Function1 & Serializable & scala.Serializable)codeCategory -> {
                String string = codeCategory;
                String string2 = "Diagnoses".equals(string) ? "Diagnoses (All)" : ("Laboratory Tests".equals(string) ? "Laboratory Tests (LOINC)" : ("Medications".equals(string) ? "Medications (RxNORM)" : ("Procedures".equals(string) ? "Procedures (All)" : string)));
                String displayableName = string2;
                return new FilterOption(new CODE_CATEGORY(), (String)codeCategory, displayableName);
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(FilterOption.class))))).toList();
            Map codeSetMap = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])foundDocs.scoreDocs)).map((Function1 & Serializable & scala.Serializable)sd -> new Tuple2((Object)MODULE$.searcher().doc(sd.doc).get("codeCategory"), (Object)MODULE$.searcher().doc(sd.doc).get("codeSet")), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).filter((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)LuceneSearcher$.$anonfun$getFilterOptions$5(x$6))))).groupBy((Function1 & Serializable & scala.Serializable)x$7 -> (String)x$7._1()).mapValues((Function1 & Serializable & scala.Serializable)arrayOfCodeCategoriesAndCodeSet -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])arrayOfCodeCategoriesAndCodeSet)).map((Function1 & Serializable & scala.Serializable)codeCategoryAndCodeSet -> new FilterOption(new CODE_SET(), (String)codeCategoryAndCodeSet._2(), (String)codeCategoryAndCodeSet._2()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(FilterOption.class))))).toList());
            List codeSetAndCategoryOptions = ((ListBuffer)codeCategoryOptions.foldLeft((Object)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$), (Function2 & Serializable & scala.Serializable)(acc, cur) -> {
                acc.$plus$eq(cur);
                Object object = codeSetMap.contains((Object)cur.filterValue()) ? acc.$plus$plus$eq((TraversableOnce)codeSetMap.apply((Object)cur.filterValue())) : BoxedUnit.UNIT;
                return acc;
            })).toList();
            List allOptions = (List)codeSetAndCategoryOptions.$plus$colon((Object)defaultOption, List$.MODULE$.canBuildFrom());
            return allOptions;
        });
    }

    public IO<Map<OntologyPath, CodeCategory>> getCodeCategoriesMap() {
        IO<TopFieldDocs> foundDocsIO = this.getRootFieldDocs();
        return foundDocsIO.map((Function1 & Serializable & scala.Serializable)foundDocs -> {
            Tuple2[] pathToCodeCategory = (Tuple2[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])foundDocs.scoreDocs)).map((Function1 & Serializable & scala.Serializable)sd -> {
                String codeCategory = MODULE$.searcher().doc(sd.doc).get("codeCategory");
                String path = MODULE$.searcher().doc(sd.doc).get("path");
                return new Tuple2((Object)new OntologyPath(path), (Object)new CodeCategory(codeCategory));
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).distinct();
            return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])pathToCodeCategory)).toMap(Predef$.MODULE$.$conforms());
        });
    }

    public IO<List<ScoreDoc>> getRawSearchResults(Query query) {
        ContextShift fileSystemContextShift = IO$.MODULE$.contextShift((ExecutionContext)ExecutionContexts$.MODULE$.fileSystemExecutionContext());
        return (IO)fileSystemContextShift.evalOn((ExecutionContext)ExecutionContexts$.MODULE$.fileSystemExecutionContext(), (Object)IO$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            int maxHits = Integer.MAX_VALUE;
            TopFieldDocs foundDocs = MODULE$.searcher().search(query, maxHits, CaseInsensitiveSort$.MODULE$.apply("displayName"));
            return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])foundDocs.scoreDocs)).toList();
        }));
    }

    public IO<List<OntologyTerm>> getChildren(OntologyPath ontologyPath) {
        String parentPath = (String)new StringOps(Predef$.MODULE$.augmentString(ontologyPath.path())).dropRight(1);
        TermQuery childrenQuery = new TermQuery(new Term("parentPath", parentPath));
        IO<List<ScoreDoc>> scoreDocsIO = this.getRawSearchResults((Query)childrenQuery);
        return scoreDocsIO.map((Function1 & Serializable & scala.Serializable)scoreDocs -> {
            void var1_1;
            List searchHits = (List)scoreDocs.map((Function1 & Serializable & scala.Serializable)sd -> MODULE$.extractOntologyTermFromScoreDoc((ScoreDoc)sd, MODULE$.extractOntologyTermFromScoreDoc$default$2()), List$.MODULE$.canBuildFrom());
            return var1_1;
        });
    }

    public IO<Option<ConceptInfo>> getConceptInfo(OntologyPath ontologyPath) {
        TermQuery pathQuery = new TermQuery(new Term("path", ontologyPath.path()));
        TermQuery childrenQuery = new TermQuery(new Term("parentPath", (String)new StringOps(Predef$.MODULE$.augmentString(ontologyPath.path())).dropRight(1)));
        BooleanQuery booleanQuery = new BooleanQuery.Builder().add((Query)pathQuery, BooleanClause.Occur.SHOULD).add((Query)childrenQuery, BooleanClause.Occur.SHOULD).build();
        IO<List<ScoreDoc>> scoreDocsIO = this.getRawSearchResults((Query)booleanQuery);
        return scoreDocsIO.map((Function1 & Serializable & scala.Serializable)scoreDocs -> {
            List childConcepts = (List)((List)scoreDocs.filter((Function1 & Serializable & scala.Serializable)sd -> BoxesRunTime.boxToBoolean((boolean)LuceneSearcher$.$anonfun$getConceptInfo$2(ontologyPath, sd)))).map((Function1 & Serializable & scala.Serializable)x$8 -> ConceptInfo$.MODULE$.apply((ScoreDoc)x$8, ConceptInfo$.MODULE$.apply$default$2(), ConceptInfo$.MODULE$.apply$default$3()), List$.MODULE$.canBuildFrom());
            Option scoreDocOption = scoreDocs.find((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean((boolean)LuceneSearcher$.$anonfun$getConceptInfo$4(ontologyPath, p)));
            Option conceptInfoTerm = scoreDocOption.map((Function1 & Serializable & scala.Serializable)scoreDoc -> {
                ConceptInfo conceptInfo;
                block3: {
                    Tuple3 tuple3;
                    block2: {
                        ConceptInfo conceptInfo2;
                        String nPath = MODULE$.searcher().doc(scoreDoc.doc).get("nPath");
                        String visAttrPath = new StringBuilder(3).append("\\CA").append(MODULE$.searcher().doc(scoreDoc.doc).get("visPath")).toString();
                        String[] pathElements = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])nPath.split("\\\\"))).filterNot((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)LuceneSearcher$.$anonfun$getConceptInfo$6(x$9)));
                        String[] pathElementsReverse = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])pathElements)).reverse();
                        String[] visPathElementsReverse = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])visAttrPath.split("\\\\"))).filterNot((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)LuceneSearcher$.$anonfun$getConceptInfo$7(x$10))))).reverse();
                        ConceptInfo selectedConceptInfo = ConceptInfo$.MODULE$.apply(nPath, (String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])pathElementsReverse)).head(), VisualAttributes$.MODULE$.apply((String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])visPathElementsReverse)).head()), (Option<List<ConceptInfo>>)Option$.MODULE$.apply((Object)childConcepts), true);
                        tuple3 = (Tuple3)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])pathElementsReverse)).drop(1))).foldLeft((Object)new Tuple3((Object)selectedConceptInfo, new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])visPathElementsReverse)).drop(1), new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])pathElements)).dropRight(1)), (Function2 & Serializable & scala.Serializable)(items, pathElem) -> {
                            String[] visPaths = (String[])items._2();
                            String[] nPaths = (String[])items._3();
                            String path = new StringBuilder(2).append("\\").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])nPaths)).mkString("\\")).append("\\").toString();
                            .colon.colon childConcepts = new .colon.colon((Object)((ConceptInfo)items._1()), (List)Nil$.MODULE$);
                            ConceptInfo conceptInfo = ConceptInfo$.MODULE$.apply(path, (String)pathElem, VisualAttributes$.MODULE$.apply((String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])visPaths)).head()), (Option<List<ConceptInfo>>)Option$.MODULE$.apply((Object)childConcepts), false);
                            return new Tuple3((Object)conceptInfo, new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])visPaths)).drop(1), new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])nPaths)).dropRight(1));
                        });
                        if (tuple3 == null || (conceptInfo2 = (ConceptInfo)tuple3._1()) == null) break block2;
                        conceptInfo = conceptInfo2;
                        if (tuple3._2() != null) break block3;
                    }
                    throw new MatchError((Object)tuple3);
                }
                ConceptInfo conceptInfo3 = conceptInfo;
                ConceptInfo conceptInfo4 = conceptInfo3;
                return conceptInfo4;
            });
            return conceptInfoTerm;
        });
    }

    public OntologyTerm extractOntologyTermFromScoreDoc(ScoreDoc sd, Option<List<ScoreDoc>> childrenScoreDocs) {
        String path = this.searcher().doc(sd.doc).get("path");
        String displayName = this.searcher().doc(sd.doc).get("displayName");
        Option labFieldOption = Option$.MODULE$.apply((Object)this.searcher().doc(sd.doc).getField("labDetail"));
        boolean isLab = BoxesRunTime.unboxToBoolean((Object)labFieldOption.fold((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> false, (Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)LuceneSearcher$.$anonfun$extractOntologyTermFromScoreDoc$2(x$11))));
        String visualAttributes = this.searcher().doc(sd.doc).get("visualAttributes");
        String conceptCategory = this.searcher().doc(sd.doc).get("conceptCategory");
        return this.extractOntologyTerm(path, displayName, visualAttributes, conceptCategory, isLab, childrenScoreDocs, this.extractOntologyTerm$default$7());
    }

    public OntologyTerm extractOntologyTerm(String path, String displayName, String visualAttr, String conceptCategory, boolean isLab, Option<List<ScoreDoc>> childrenScoreDocs, Option<String> highlightedName) {
        VisualAttributes<ConceptType> visualAttributes = VisualAttributes$.MODULE$.apply(visualAttr);
        List childrenOntologyTerms = (List)childrenScoreDocs.fold((Function0 & Serializable & scala.Serializable)() -> Nil$.MODULE$, (Function1 & Serializable & scala.Serializable)csd -> (List)csd.map((Function1 & Serializable & scala.Serializable)doc -> MODULE$.extractOntologyTermFromScoreDoc((ScoreDoc)doc, MODULE$.extractOntologyTermFromScoreDoc$default$2()), List$.MODULE$.canBuildFrom()));
        String x$1 = displayName;
        Option<String> x$2 = highlightedName;
        String x$3 = path;
        String x$4 = conceptCategory;
        ConceptType x$5 = visualAttributes.conceptType();
        boolean x$6 = visualAttributes.isActive();
        Option x$7 = Option$.MODULE$.apply((Object)childrenOntologyTerms);
        boolean x$8 = isLab;
        OntologyTerm ontTerm = new OntologyTerm(x$1, x$2, x$3, x$4, x$5, x$6, x$8, (Option<List<OntologyTerm>>)x$7);
        return ontTerm;
    }

    public Option<List<ScoreDoc>> extractOntologyTermFromScoreDoc$default$2() {
        return None$.MODULE$;
    }

    public Option<List<ScoreDoc>> extractOntologyTerm$default$6() {
        return None$.MODULE$;
    }

    public Option<String> extractOntologyTerm$default$7() {
        return None$.MODULE$;
    }

    public IO<SearchResults> searchIO(SearchQuery searchQuery) {
        String sortTerm = "nPath";
        ContextShift fileSystemContextShift = IO$.MODULE$.contextShift((ExecutionContext)ExecutionContexts$.MODULE$.fileSystemExecutionContext());
        return (IO)fileSystemContextShift.evalOn((ExecutionContext)ExecutionContexts$.MODULE$.fileSystemExecutionContext(), (Object)IO$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            QueryParser displayNameQueryParser = new QueryParser("displayName", (Analyzer)new StandardAnalyzer());
            displayNameQueryParser.setDefaultOperator(QueryParser.Operator.AND);
            String escapedSearchString = searchQuery.searchString().matches(".*\\s+$") ? QueryParserBase.escape((String)searchQuery.searchString().trim()) : new StringBuilder(1).append(QueryParserBase.escape((String)searchQuery.searchString())).append("*").toString();
            Query displayNameQuery = displayNameQueryParser.parse(escapedSearchString);
            TermQuery basecodeQuery = new TermQuery(new Term("basecode", searchQuery.searchString()));
            BooleanQuery displayNameAndBasecodeQuery = new BooleanQuery.Builder().add(displayNameQuery, BooleanClause.Occur.SHOULD).add((Query)basecodeQuery, BooleanClause.Occur.SHOULD).setMinimumNumberShouldMatch(1).build();
            Query filteredQuery = LuceneSearcher$.makeFilteredQuery$1((Query)displayNameAndBasecodeQuery, searchQuery.filterData());
            int maxResults = ConfigSource$.MODULE$.config().getInt("shrine.lucene.maxSearchResults");
            Sort sort = CaseInsensitiveSort$.MODULE$.apply(sortTerm);
            Option<SearchResultsMetadata> previousSearchMetadataOption = searchQuery.previousSearchMetadata();
            TopFieldDocs foundDocs = (TopFieldDocs)previousSearchMetadataOption.fold((Function0 & Serializable & scala.Serializable)() -> MODULE$.searcher().search(filteredQuery, maxResults, sort), (Function1 & Serializable & scala.Serializable)searchMetadata -> {
                BytesRef field = new BytesRef((CharSequence)searchMetadata.sortFieldValue());
                Object[] fields = new Object[]{field};
                FieldDoc lastScoreDoc = new FieldDoc(searchMetadata.lastDocId(), Float.NaN, fields);
                return MODULE$.searcher().searchAfter((ScoreDoc)lastScoreDoc, filteredQuery, maxResults, sort, false);
            });
            Highlighter highlighter = HtmlHighlighter$.MODULE$.createHighlighter(filteredQuery);
            return new Tuple2((Object)foundDocs, (Object)highlighter);
        }).flatMap((Function1 & Serializable & scala.Serializable)params -> {
            TopFieldDocs topFieldDocs;
            Highlighter highlighter;
            block6: {
                Tuple2 tuple2;
                block5: {
                    tuple2 = params;
                    if (tuple2 == null) break block5;
                    TopFieldDocs allDocs = (TopFieldDocs)tuple2._1();
                    highlighter = (Highlighter)tuple2._2();
                    if (allDocs == null) break block5;
                    topFieldDocs = allDocs;
                    if (highlighter != null) break block6;
                }
                throw new MatchError((Object)tuple2);
            }
            Highlighter highlighter2 = highlighter;
            Tuple2 tuple2 = new Tuple2((Object)topFieldDocs, (Object)highlighter2);
            Tuple2 tuple22 = tuple2;
            TopFieldDocs allDocs = (TopFieldDocs)tuple22._1();
            Highlighter highlighter3 = (Highlighter)tuple22._2();
            ScoreDoc[] scoreDocs = allDocs.scoreDocs;
            TotalHits totalHits = allDocs.totalHits;
            Map codeCategoriesToDocsWithNulls = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])scoreDocs)).groupBy((Function1 & Serializable & scala.Serializable)sd -> MODULE$.searcher().doc(sd.doc).get("codeCategory"));
            Tuple2 tuple23 = codeCategoriesToDocsWithNulls.partition((Function1 & Serializable & scala.Serializable)x$13 -> BoxesRunTime.boxToBoolean((boolean)LuceneSearcher$.$anonfun$searchIO$6(x$13)));
            if (tuple23 == null) {
                throw new MatchError((Object)tuple23);
            }
            Map codeCategoriesToDocs = (Map)tuple23._1();
            Map nullsToDocs = (Map)tuple23._2();
            Tuple2 tuple24 = new Tuple2((Object)codeCategoriesToDocs, (Object)nullsToDocs);
            Tuple2 tuple25 = tuple24;
            Map codeCategoriesToDocs2 = (Map)tuple25._1();
            Map nullsToDocs2 = (Map)tuple25._2();
            if (nullsToDocs2.nonEmpty()) {
                MODULE$.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(37).append("Some docs have null code categories: ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])nullsToDocs2.apply(null))).mkString(", ")).toString());
            }
            SortedMap sortedDocsToCategories = (SortedMap)SortedMap$.MODULE$.apply(codeCategoriesToDocs2.iterator().toSeq(), (Ordering)Ordering.String$.MODULE$);
            Iterable codeCategoryTerms = (Iterable)sortedDocsToCategories.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                String string;
                ScoreDoc[] scoreDocs;
                block3: {
                    Tuple2 tuple2;
                    block2: {
                        tuple2 = x0$1;
                        if (tuple2 == null) break block2;
                        String codeCategory = (String)tuple2._1();
                        scoreDocs = (ScoreDoc[])tuple2._2();
                        if (codeCategory == null) break block2;
                        string = codeCategory;
                        if (scoreDocs != null) break block3;
                    }
                    throw new MatchError((Object)tuple2);
                }
                ScoreDoc[] scoreDocArray = scoreDocs;
                Trie trie = new Trie(highlighter3);
                new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])scoreDocArray)).map((Function1 & Serializable & scala.Serializable)sd -> {
                    trie.insert(sd);
                    return BoxedUnit.UNIT;
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Unit()));
                IO ontTermsIO = IO$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> MODULE$.buildOntologyTerms(trie.root(), MODULE$.buildOntologyTerms$default$2()));
                IO iO = ontTermsIO.flatMap((Function1 & Serializable & scala.Serializable)ontTermsList -> IO$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> MODULE$.createCodeCategoryTerm(string, (List<OntologyTerm>)ontTermsList)));
                return iO;
            }, Iterable$.MODULE$.canBuildFrom());
            IO codeCategoryIO = (IO)implicits$.MODULE$.toTraverseOps((Object)codeCategoryTerms.toList(), implicits$.MODULE$.catsStdInstancesForList()).sequence(Predef$.MODULE$.$conforms(), (Applicative)IO$.MODULE$.ioEffect());
            return codeCategoryIO.flatMap((Function1 & Serializable & scala.Serializable)terms -> {
                Option lastScoreDocOption = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])scoreDocs)).lastOption();
                Option searchResultsMetadataOption = lastScoreDocOption.map((Function1 & Serializable & scala.Serializable)lastScoreDoc -> new SearchResultsMetadata(lastScoreDoc.doc, MODULE$.searcher().doc(lastScoreDoc.doc).get(sortTerm)));
                return IO$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> new SearchResults(totalHits$1.value, (Option<SearchResultsMetadata>)searchResultsMetadataOption, (List<CodeCategoryTerm>)terms));
            });
        }));
    }

    public List<OntologyTerm> buildOntologyTerms(TrieNode node, String path) {
        Iterable ontTermResults = (Iterable)node.children().map((Function1 & Serializable & scala.Serializable)childItem -> {
            String childKey = (String)childItem._1();
            TrieNode child = (TrieNode)node.children().apply((Object)childKey);
            String currentPath = new StringBuilder(1).append(path).append(childKey).append("\\").toString();
            Option<OntologyTerm> ontTermOption = child.ontTerm();
            List<OntologyTerm> childOntTerms = MODULE$.buildOntologyTerms(child, String.valueOf(currentPath));
            return ((OntologyTerm)ontTermOption.get()).updateChildren((Option<List<OntologyTerm>>)new Some(childOntTerms));
        }, scala.collection.mutable.Iterable$.MODULE$.canBuildFrom());
        return ontTermResults.toList();
    }

    public String buildOntologyTerms$default$2() {
        return "";
    }

    public IO<Option<LabDetail>> getLabDetailsIO(OntologyPath ontologyPath) {
        ContextShift fileSystemContextShift = IO$.MODULE$.contextShift((ExecutionContext)ExecutionContexts$.MODULE$.fileSystemExecutionContext());
        return (IO)fileSystemContextShift.evalOn((ExecutionContext)ExecutionContexts$.MODULE$.fileSystemExecutionContext(), (Object)IO$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            void var3_3;
            TermQuery nPathQuery = new TermQuery(new Term("path", ontologyPath.path()));
            TopDocs foundDocs = MODULE$.searcher().search((Query)nPathQuery, 1);
            Option res = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])foundDocs.scoreDocs)).headOption().flatMap((Function1 & Serializable & scala.Serializable)scoreDoc -> MODULE$.extractLabDetail((ScoreDoc)scoreDoc));
            return var3_3;
        }));
    }

    private Option<LabDetail> extractLabDetail(ScoreDoc scoreDoc) {
        Option labFieldOption = Option$.MODULE$.apply((Object)this.searcher().doc(scoreDoc.doc).getField("labDetail"));
        public final class Net_shrine_api_ontology_LuceneSearcher$anon$importedDecoder$macro$11$1
        implements scala.Serializable {
            private ReprDecoder<.colon.colon<Option<Seq<String>>, .colon.colon<Option<Seq<String>>, .colon.colon<Option<List<String>>, HNil>>>> inst$macro$10;
            private DerivedDecoder<LabDetail> inst$macro$1;
            private volatile byte bitmap$0;

            private ReprDecoder<.colon.colon<Option<Seq<String>>, .colon.colon<Option<Seq<String>>, .colon.colon<Option<List<String>>, HNil>>>> inst$macro$10$lzycompute() {
                Net_shrine_api_ontology_LuceneSearcher$anon$importedDecoder$macro$11$1 var1_1 = this;
                synchronized (var1_1) {
                    if ((byte)(this.bitmap$0 & 1) == 0) {
                        this.inst$macro$10 = new ReprDecoder<.colon.colon<Option<Seq<String>>, .colon.colon<Option<Seq<String>>, .colon.colon<Option<List<String>>, HNil>>>>(null){
                            private final Decoder<Option<Seq<String>>> circeGenericDecoderForunits;
                            private final Decoder<Option<List<String>>> circeGenericDecoderForenumValues;
                            private volatile byte bitmap$init$0;

                            public final Either<DecodingFailure, .colon.colon<Option<Seq<String>>, .colon.colon<Option<Seq<String>>, .colon.colon<Option<List<String>>, HNil>>>> apply(HCursor c) {
                                return (Either)ReprDecoder$.MODULE$.consResults((Object)this.circeGenericDecoderForunits.tryDecode(c.downField("flagValues")), ReprDecoder$.MODULE$.consResults((Object)this.circeGenericDecoderForunits.tryDecode(c.downField("units")), ReprDecoder$.MODULE$.consResults((Object)this.circeGenericDecoderForenumValues.tryDecode(c.downField("enumValues")), (Object)ReprDecoder$.MODULE$.hnilResult(), (Apply)Decoder$.MODULE$.resultInstance()), (Apply)Decoder$.MODULE$.resultInstance()), (Apply)Decoder$.MODULE$.resultInstance());
                            }

                            public final Validated<NonEmptyList<DecodingFailure>, .colon.colon<Option<Seq<String>>, .colon.colon<Option<Seq<String>>, .colon.colon<Option<List<String>>, HNil>>>> decodeAccumulating(HCursor c) {
                                return (Validated)ReprDecoder$.MODULE$.consResults((Object)this.circeGenericDecoderForunits.tryDecodeAccumulating(c.downField("flagValues")), ReprDecoder$.MODULE$.consResults((Object)this.circeGenericDecoderForunits.tryDecodeAccumulating(c.downField("units")), ReprDecoder$.MODULE$.consResults((Object)this.circeGenericDecoderForenumValues.tryDecodeAccumulating(c.downField("enumValues")), (Object)ReprDecoder$.MODULE$.hnilResultAccumulating(), (Apply)Decoder$.MODULE$.accumulatingResultInstance()), (Apply)Decoder$.MODULE$.accumulatingResultInstance()), (Apply)Decoder$.MODULE$.accumulatingResultInstance());
                            }
                            {
                                this.circeGenericDecoderForunits = Decoder$.MODULE$.decodeOption(Decoder$.MODULE$.decodeSeq(Decoder$.MODULE$.decodeString()));
                                this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 1);
                                this.circeGenericDecoderForenumValues = Decoder$.MODULE$.decodeOption(Decoder$.MODULE$.decodeList(Decoder$.MODULE$.decodeString()));
                                this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 2);
                            }
                        };
                        this.bitmap$0 = (byte)(this.bitmap$0 | 1);
                    }
                }
                return this.inst$macro$10;
            }

            public ReprDecoder<.colon.colon<Option<Seq<String>>, .colon.colon<Option<Seq<String>>, .colon.colon<Option<List<String>>, HNil>>>> inst$macro$10() {
                return (byte)(this.bitmap$0 & 1) == 0 ? this.inst$macro$10$lzycompute() : this.inst$macro$10;
            }

            private DerivedDecoder<LabDetail> inst$macro$1$lzycompute() {
                Net_shrine_api_ontology_LuceneSearcher$anon$importedDecoder$macro$11$1 var1_1 = this;
                synchronized (var1_1) {
                    if ((byte)(this.bitmap$0 & 2) == 0) {
                        public final class Net_shrine_api_ontology_LuceneSearcher$anon$importedDecoder$macro$11$1$anon$macro$9$1
                        implements Generic<LabDetail> {
                            public .colon.colon<Option<Seq<String>>, .colon.colon<Option<Seq<String>>, .colon.colon<Option<List<String>>, HNil>>> to(LabDetail p) {
                                LabDetail labDetail = p;
                                if (labDetail == null) {
                                    throw new MatchError((Object)labDetail);
                                }
                                Option pat$macro$6 = labDetail.flagValues();
                                Option pat$macro$7 = labDetail.units();
                                Option pat$macro$8 = labDetail.enumValues();
                                .colon.colon colon2 = new .colon.colon((Object)pat$macro$6, (HList)new .colon.colon((Object)pat$macro$7, (HList)new .colon.colon((Object)pat$macro$8, (HList)HNil$.MODULE$)));
                                return colon2;
                            }

                            public LabDetail from(.colon.colon<Option<Seq<String>>, .colon.colon<Option<Seq<String>>, .colon.colon<Option<List<String>>, HNil>>> p) {
                                Option pat$macro$8;
                                Option pat$macro$7;
                                Option pat$macro$6;
                                block3: {
                                    .colon.colon<Option<Seq<String>>, .colon.colon<Option<Seq<String>>, .colon.colon<Option<List<String>>, HNil>>> colon2;
                                    block2: {
                                        colon2 = p;
                                        if (colon2 == null) break block2;
                                        pat$macro$6 = (Option)colon2.head();
                                        .colon.colon colon3 = (.colon.colon)colon2.tail();
                                        if (colon3 == null) break block2;
                                        pat$macro$7 = (Option)colon3.head();
                                        .colon.colon colon4 = (.colon.colon)colon3.tail();
                                        if (colon4 == null) break block2;
                                        pat$macro$8 = (Option)colon4.head();
                                        HNil hNil = (HNil)colon4.tail();
                                        if (HNil$.MODULE$.equals(hNil)) break block3;
                                    }
                                    throw new MatchError(colon2);
                                }
                                LabDetail labDetail = new LabDetail(pat$macro$6, pat$macro$7, pat$macro$8);
                                return labDetail;
                            }

                            public Net_shrine_api_ontology_LuceneSearcher$anon$importedDecoder$macro$11$1$anon$macro$9$1(Net_shrine_api_ontology_LuceneSearcher$anon$importedDecoder$macro$11$1 $outer) {
                            }
                        }
                        this.inst$macro$1 = DerivedDecoder$.MODULE$.deriveDecoder(LabelledGeneric$.MODULE$.materializeProduct((DefaultSymbolicLabelling)new DefaultSymbolicLabelling<LabDetail>(null){

                            public .colon.colon<Symbol, .colon.colon<Symbol, .colon.colon<Symbol, HNil>>> apply() {
                                return new .colon.colon((Object)SymbolLiteral.bootstrap("apply", "flagValues"), (HList)new .colon.colon((Object)SymbolLiteral.bootstrap("apply", "units"), (HList)new .colon.colon((Object)SymbolLiteral.bootstrap("apply", "enumValues"), (HList)HNil$.MODULE$)));
                            }
                        }, (Generic)new Net_shrine_api_ontology_LuceneSearcher$anon$importedDecoder$macro$11$1$anon$macro$9$1(null), hlist.ZipWithKeys$.MODULE$.hconsZipWithKeys(hlist.ZipWithKeys$.MODULE$.hconsZipWithKeys(hlist.ZipWithKeys$.MODULE$.hconsZipWithKeys(hlist.ZipWithKeys$.MODULE$.hnilZipWithKeys(), Witness$.MODULE$.mkWitness((Object)SymbolLiteral.bootstrap("apply", "enumValues"))), Witness$.MODULE$.mkWitness((Object)SymbolLiteral.bootstrap("apply", "units"))), Witness$.MODULE$.mkWitness((Object)SymbolLiteral.bootstrap("apply", "flagValues"))), Predef$.MODULE$.$conforms()), Lazy$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> this.inst$macro$10()));
                        this.bitmap$0 = (byte)(this.bitmap$0 | 2);
                    }
                }
                return this.inst$macro$1;
            }

            public DerivedDecoder<LabDetail> inst$macro$1() {
                return (byte)(this.bitmap$0 & 2) == 0 ? this.inst$macro$1$lzycompute() : this.inst$macro$1;
            }

            public Net_shrine_api_ontology_LuceneSearcher$anon$importedDecoder$macro$11$1() {
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$inst$macro$1$1(net.shrine.api.ontology.LuceneSearcher$anon$importedDecoder$macro$11$1 )}, serializedLambda);
            }
        }
        DerivedDecoder<LabDetail> inst$macro$12 = new Net_shrine_api_ontology_LuceneSearcher$anon$importedDecoder$macro$11$1().inst$macro$1();
        EntityDecoder labDetailDecoder = org.http4s.circe.package$.MODULE$.jsonOf((Sync)IO$.MODULE$.ioEffect(), Decoder$.MODULE$.importedDecoder((Decoder)lazily$.MODULE$.apply(Lazy$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> inst$macro$12))));
        Option ontTerm = labFieldOption.flatMap((Function1 & Serializable & scala.Serializable)labField -> {
            None$ none$;
            DerivedDecoder<LabDetail> inst$macro$24;
            String labDetailJson = labField.stringValue();
            public final class Net_shrine_api_ontology_LuceneSearcher$anon$importedDecoder$macro$23$1
            implements scala.Serializable {
                private ReprDecoder<.colon.colon<Option<Seq<String>>, .colon.colon<Option<Seq<String>>, .colon.colon<Option<List<String>>, HNil>>>> inst$macro$22;
                private DerivedDecoder<LabDetail> inst$macro$13;
                private volatile byte bitmap$0;

                private ReprDecoder<.colon.colon<Option<Seq<String>>, .colon.colon<Option<Seq<String>>, .colon.colon<Option<List<String>>, HNil>>>> inst$macro$22$lzycompute() {
                    Net_shrine_api_ontology_LuceneSearcher$anon$importedDecoder$macro$23$1 var1_1 = this;
                    synchronized (var1_1) {
                        if ((byte)(this.bitmap$0 & 1) == 0) {
                            this.inst$macro$22 = new ReprDecoder<.colon.colon<Option<Seq<String>>, .colon.colon<Option<Seq<String>>, .colon.colon<Option<List<String>>, HNil>>>>(null){
                                private final Decoder<Option<Seq<String>>> circeGenericDecoderForunits;
                                private final Decoder<Option<List<String>>> circeGenericDecoderForenumValues;
                                private volatile byte bitmap$init$0;

                                public final Either<DecodingFailure, .colon.colon<Option<Seq<String>>, .colon.colon<Option<Seq<String>>, .colon.colon<Option<List<String>>, HNil>>>> apply(HCursor c) {
                                    return (Either)ReprDecoder$.MODULE$.consResults((Object)this.circeGenericDecoderForunits.tryDecode(c.downField("flagValues")), ReprDecoder$.MODULE$.consResults((Object)this.circeGenericDecoderForunits.tryDecode(c.downField("units")), ReprDecoder$.MODULE$.consResults((Object)this.circeGenericDecoderForenumValues.tryDecode(c.downField("enumValues")), (Object)ReprDecoder$.MODULE$.hnilResult(), (Apply)Decoder$.MODULE$.resultInstance()), (Apply)Decoder$.MODULE$.resultInstance()), (Apply)Decoder$.MODULE$.resultInstance());
                                }

                                public final Validated<NonEmptyList<DecodingFailure>, .colon.colon<Option<Seq<String>>, .colon.colon<Option<Seq<String>>, .colon.colon<Option<List<String>>, HNil>>>> decodeAccumulating(HCursor c) {
                                    return (Validated)ReprDecoder$.MODULE$.consResults((Object)this.circeGenericDecoderForunits.tryDecodeAccumulating(c.downField("flagValues")), ReprDecoder$.MODULE$.consResults((Object)this.circeGenericDecoderForunits.tryDecodeAccumulating(c.downField("units")), ReprDecoder$.MODULE$.consResults((Object)this.circeGenericDecoderForenumValues.tryDecodeAccumulating(c.downField("enumValues")), (Object)ReprDecoder$.MODULE$.hnilResultAccumulating(), (Apply)Decoder$.MODULE$.accumulatingResultInstance()), (Apply)Decoder$.MODULE$.accumulatingResultInstance()), (Apply)Decoder$.MODULE$.accumulatingResultInstance());
                                }
                                {
                                    this.circeGenericDecoderForunits = Decoder$.MODULE$.decodeOption(Decoder$.MODULE$.decodeSeq(Decoder$.MODULE$.decodeString()));
                                    this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 1);
                                    this.circeGenericDecoderForenumValues = Decoder$.MODULE$.decodeOption(Decoder$.MODULE$.decodeList(Decoder$.MODULE$.decodeString()));
                                    this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 2);
                                }
                            };
                            this.bitmap$0 = (byte)(this.bitmap$0 | 1);
                        }
                    }
                    return this.inst$macro$22;
                }

                public ReprDecoder<.colon.colon<Option<Seq<String>>, .colon.colon<Option<Seq<String>>, .colon.colon<Option<List<String>>, HNil>>>> inst$macro$22() {
                    return (byte)(this.bitmap$0 & 1) == 0 ? this.inst$macro$22$lzycompute() : this.inst$macro$22;
                }

                private DerivedDecoder<LabDetail> inst$macro$13$lzycompute() {
                    Net_shrine_api_ontology_LuceneSearcher$anon$importedDecoder$macro$23$1 var1_1 = this;
                    synchronized (var1_1) {
                        if ((byte)(this.bitmap$0 & 2) == 0) {
                            public final class Net_shrine_api_ontology_LuceneSearcher$anon$importedDecoder$macro$23$1$anon$macro$21$1
                            implements Generic<LabDetail> {
                                public .colon.colon<Option<Seq<String>>, .colon.colon<Option<Seq<String>>, .colon.colon<Option<List<String>>, HNil>>> to(LabDetail p) {
                                    LabDetail labDetail = p;
                                    if (labDetail == null) {
                                        throw new MatchError((Object)labDetail);
                                    }
                                    Option pat$macro$18 = labDetail.flagValues();
                                    Option pat$macro$19 = labDetail.units();
                                    Option pat$macro$20 = labDetail.enumValues();
                                    .colon.colon colon2 = new .colon.colon((Object)pat$macro$18, (HList)new .colon.colon((Object)pat$macro$19, (HList)new .colon.colon((Object)pat$macro$20, (HList)HNil$.MODULE$)));
                                    return colon2;
                                }

                                public LabDetail from(.colon.colon<Option<Seq<String>>, .colon.colon<Option<Seq<String>>, .colon.colon<Option<List<String>>, HNil>>> p) {
                                    Option pat$macro$20;
                                    Option pat$macro$19;
                                    Option pat$macro$18;
                                    block3: {
                                        .colon.colon<Option<Seq<String>>, .colon.colon<Option<Seq<String>>, .colon.colon<Option<List<String>>, HNil>>> colon2;
                                        block2: {
                                            colon2 = p;
                                            if (colon2 == null) break block2;
                                            pat$macro$18 = (Option)colon2.head();
                                            .colon.colon colon3 = (.colon.colon)colon2.tail();
                                            if (colon3 == null) break block2;
                                            pat$macro$19 = (Option)colon3.head();
                                            .colon.colon colon4 = (.colon.colon)colon3.tail();
                                            if (colon4 == null) break block2;
                                            pat$macro$20 = (Option)colon4.head();
                                            HNil hNil = (HNil)colon4.tail();
                                            if (HNil$.MODULE$.equals(hNil)) break block3;
                                        }
                                        throw new MatchError(colon2);
                                    }
                                    LabDetail labDetail = new LabDetail(pat$macro$18, pat$macro$19, pat$macro$20);
                                    return labDetail;
                                }

                                public Net_shrine_api_ontology_LuceneSearcher$anon$importedDecoder$macro$23$1$anon$macro$21$1(Net_shrine_api_ontology_LuceneSearcher$anon$importedDecoder$macro$23$1 $outer) {
                                }
                            }
                            this.inst$macro$13 = DerivedDecoder$.MODULE$.deriveDecoder(LabelledGeneric$.MODULE$.materializeProduct((DefaultSymbolicLabelling)new DefaultSymbolicLabelling<LabDetail>(null){

                                public .colon.colon<Symbol, .colon.colon<Symbol, .colon.colon<Symbol, HNil>>> apply() {
                                    return new .colon.colon((Object)SymbolLiteral.bootstrap("apply", "flagValues"), (HList)new .colon.colon((Object)SymbolLiteral.bootstrap("apply", "units"), (HList)new .colon.colon((Object)SymbolLiteral.bootstrap("apply", "enumValues"), (HList)HNil$.MODULE$)));
                                }
                            }, (Generic)new Net_shrine_api_ontology_LuceneSearcher$anon$importedDecoder$macro$23$1$anon$macro$21$1(null), hlist.ZipWithKeys$.MODULE$.hconsZipWithKeys(hlist.ZipWithKeys$.MODULE$.hconsZipWithKeys(hlist.ZipWithKeys$.MODULE$.hconsZipWithKeys(hlist.ZipWithKeys$.MODULE$.hnilZipWithKeys(), Witness$.MODULE$.mkWitness((Object)SymbolLiteral.bootstrap("apply", "enumValues"))), Witness$.MODULE$.mkWitness((Object)SymbolLiteral.bootstrap("apply", "units"))), Witness$.MODULE$.mkWitness((Object)SymbolLiteral.bootstrap("apply", "flagValues"))), Predef$.MODULE$.$conforms()), Lazy$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> this.inst$macro$22()));
                            this.bitmap$0 = (byte)(this.bitmap$0 | 2);
                        }
                    }
                    return this.inst$macro$13;
                }

                public DerivedDecoder<LabDetail> inst$macro$13() {
                    return (byte)(this.bitmap$0 & 2) == 0 ? this.inst$macro$13$lzycompute() : this.inst$macro$13;
                }

                public Net_shrine_api_ontology_LuceneSearcher$anon$importedDecoder$macro$23$1() {
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$inst$macro$13$1(net.shrine.api.ontology.LuceneSearcher$anon$importedDecoder$macro$23$1 )}, serializedLambda);
                }
            }
            Either either = package$.MODULE$.decode(labDetailJson, Decoder$.MODULE$.importedDecoder((Decoder)lazily$.MODULE$.apply(Lazy$.MODULE$.apply(() -> LuceneSearcher$.$anonfun$extractLabDetail$3(inst$macro$24 = new Net_shrine_api_ontology_LuceneSearcher$anon$importedDecoder$macro$23$1().inst$macro$13())))));
            if (either instanceof Right) {
                Right right = (Right)either;
                LabDetail labDetail = (LabDetail)right.value();
                none$ = Option$.MODULE$.apply((Object)labDetail);
            } else if (either instanceof Left) {
                none$ = None$.MODULE$;
            } else {
                throw new MatchError((Object)either);
            }
            return none$;
        });
        return ontTerm;
    }

    private IO<TopFieldDocs> getRootFieldDocs() {
        ContextShift fileSystemContextShift = IO$.MODULE$.contextShift((ExecutionContext)ExecutionContexts$.MODULE$.fileSystemExecutionContext());
        return (IO)fileSystemContextShift.evalOn((ExecutionContext)ExecutionContexts$.MODULE$.fileSystemExecutionContext(), (Object)IO$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            int maxHits = Integer.MAX_VALUE;
            QueryParser qp = new QueryParser("isRoot", (Analyzer)new StandardAnalyzer());
            Query rootQuery = qp.parse("true");
            return MODULE$.searcher().search(rootQuery, maxHits, CaseInsensitiveSort$.MODULE$.apply("displayName"));
        }));
    }

    public static final /* synthetic */ boolean $anonfun$getSingleTermByPathAndDisplayName$3(String displayName$1, ScoreDoc scoreDoc) {
        String string = MODULE$.searcher().doc(scoreDoc.doc).get("displayName");
        String string2 = displayName$1;
        return !(string == null ? string2 != null : !string.equals(string2)) || new StringOps(Predef$.MODULE$.augmentString(MODULE$.searcher().doc(scoreDoc.doc).get("isRoot"))).toBoolean();
    }

    public static final /* synthetic */ boolean $anonfun$getFilterOptions$5(Tuple2 x$6) {
        return x$6._2() != null;
    }

    public static final /* synthetic */ boolean $anonfun$getConceptInfo$2(OntologyPath ontologyPath$1, ScoreDoc sd) {
        String string = MODULE$.searcher().doc(sd.doc).get("path");
        String string2 = ontologyPath$1.path();
        return string == null ? string2 != null : !string.equals(string2);
    }

    public static final /* synthetic */ boolean $anonfun$getConceptInfo$4(OntologyPath ontologyPath$1, ScoreDoc p) {
        String string = MODULE$.searcher().doc(p.doc).get("path");
        String string2 = ontologyPath$1.path();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$getConceptInfo$6(String x$9) {
        String string = x$9;
        String string2 = "";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$getConceptInfo$7(String x$10) {
        String string = x$10;
        String string2 = "";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$extractOntologyTermFromScoreDoc$2(IndexableField x$11) {
        return true;
    }

    private static final Query makeFilteredQuery$1(Query baseQuery, FilterData filter) {
        Query query;
        FilterType filterType = filter.filterType();
        if (filterType instanceof FilterableType) {
            FilterableType filterableType = (FilterableType)filterType;
            TermQuery filterQuery = new TermQuery(new Term(filterableType.value(), filter.filterValue()));
            query = new BooleanQuery.Builder().add(baseQuery, BooleanClause.Occur.MUST).add((Query)filterQuery, BooleanClause.Occur.MUST).build();
        } else if (filterType instanceof NO_FILTER) {
            query = baseQuery;
        } else {
            throw new MatchError((Object)filterType);
        }
        return query;
    }

    public static final /* synthetic */ boolean $anonfun$searchIO$6(Tuple2 x$13) {
        return x$13._1() != null;
    }

    public static final /* synthetic */ DerivedDecoder $anonfun$extractLabDetail$3(DerivedDecoder inst$macro$24$1) {
        return inst$macro$24$1;
    }

    private LuceneSearcher$() {
        MODULE$ = this;
        Loggable.$init$((Loggable)this);
    }
}

