/*
 * Decompiled with CFR 0.152.
 */
package net.shrine.xml;

import ch.qos.logback.classic.Logger;
import java.io.Serializable;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import net.shrine.log.Loggable;
import net.shrine.problem.RawProblem;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.generic.GenericTraversableTemplate;
import scala.collection.immutable.StringOps;
import scala.io.Source$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.xml.Document;
import scala.xml.Elem;
import scala.xml.MetaData;
import scala.xml.NamespaceBinding;
import scala.xml.Node;
import scala.xml.NodeBuffer;
import scala.xml.NodeSeq;
import scala.xml.NodeSeq$;
import scala.xml.Null$;
import scala.xml.PrettyPrinter;
import scala.xml.Text;
import scala.xml.Text$;
import scala.xml.TopScope$;
import scala.xml.Utility$;
import scala.xml.XML$;
import scala.xml.factory.XMLLoader;
import scala.xml.parsing.ConstructingParser$;

public final class XmlUtil$
implements Loggable {
    public static XmlUtil$ MODULE$;
    private Logger net$shrine$log$Loggable$$internalLogger;
    private volatile boolean bitmap$0;

    static {
        new XmlUtil$();
    }

    @Override
    public Logger logger() {
        return Loggable.logger$(this);
    }

    @Override
    public final boolean debugEnabled() {
        return Loggable.debugEnabled$(this);
    }

    @Override
    public final boolean infoEnabled() {
        return Loggable.infoEnabled$(this);
    }

    @Override
    public void debug(Function0<String> s) {
        Loggable.debug$(this, s);
    }

    @Override
    public final void debug(Function0<String> s, Throwable e) {
        Loggable.debug$(this, s, e);
    }

    @Override
    public void info(Function0<String> s) {
        Loggable.info$(this, s);
    }

    @Override
    public final void info(Function0<String> s, Throwable e) {
        Loggable.info$(this, s, e);
    }

    @Override
    public void warn(Function0<String> s) {
        Loggable.warn$(this, s);
    }

    @Override
    public final void warn(Function0<String> s, Throwable e) {
        Loggable.warn$(this, s, e);
    }

    @Override
    public void error(Function0<String> s) {
        Loggable.error$(this, s);
    }

    @Override
    public final void error(Function0<String> s, Throwable e) {
        Loggable.error$(this, s, e);
    }

    @Override
    public void log(RawProblem problem) {
        Loggable.log$(this, problem);
    }

    @Override
    public <T> T logDuration(String taskName, Function1<String, BoxedUnit> log, Function0<T> f) {
        return (T)Loggable.logDuration$(this, taskName, log, f);
    }

    private Logger net$shrine$log$Loggable$$internalLogger$lzycompute() {
        XmlUtil$ xmlUtil$ = this;
        synchronized (xmlUtil$) {
            if (!this.bitmap$0) {
                this.net$shrine$log$Loggable$$internalLogger = Loggable.net$shrine$log$Loggable$$internalLogger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.net$shrine$log$Loggable$$internalLogger;
    }

    @Override
    public Logger net$shrine$log$Loggable$$internalLogger() {
        return !this.bitmap$0 ? this.net$shrine$log$Loggable$$internalLogger$lzycompute() : this.net$shrine$log$Loggable$$internalLogger;
    }

    public Elem loadString(String xmlString) {
        return (Elem)this.safeXmlLoader().loadString(xmlString);
    }

    public XMLLoader<Elem> safeXmlLoader() {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        factory.setNamespaceAware(false);
        factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        factory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        factory.setFeature("http://xml.org/sax/features/external-general-entities", false);
        factory.setXIncludeAware(false);
        SAXParser parser = factory.newSAXParser();
        return XML$.MODULE$.withSAXParser(parser);
    }

    public String trim(NodeSeq xml) {
        return xml.text().trim();
    }

    public int toInt(NodeSeq xml) {
        return new StringOps(Predef$.MODULE$.augmentString(this.trim(xml))).toInt();
    }

    public long toLong(NodeSeq xml) {
        return new StringOps(Predef$.MODULE$.augmentString(this.trim(xml))).toLong();
    }

    public Option<Node> loadStringIgnoringRemoteResources(String xml) {
        None$ none$;
        Document document = ConstructingParser$.MODULE$.fromSource(Source$.MODULE$.fromString(xml), true).document();
        if (document == null) {
            this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(27).append("Failed to parse XML from '").append(xml).append("'").toString());
            none$ = None$.MODULE$;
        } else {
            none$ = Option$.MODULE$.apply((Object)document.docElem());
        }
        return none$;
    }

    public String stripNamespace(String s) {
        return this.stripNamespaces((Node)this.loadString(s)).toString();
    }

    public Node stripNamespaces(Node node2) {
        Node node3;
        Node node4 = node2;
        if (node4 instanceof Elem) {
            Elem elem = (Elem)node4;
            Object x$1 = null;
            TopScope$ x$2 = TopScope$.MODULE$;
            Seq x$3 = (Seq)elem.child().map((Function1 & Serializable & scala.Serializable)node -> MODULE$.stripNamespaces((Node)node), Seq$.MODULE$.canBuildFrom());
            String x$4 = elem.copy$default$2();
            MetaData x$5 = elem.copy$default$3();
            boolean x$6 = elem.copy$default$5();
            node3 = elem.copy(null, x$4, x$5, (NamespaceBinding)x$2, x$6, x$3);
        } else {
            node3 = node2;
        }
        return node3;
    }

    public Node stripWhitespace(Node node) {
        return (Node)XmlUtil$.removeWhitespaceNodes$1(node).headOption().getOrElse((Function0 & Serializable & scala.Serializable)() -> node);
    }

    public Node condense(Node node) {
        return (Node)XmlUtil$.doCondensing$1(node).headOption().getOrElse((Function0 & Serializable & scala.Serializable)() -> node);
    }

    public Node renameRootTag(String newRootTagName, Node xml) {
        Node node;
        Node node2 = xml;
        if (node2 instanceof Elem) {
            Elem elem = (Elem)node2;
            String x$1 = newRootTagName;
            String x$2 = elem.copy$default$1();
            MetaData x$3 = elem.copy$default$3();
            NamespaceBinding x$4 = elem.copy$default$4();
            boolean x$5 = elem.copy$default$5();
            Seq x$6 = elem.copy$default$6();
            node = elem.copy(x$2, x$1, x$3, x$4, x$5, x$6);
        } else {
            node = xml;
        }
        return node;
    }

    public String prettyPrint(Node xml) {
        PrettyPrinter qual$1 = new PrettyPrinter(Integer.MAX_VALUE, 2);
        Node x$1 = this.condense(xml);
        NamespaceBinding x$2 = qual$1.format$default$2();
        return qual$1.format(x$1, x$2);
    }

    public Node surroundWith(Elem outerTag, NodeSeq xml) {
        return this.surroundWith(outerTag.label(), xml);
    }

    /*
     * WARNING - void declaration
     */
    public Node surroundWith(String outerTagName, NodeSeq xml) {
        void var3_3;
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)new Text("\n\t\t\t\t"));
        $buf.$amp$plus((Object)xml);
        $buf.$amp$plus((Object)new Text("\n\t\t\t"));
        return this.renameRootTag(outerTagName, (Node)new Elem(null, "placeHolder", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)var3_3));
    }

    private static final NodeSeq removeWhitespaceNodes$1(Node node2) {
        Node node3;
        Node node4 = node2;
        Option option = Text$.MODULE$.unapply((Object)node4);
        if (!option.isEmpty()) {
            String t = (String)option.get();
            node3 = Utility$.MODULE$.isSpace((Seq)Predef$.MODULE$.wrapString(t)) ? NodeSeq$.MODULE$.Empty() : node4;
        } else if (node4 instanceof Elem) {
            Elem elem = (Elem)node4;
            Seq x$1 = (Seq)((GenericTraversableTemplate)elem.child().map((Function1 & Serializable & scala.Serializable)node -> XmlUtil$.removeWhitespaceNodes$1(node), Seq$.MODULE$.canBuildFrom())).flatten((Function1)Predef$.MODULE$.$conforms());
            String x$2 = elem.copy$default$1();
            String x$3 = elem.copy$default$2();
            MetaData x$4 = elem.copy$default$3();
            NamespaceBinding x$5 = elem.copy$default$4();
            boolean x$6 = elem.copy$default$5();
            node3 = elem.copy(x$2, x$3, x$4, x$5, x$6, x$1);
        } else {
            node3 = node2;
        }
        return node3;
    }

    public static final /* synthetic */ boolean $anonfun$condense$1(Node x$1) {
        return x$1 instanceof Text;
    }

    public static final /* synthetic */ boolean $anonfun$condense$2(Text x0$1) {
        Text text = x0$1;
        Option option = Text$.MODULE$.unapply((Object)text);
        if (option.isEmpty()) {
            throw new MatchError((Object)text);
        }
        String t = (String)option.get();
        boolean bl = Utility$.MODULE$.isSpace((Seq)Predef$.MODULE$.wrapString(t));
        return bl;
    }

    private static final Option extractOnlyNonWhitespaceChild$1(Node node) {
        Seq nonWhitespaceNodes;
        boolean hasOnlyTextChildren = node.child().forall((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)XmlUtil$.$anonfun$condense$1(x$1)));
        return !hasOnlyTextChildren ? None$.MODULE$ : ((nonWhitespaceNodes = (Seq)((TraversableLike)node.child().collect((PartialFunction)new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Node, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Text text;
                A1 A1 = x1;
                Object object = A1 instanceof Text ? (text = (Text)A1) : function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(Node x1) {
                Node node = x1;
                boolean bl = node instanceof Text;
                return bl;
            }
        }, Seq$.MODULE$.canBuildFrom())).filterNot((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)XmlUtil$.$anonfun$condense$2(x0$1)))).size() > 1 ? None$.MODULE$ : nonWhitespaceNodes.headOption());
    }

    private static final Node doCondensing$1(Node n2) {
        Node node;
        Node node2 = n2;
        if (node2 instanceof Elem) {
            Elem elem;
            Some some;
            Text text;
            Option option;
            Elem elem2 = (Elem)node2;
            Option option2 = XmlUtil$.extractOnlyNonWhitespaceChild$1(n2);
            if (option2 instanceof Some && !(option = Text$.MODULE$.unapply((Object)(text = (Text)(some = (Some)option2).value()))).isEmpty()) {
                String t = (String)option.get();
                Text x$1 = Text$.MODULE$.apply(t.trim());
                String x$2 = elem2.copy$default$1();
                String x$3 = elem2.copy$default$2();
                MetaData x$4 = elem2.copy$default$3();
                NamespaceBinding x$5 = elem2.copy$default$4();
                boolean x$6 = elem2.copy$default$5();
                elem = elem2.copy(x$2, x$3, x$4, x$5, x$6, (Seq)x$1);
            } else if (None$.MODULE$.equals(option2)) {
                Seq x$7 = (Seq)elem2.child().map((Function1 & Serializable & scala.Serializable)n -> XmlUtil$.doCondensing$1(n), Seq$.MODULE$.canBuildFrom());
                String x$8 = elem2.copy$default$1();
                String x$9 = elem2.copy$default$2();
                MetaData x$10 = elem2.copy$default$3();
                NamespaceBinding x$11 = elem2.copy$default$4();
                boolean x$12 = elem2.copy$default$5();
                elem = elem2.copy(x$8, x$9, x$10, x$11, x$12, x$7);
            } else {
                throw new MatchError((Object)option2);
            }
            node = elem;
        } else {
            node = n2;
        }
        return node;
    }

    private XmlUtil$() {
        MODULE$ = this;
        Loggable.$init$(this);
    }
}

