/*
 * Decompiled with CFR 0.152.
 */
package net.shrine.hub;

import cats.effect.IO;
import cats.effect.IO$;
import cats.effect.Sync;
import com.typesafe.config.Config;
import fs2.Stream;
import fs2.Stream$;
import java.io.Serializable;
import net.shrine.config.ConfigSource$;
import net.shrine.hub.data.store.HubDatabaseNetworkNotFoundException;
import net.shrine.hub.data.store.HubDb$;
import net.shrine.log.Log$;
import net.shrine.messagequeueservice.MessageQueueService$;
import net.shrine.messagequeueservice.Queue;
import net.shrine.protocol.version.NodeKey;
import net.shrine.protocol.version.v1.Network;
import net.shrine.protocol.version.v1.Network$;
import net.shrine.protocol.version.v1.Node;
import net.shrine.protocol.version.v1.Node$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Some;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.immutable.Iterable;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.Try;

public final class HubLifecycle$ {
    public static final HubLifecycle$ MODULE$ = new HubLifecycle$();

    public IO<BoxedUnit> initHubFromConfigIfEmptyIO() {
        return HubDb$.MODULE$.db().selectTheNetworkIO().attempt().flatMap((Function1 & Serializable)x0$1 -> {
            boolean bl = false;
            Left left = null;
            Either either = x0$1;
            if (either instanceof Left) {
                bl = true;
                left = (Left)either;
                if (left.value() instanceof HubDatabaseNetworkNotFoundException) {
                    Log$.MODULE$.debug((Function0 & Serializable)() -> "No Network record found. Building one from shrine.conf");
                    Config initialConfig = ConfigSource$.MODULE$.config().getConfig("shrine.hub.ifNoNetwork");
                    Network network = Network$.MODULE$.networkFromConfig(initialConfig);
                    return HubDb$.MODULE$.db().upsertNetworkIO(network).flatMap((Function1 & Serializable)x$1 -> HubDb$.MODULE$.db().selectAllNodesIO().map((Function1 & Serializable)x$2 -> (Iterable)x$2.map((Function1 & Serializable)x$3 -> new NodeKey(HubLifecycle$.$anonfun$initHubFromConfigIfEmptyIO$5(x$3)))).map((Function1 & Serializable)x$4 -> x$4.toSet())).flatMap((Function1 & Serializable)existingNodeKeys -> {
                        Seq nodes = Node$.MODULE$.nodesFromConfig(initialConfig);
                        Seq nodesToUpsert = (Seq)nodes.filterNot((Function1 & Serializable)node -> BoxesRunTime.boxToBoolean((boolean)existingNodeKeys.contains((Object)new NodeKey(node.key()))));
                        Seq nodeUpserts = (Seq)nodesToUpsert.map((Function1 & Serializable)node -> HubDb$.MODULE$.db().upsertNodeIO((Node)node).flatMap((Function1 & Serializable)x$5 -> IO$.MODULE$.unit()));
                        return (IO)nodeUpserts.foldLeft((Object)IO$.MODULE$.unit(), (Function2 & Serializable)(a, b) -> a.flatMap((Function1 & Serializable)x$6 -> b));
                    });
                }
            }
            if (bl) {
                Throwable x = (Throwable)left.value();
                throw x;
            }
            if (!(either instanceof Right)) throw new MatchError((Object)either);
            Right right = (Right)either;
            Network network = (Network)right.value();
            return IO$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> Log$.MODULE$.debug((Function0 & Serializable)() -> new StringBuilder(50).append(network.networkName()).append(" record found. Starting nodes from existing record").toString()));
        });
    }

    public IO<BoxedUnit> queuesFromDatabase() {
        return IO$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> Log$.MODULE$.debug((Function0 & Serializable)() -> "Start queuesFromDatabase")).flatMap((Function1 & Serializable)x$21 -> {
            BoxedUnit boxedUnit = x$21;
            IO iO = HubDb$.MODULE$.db().selectTheNetworkIO().attempt().map((Function1 & Serializable)x0$1 -> {
                boolean bl = false;
                Left left = null;
                Either either = x0$1;
                if (either instanceof Right) {
                    Right right = (Right)either;
                    Network n = (Network)right.value();
                    return new Some((Object)new Queue(n.hubQueueName()));
                }
                if (either instanceof Left) {
                    bl = true;
                    left = (Left)either;
                    if (left.value() instanceof HubDatabaseNetworkNotFoundException) {
                        return None$.MODULE$;
                    }
                }
                if (!bl) throw new MatchError((Object)either);
                Throwable x = (Throwable)left.value();
                throw x;
            }).flatMap((Function1 & Serializable)hubQueue -> IO$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> Log$.MODULE$.debug((Function0 & Serializable)() -> new StringBuilder(13).append("hub queue is ").append(hubQueue).toString())).flatMap((Function1 & Serializable)x$20 -> {
                BoxedUnit boxedUnit = x$20;
                IO iO = HubDb$.MODULE$.db().selectAllNodesIO().map((Function1 & Serializable)x$9 -> ((IterableOnceOps)x$9.map((Function1 & Serializable)x$10 -> (Queue)x$10.map((Function1 & Serializable)node -> new Queue(node.momQueueName())).get())).toList()).flatMap((Function1 & Serializable)queuesForNodes -> IO$.MODULE$.apply((Function0 & Serializable)() -> (List)queuesForNodes.$plus$plus((IterableOnce)hubQueue)).map((Function1 & Serializable)x$11 -> x$11.toSet()).flatMap((Function1 & Serializable)neededQueues -> IO$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> Log$.MODULE$.debug((Function0 & Serializable)() -> new StringBuilder(16).append("neededQueues is ").append(neededQueues).toString())).flatMap((Function1 & Serializable)x$19 -> {
                    BoxedUnit boxedUnit = x$19;
                    IO iO = MessageQueueService$.MODULE$.service().queuesIO().map((Function1 & Serializable)x$12 -> x$12.toSet()).flatMap((Function1 & Serializable)existingQueues -> IO$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> Log$.MODULE$.debug((Function0 & Serializable)() -> new StringBuilder(19).append("existingQueues are ").append(existingQueues).toString())).flatMap((Function1 & Serializable)x$18 -> {
                        BoxedUnit boxedUnit = x$18;
                        IO iO = IO$.MODULE$.apply((Function0 & Serializable)() -> (Set)neededQueues.$minus$minus((IterableOnce)existingQueues)).flatMap((Function1 & Serializable)queuesToCreate -> IO$.MODULE$.apply((Function0 & Serializable)() -> (Set)existingQueues.$minus$minus((IterableOnce)neededQueues)).flatMap((Function1 & Serializable)queuesToDelete -> IO$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> Log$.MODULE$.debug((Function0 & Serializable)() -> new StringBuilder(15).append("Create queues: ").append(queuesToCreate.mkString(",")).toString())).flatMap((Function1 & Serializable)x$17 -> {
                            BoxedUnit boxedUnit = x$17;
                            IO iO = HubLifecycle$.createQueues$1(queuesToCreate).flatMap((Function1 & Serializable)x$16 -> {
                                BoxedUnit boxedUnit = x$16;
                                IO iO = IO$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> Log$.MODULE$.debug((Function0 & Serializable)() -> new StringBuilder(15).append("Delete queues: ").append(queuesToDelete.mkString(",")).toString())).flatMap((Function1 & Serializable)x$15 -> {
                                    BoxedUnit boxedUnit = x$15;
                                    IO iO = HubLifecycle$.deleteQueues$1(queuesToDelete).flatMap((Function1 & Serializable)x$14 -> {
                                        BoxedUnit boxedUnit = x$14;
                                        IO iO = IO$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> Log$.MODULE$.debug((Function0 & Serializable)() -> "Completed queuesFromDatabase")).map((Function1 & Serializable)x$13 -> {
                                            HubLifecycle$.$anonfun$queuesFromDatabase$48(x$13);
                                            return BoxedUnit.UNIT;
                                        });
                                        return iO;
                                    });
                                    return iO;
                                });
                                return iO;
                            });
                            return iO;
                        })));
                        return iO;
                    }));
                    return iO;
                })));
                return iO;
            }));
            return iO;
        });
    }

    public static final /* synthetic */ String $anonfun$initHubFromConfigIfEmptyIO$5(Try x$3) {
        return ((Node)x$3.get()).key();
    }

    private static final IO createQueues$1(Set queues) {
        return (IO)Stream$.MODULE$.compile$extension(((Stream)((IterableOnceOps)((IterableOps)((IterableOps)queues.toSeq().map((Function1 & Serializable)x$7 -> x$7.name())).map((Function1 & Serializable)queueName -> MessageQueueService$.MODULE$.service().createQueueIfAbsentIO(queueName))).map((Function1 & Serializable)fo -> new Stream(Stream$.MODULE$.eval((Object)fo)))).foldLeft((Object)new Stream(Stream$.MODULE$.empty()), (Function2 & Serializable)(soFar, next) -> new Stream(Stream$.MODULE$.append$extension(((Stream)soFar).fs2$Stream$$free(), (Function0 & Serializable)() -> new Stream(next))))).fs2$Stream$$free(), Stream.Compiler$.MODULE$.syncInstance((Sync)IO$.MODULE$.ioEffect())).drain();
    }

    private static final IO deleteQueues$1(Set queues) {
        return (IO)Stream$.MODULE$.compile$extension(((Stream)((IterableOnceOps)((IterableOps)((IterableOps)queues.toSeq().map((Function1 & Serializable)x$8 -> x$8.name())).map((Function1 & Serializable)queueName -> MessageQueueService$.MODULE$.service().deleteQueueIO(queueName))).map((Function1 & Serializable)fo -> new Stream(Stream$.MODULE$.eval((Object)fo)))).foldLeft((Object)new Stream(Stream$.MODULE$.empty()), (Function2 & Serializable)(soFar, next) -> new Stream(Stream$.MODULE$.append$extension(((Stream)soFar).fs2$Stream$$free(), (Function0 & Serializable)() -> new Stream(next))))).fs2$Stream$$free(), Stream.Compiler$.MODULE$.syncInstance((Sync)IO$.MODULE$.ioEffect())).drain();
    }

    public static final /* synthetic */ void $anonfun$queuesFromDatabase$48(BoxedUnit x$13) {
        BoxedUnit boxedUnit = x$13;
        BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
    }

    private HubLifecycle$() {
    }
}

