/*
 * Decompiled with CFR 0.152.
 */
package fs2.io.tls;

import cats.Applicative;
import cats.Applicative$;
import cats.ApplicativeError;
import cats.FlatMap;
import cats.Functor;
import cats.effect.Concurrent;
import cats.effect.ContextShift;
import cats.effect.Sync;
import cats.effect.Sync$;
import cats.effect.concurrent.Semaphore;
import cats.effect.concurrent.Semaphore$;
import cats.syntax.ApplicativeErrorOps$;
import cats.syntax.ApplicativeOps$;
import cats.syntax.FlatMapOps$;
import cats.syntax.IfMOps$;
import cats.syntax.package;
import fs2.Chunk;
import fs2.Chunk$;
import fs2.io.tls.InputOutputBuffer;
import fs2.io.tls.InputOutputBuffer$;
import fs2.io.tls.SSLEngineTaskRunner;
import fs2.io.tls.SSLEngineTaskRunner$;
import fs2.io.tls.TLSEngine;
import fs2.io.tls.TLSEngine$;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.nio.ByteBuffer;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.concurrent.ExecutionContext;
import scala.concurrent.duration.FiniteDuration;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

public final class TLSEngine$ {
    public static final TLSEngine$ MODULE$ = new TLSEngine$();

    public <F> F apply(SSLEngine engine, TLSEngine.Binding<F> binding, ExecutionContext blocker, Option<Function1<String, F>> logger, Concurrent<F> evidence$1, ContextShift<F> evidence$2) {
        return (F)package.all$.MODULE$.toFlatMapOps(InputOutputBuffer$.MODULE$.apply(engine.getSession().getApplicationBufferSize(), engine.getSession().getPacketBufferSize(), evidence$1), evidence$1).flatMap((Function1 & Serializable)wrapBuffer -> package.all$.MODULE$.toFlatMapOps(InputOutputBuffer$.MODULE$.apply(engine.getSession().getPacketBufferSize(), engine.getSession().getApplicationBufferSize(), evidence$1), (FlatMap)evidence$1).flatMap((Function1 & Serializable)unwrapBuffer -> package.all$.MODULE$.toFlatMapOps(Semaphore$.MODULE$.apply(1L, evidence$1), (FlatMap)evidence$1).flatMap((Function1 & Serializable)readSemaphore -> package.all$.MODULE$.toFlatMapOps(Semaphore$.MODULE$.apply(1L, evidence$1), (FlatMap)evidence$1).flatMap((Function1 & Serializable)writeSemaphore -> package.all$.MODULE$.toFunctorOps(Semaphore$.MODULE$.apply(1L, evidence$1), (Functor)evidence$1).map((Function1 & Serializable)handshakeSemaphore -> {
            SSLEngineTaskRunner sslEngineTaskRunner = SSLEngineTaskRunner$.MODULE$.apply(engine, blocker, evidence$1, evidence$2);
            return new TLSEngine<F>(logger, evidence$1, engine, (Semaphore)writeSemaphore, (InputOutputBuffer)wrapBuffer, (Semaphore)handshakeSemaphore, binding, (Semaphore)readSemaphore, (InputOutputBuffer)unwrapBuffer, sslEngineTaskRunner){
                private final Option logger$1;
                private final Concurrent evidence$1$1;
                private final SSLEngine engine$1;
                private final Semaphore writeSemaphore$1;
                private final InputOutputBuffer wrapBuffer$1;
                private final Semaphore handshakeSemaphore$1;
                private final TLSEngine.Binding binding$1;
                private final Semaphore readSemaphore$1;
                private final InputOutputBuffer unwrapBuffer$1;
                private final SSLEngineTaskRunner sslEngineTaskRunner$1;

                private F log(String msg) {
                    return (F)this.logger$1.map((Function1 & Serializable)x$1 -> x$1.apply((Object)msg)).getOrElse((Function0 & Serializable)() -> Applicative$.MODULE$.apply((Applicative)$this.evidence$1$1).unit());
                }

                public F beginHandshake() {
                    return (F)Sync$.MODULE$.apply((Sync)this.evidence$1$1).delay((Function0)(JFunction0.mcV.sp & Serializable)() -> $this.engine$1.beginHandshake());
                }

                public F session() {
                    return (F)Sync$.MODULE$.apply((Sync)this.evidence$1$1).delay((Function0 & Serializable)() -> $this.engine$1.getSession());
                }

                public F applicationProtocol() {
                    return (F)Sync$.MODULE$.apply((Sync)this.evidence$1$1).delay((Function0 & Serializable)() -> $this.engine$1.getApplicationProtocol());
                }

                public F stopWrap() {
                    return (F)Sync$.MODULE$.apply((Sync)this.evidence$1$1).delay((Function0)(JFunction0.mcV.sp & Serializable)() -> $this.engine$1.closeOutbound());
                }

                public F stopUnwrap() {
                    return (F)package.all$.MODULE$.toFunctorOps(ApplicativeErrorOps$.MODULE$.attempt$extension(package.all$.MODULE$.catsSyntaxApplicativeError(Sync$.MODULE$.apply((Sync)this.evidence$1$1).delay((Function0)(JFunction0.mcV.sp & Serializable)() -> $this.engine$1.closeInbound()), (ApplicativeError)this.evidence$1$1), (ApplicativeError)this.evidence$1$1), (Functor)this.evidence$1$1).void();
                }

                public F write(Chunk<Object> data, Option<FiniteDuration> timeout) {
                    return (F)this.writeSemaphore$1.withPermit(this.write0(data, timeout));
                }

                private F write0(Chunk<Object> data, Option<FiniteDuration> timeout) {
                    return (F)FlatMapOps$.MODULE$.$greater$greater$extension(package.all$.MODULE$.catsSyntaxFlatMapOps(this.wrapBuffer$1.input(data), (FlatMap)this.evidence$1$1), (Function0 & Serializable)() -> this.wrap(timeout), (FlatMap)this.evidence$1$1);
                }

                private F wrap(Option<FiniteDuration> timeout) {
                    return (F)package.all$.MODULE$.toFlatMapOps(package.all$.MODULE$.toFlatMapOps(this.wrapBuffer$1.perform((Function2 & Serializable)(x$2, x$3) -> $this.engine$1.wrap((ByteBuffer)x$2, (ByteBuffer)x$3)), (FlatMap)this.evidence$1$1).flatTap((Function1 & Serializable)result -> this.log(new StringBuilder(13).append("wrap result: ").append(result).toString())), (FlatMap)this.evidence$1$1).flatMap((Function1 & Serializable)result -> {
                        Object object;
                        SSLEngineResult.Status status = result.getStatus();
                        if (((Object)((Object)((Object)SSLEngineResult.Status.OK))).equals((Object)((Object)status))) {
                            object = FlatMapOps$.MODULE$.$greater$greater$extension(package.all$.MODULE$.catsSyntaxFlatMapOps(this.doWrite(timeout), (FlatMap)$this.evidence$1$1), (Function0 & Serializable)() -> {
                                SSLEngineResult.HandshakeStatus handshakeStatus = result.getHandshakeStatus();
                                Object object = ((Object)((Object)((Object)SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING))).equals((Object)((Object)handshakeStatus)) ? package.all$.MODULE$.toFlatMapOps($this.wrapBuffer$1.inputRemains(), (FlatMap)$this.evidence$1$1).flatMap((Function1 & Serializable)x -> anon.1.$anonfun$wrap$5(this, timeout, result, BoxesRunTime.unboxToInt((Object)x))) : FlatMapOps$.MODULE$.$greater$greater$extension(package.all$.MODULE$.catsSyntaxFlatMapOps($this.handshakeSemaphore$1.withPermit(this.stepHandshake((SSLEngineResult)result, true, timeout)), (FlatMap)$this.evidence$1$1), (Function0 & Serializable)() -> this.wrap(timeout), (FlatMap)$this.evidence$1$1);
                                return object;
                            }, (FlatMap)$this.evidence$1$1);
                        } else if (((Object)((Object)((Object)SSLEngineResult.Status.BUFFER_UNDERFLOW))).equals((Object)((Object)status))) {
                            object = this.doWrite(timeout);
                        } else if (((Object)((Object)((Object)SSLEngineResult.Status.BUFFER_OVERFLOW))).equals((Object)((Object)status))) {
                            object = FlatMapOps$.MODULE$.$greater$greater$extension(package.all$.MODULE$.catsSyntaxFlatMapOps($this.wrapBuffer$1.expandOutput(), (FlatMap)$this.evidence$1$1), (Function0 & Serializable)() -> this.wrap(timeout), (FlatMap)$this.evidence$1$1);
                        } else if (((Object)((Object)((Object)SSLEngineResult.Status.CLOSED))).equals((Object)((Object)status))) {
                            object = this.stopWrap();
                        } else {
                            throw new MatchError((Object)((Object)status));
                        }
                        return object;
                    });
                }

                private F doWrite(Option<FiniteDuration> timeout) {
                    return (F)package.all$.MODULE$.toFlatMapOps(this.wrapBuffer$1.output(Integer.MAX_VALUE), (FlatMap)this.evidence$1$1).flatMap((Function1 & Serializable)out -> out.isEmpty() ? Applicative$.MODULE$.apply((Applicative)$this.evidence$1$1).unit() : $this.binding$1.write((Chunk<Object>)out, timeout));
                }

                public F read(int maxBytes, Option<FiniteDuration> timeout) {
                    return (F)this.readSemaphore$1.withPermit(this.read0(maxBytes, timeout));
                }

                private F initialHandshakeDone() {
                    return (F)Sync$.MODULE$.apply((Sync)this.evidence$1$1).delay((Function0)(JFunction0.mcZ.sp & Serializable)() -> {
                        String string = $this.engine$1.getSession().getCipherSuite();
                        String string2 = "SSL_NULL_WITH_NULL_NULL";
                        return string == null ? string2 != null : !string.equals(string2);
                    });
                }

                private F read0(int maxBytes, Option<FiniteDuration> timeout) {
                    return (F)package.all$.MODULE$.toFlatMapOps(this.dequeueUnwrap(maxBytes), (FlatMap)this.evidence$1$1).flatMap((Function1 & Serializable)out -> out.isEmpty() ? IfMOps$.MODULE$.ifM$extension(package.all$.MODULE$.catsSyntaxIfM(this.initialHandshakeDone(), (FlatMap)$this.evidence$1$1), (Function0 & Serializable)() -> this.read1(maxBytes, timeout), (Function0 & Serializable)() -> FlatMapOps$.MODULE$.$greater$greater$extension(package.all$.MODULE$.catsSyntaxFlatMapOps(this.write((Chunk<Object>)Chunk$.MODULE$.empty(), (Option<FiniteDuration>)None$.MODULE$), (FlatMap)$this.evidence$1$1), (Function0 & Serializable)() -> package.all$.MODULE$.toFlatMapOps(this.dequeueUnwrap(maxBytes), (FlatMap)$this.evidence$1$1).flatMap((Function1 & Serializable)out -> out.isEmpty() ? this.read1(maxBytes, timeout) : Applicative$.MODULE$.apply((Applicative)$this.evidence$1$1).pure(out)), (FlatMap)$this.evidence$1$1), (FlatMap)$this.evidence$1$1) : Applicative$.MODULE$.apply((Applicative)$this.evidence$1$1).pure(out));
                }

                private F read1(int maxBytes, Option<FiniteDuration> timeout) {
                    return (F)package.all$.MODULE$.toFlatMapOps(this.binding$1.read(RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper(maxBytes), this.engine$1.getSession().getPacketBufferSize()), timeout), (FlatMap)this.evidence$1$1).flatMap((Function1 & Serializable)x0$1 -> {
                        Object object;
                        Option option = x0$1;
                        if (option instanceof Some) {
                            Some some = (Some)option;
                            Chunk c = (Chunk)some.value();
                            object = FlatMapOps$.MODULE$.$greater$greater$extension(package.all$.MODULE$.catsSyntaxFlatMapOps($this.unwrapBuffer$1.input((Chunk<Object>)c), (FlatMap)$this.evidence$1$1), (Function0 & Serializable)() -> package.all$.MODULE$.toFlatMapOps(this.unwrap(maxBytes, timeout), (FlatMap)$this.evidence$1$1).flatMap((Function1 & Serializable)x0$2 -> {
                                Object object;
                                Option option = x0$2;
                                if (option instanceof Some) {
                                    Some some = (Some)option;
                                    object = Applicative$.MODULE$.apply((Applicative)$this.evidence$1$1).pure((Object)some);
                                } else if (None$.MODULE$.equals(option)) {
                                    object = this.read1(maxBytes, timeout);
                                } else {
                                    throw new MatchError((Object)option);
                                }
                                return object;
                            }), (FlatMap)$this.evidence$1$1);
                        } else if (None$.MODULE$.equals(option)) {
                            object = Applicative$.MODULE$.apply((Applicative)$this.evidence$1$1).pure((Object)None$.MODULE$);
                        } else {
                            throw new MatchError((Object)option);
                        }
                        return object;
                    });
                }

                private F unwrap(int maxBytes, Option<FiniteDuration> timeout) {
                    return (F)package.all$.MODULE$.toFlatMapOps(package.all$.MODULE$.toFlatMapOps(this.unwrapBuffer$1.perform((Function2 & Serializable)(x$4, x$5) -> $this.engine$1.unwrap((ByteBuffer)x$4, (ByteBuffer)x$5)), (FlatMap)this.evidence$1$1).flatTap((Function1 & Serializable)result -> this.log(new StringBuilder(15).append("unwrap result: ").append(result).toString())), (FlatMap)this.evidence$1$1).flatMap((Function1 & Serializable)result -> {
                        Object object;
                        SSLEngineResult.Status status = result.getStatus();
                        if (((Object)((Object)((Object)SSLEngineResult.Status.OK))).equals((Object)((Object)status))) {
                            SSLEngineResult.HandshakeStatus handshakeStatus = result.getHandshakeStatus();
                            Object object2 = ((Object)((Object)((Object)SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING))).equals((Object)((Object)handshakeStatus)) ? IfMOps$.MODULE$.ifM$extension(package.all$.MODULE$.catsSyntaxIfM(package.all$.MODULE$.toFunctorOps($this.unwrapBuffer$1.inputRemains(), (Functor)$this.evidence$1$1).map((Function1)(JFunction1.mcZI.sp & Serializable)x$6 -> x$6 > 0 && result.bytesConsumed() > 0), (FlatMap)$this.evidence$1$1), (Function0 & Serializable)() -> this.unwrap(maxBytes, timeout), (Function0 & Serializable)() -> this.dequeueUnwrap(maxBytes), (FlatMap)$this.evidence$1$1) : (((Object)((Object)((Object)SSLEngineResult.HandshakeStatus.FINISHED))).equals((Object)((Object)handshakeStatus)) ? this.unwrap(maxBytes, timeout) : FlatMapOps$.MODULE$.$greater$greater$extension(package.all$.MODULE$.catsSyntaxFlatMapOps($this.handshakeSemaphore$1.withPermit(this.stepHandshake((SSLEngineResult)result, false, timeout)), (FlatMap)$this.evidence$1$1), (Function0 & Serializable)() -> this.unwrap(maxBytes, timeout), (FlatMap)$this.evidence$1$1));
                            object = object2;
                        } else if (((Object)((Object)((Object)SSLEngineResult.Status.BUFFER_UNDERFLOW))).equals((Object)((Object)status))) {
                            object = this.dequeueUnwrap(maxBytes);
                        } else if (((Object)((Object)((Object)SSLEngineResult.Status.BUFFER_OVERFLOW))).equals((Object)((Object)status))) {
                            object = FlatMapOps$.MODULE$.$greater$greater$extension(package.all$.MODULE$.catsSyntaxFlatMapOps($this.unwrapBuffer$1.expandOutput(), (FlatMap)$this.evidence$1$1), (Function0 & Serializable)() -> this.unwrap(maxBytes, timeout), (FlatMap)$this.evidence$1$1);
                        } else if (((Object)((Object)((Object)SSLEngineResult.Status.CLOSED))).equals((Object)((Object)status))) {
                            object = FlatMapOps$.MODULE$.$greater$greater$extension(package.all$.MODULE$.catsSyntaxFlatMapOps(FlatMapOps$.MODULE$.$greater$greater$extension(package.all$.MODULE$.catsSyntaxFlatMapOps(this.stopWrap(), (FlatMap)$this.evidence$1$1), (Function0 & Serializable)() -> this.stopUnwrap(), (FlatMap)$this.evidence$1$1), (FlatMap)$this.evidence$1$1), (Function0 & Serializable)() -> this.dequeueUnwrap(maxBytes), (FlatMap)$this.evidence$1$1);
                        } else {
                            throw new MatchError((Object)((Object)status));
                        }
                        return object;
                    });
                }

                private F dequeueUnwrap(int maxBytes) {
                    return (F)package.all$.MODULE$.toFunctorOps(this.unwrapBuffer$1.output(maxBytes), (Functor)this.evidence$1$1).map((Function1 & Serializable)out -> out.isEmpty() ? None$.MODULE$ : new Some(out));
                }

                private F stepHandshake(SSLEngineResult result, boolean lastOperationWrap, Option<FiniteDuration> timeout) {
                    Object object;
                    SSLEngineResult.HandshakeStatus handshakeStatus = result.getHandshakeStatus();
                    if (((Object)((Object)SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING)).equals((Object)((Object)handshakeStatus))) {
                        object = Applicative$.MODULE$.apply((Applicative)this.evidence$1$1).unit();
                    } else if (((Object)((Object)SSLEngineResult.HandshakeStatus.FINISHED)).equals((Object)((Object)handshakeStatus))) {
                        object = package.all$.MODULE$.toFlatMapOps(this.unwrapBuffer$1.inputRemains(), (FlatMap)this.evidence$1$1).flatMap((Function1 & Serializable)remaining -> anon.1.$anonfun$stepHandshake$1(this, timeout, BoxesRunTime.unboxToInt((Object)remaining)));
                    } else if (((Object)((Object)SSLEngineResult.HandshakeStatus.NEED_TASK)).equals((Object)((Object)handshakeStatus))) {
                        object = FlatMapOps$.MODULE$.$greater$greater$extension(package.all$.MODULE$.catsSyntaxFlatMapOps(this.sslEngineTaskRunner$1.runDelegatedTasks(), (FlatMap)this.evidence$1$1), (Function0 & Serializable)() -> lastOperationWrap ? this.wrapHandshake(timeout) : this.unwrapHandshake(timeout), (FlatMap)this.evidence$1$1);
                    } else if (((Object)((Object)SSLEngineResult.HandshakeStatus.NEED_WRAP)).equals((Object)((Object)handshakeStatus))) {
                        object = this.wrapHandshake(timeout);
                    } else if (((Object)((Object)SSLEngineResult.HandshakeStatus.NEED_UNWRAP)).equals((Object)((Object)handshakeStatus))) {
                        object = package.all$.MODULE$.toFlatMapOps(this.unwrapBuffer$1.inputRemains(), (FlatMap)this.evidence$1$1).flatMap((Function1 & Serializable)remaining -> anon.1.$anonfun$stepHandshake$3(this, result, timeout, BoxesRunTime.unboxToInt((Object)remaining)));
                    } else if (((Object)((Object)SSLEngineResult.HandshakeStatus.NEED_UNWRAP_AGAIN)).equals((Object)((Object)handshakeStatus))) {
                        object = this.unwrapHandshake(timeout);
                    } else {
                        throw new MatchError((Object)((Object)handshakeStatus));
                    }
                    return (F)object;
                }

                private F wrapHandshake(Option<FiniteDuration> timeout) {
                    return (F)package.all$.MODULE$.toFlatMapOps(package.all$.MODULE$.toFlatMapOps(this.wrapBuffer$1.perform((Function2 & Serializable)(x$7, x$8) -> $this.engine$1.wrap((ByteBuffer)x$7, (ByteBuffer)x$8)), (FlatMap)this.evidence$1$1).flatTap((Function1 & Serializable)result -> this.log(new StringBuilder(22).append("wrapHandshake result: ").append(result).toString())), (FlatMap)this.evidence$1$1).flatMap((Function1 & Serializable)result -> {
                        Object object;
                        SSLEngineResult.Status status = result.getStatus();
                        boolean bl = ((Object)((Object)((Object)SSLEngineResult.Status.OK))).equals((Object)((Object)status)) ? true : ((Object)((Object)((Object)SSLEngineResult.Status.BUFFER_UNDERFLOW))).equals((Object)((Object)status));
                        if (bl) {
                            object = FlatMapOps$.MODULE$.$greater$greater$extension(package.all$.MODULE$.catsSyntaxFlatMapOps(this.doWrite(timeout), (FlatMap)$this.evidence$1$1), (Function0 & Serializable)() -> this.stepHandshake((SSLEngineResult)result, true, timeout), (FlatMap)$this.evidence$1$1);
                        } else if (((Object)((Object)((Object)SSLEngineResult.Status.BUFFER_OVERFLOW))).equals((Object)((Object)status))) {
                            object = FlatMapOps$.MODULE$.$greater$greater$extension(package.all$.MODULE$.catsSyntaxFlatMapOps($this.wrapBuffer$1.expandOutput(), (FlatMap)$this.evidence$1$1), (Function0 & Serializable)() -> this.wrapHandshake(timeout), (FlatMap)$this.evidence$1$1);
                        } else if (((Object)((Object)((Object)SSLEngineResult.Status.CLOSED))).equals((Object)((Object)status))) {
                            object = FlatMapOps$.MODULE$.$greater$greater$extension(package.all$.MODULE$.catsSyntaxFlatMapOps(this.stopWrap(), (FlatMap)$this.evidence$1$1), (Function0 & Serializable)() -> this.stopUnwrap(), (FlatMap)$this.evidence$1$1);
                        } else {
                            throw new MatchError((Object)((Object)status));
                        }
                        return object;
                    });
                }

                private F unwrapHandshake(Option<FiniteDuration> timeout) {
                    return (F)package.all$.MODULE$.toFlatMapOps(package.all$.MODULE$.toFlatMapOps(this.unwrapBuffer$1.perform((Function2 & Serializable)(x$9, x$10) -> $this.engine$1.unwrap((ByteBuffer)x$9, (ByteBuffer)x$10)), (FlatMap)this.evidence$1$1).flatTap((Function1 & Serializable)result -> this.log(new StringBuilder(24).append("unwrapHandshake result: ").append(result).toString())), (FlatMap)this.evidence$1$1).flatMap((Function1 & Serializable)result -> {
                        Object object;
                        SSLEngineResult.Status status = result.getStatus();
                        if (((Object)((Object)((Object)SSLEngineResult.Status.OK))).equals((Object)((Object)status))) {
                            object = this.stepHandshake((SSLEngineResult)result, false, timeout);
                        } else if (((Object)((Object)((Object)SSLEngineResult.Status.BUFFER_UNDERFLOW))).equals((Object)((Object)status))) {
                            object = this.stepHandshake((SSLEngineResult)result, false, timeout);
                        } else if (((Object)((Object)((Object)SSLEngineResult.Status.BUFFER_OVERFLOW))).equals((Object)((Object)status))) {
                            object = FlatMapOps$.MODULE$.$greater$greater$extension(package.all$.MODULE$.catsSyntaxFlatMapOps($this.unwrapBuffer$1.expandOutput(), (FlatMap)$this.evidence$1$1), (Function0 & Serializable)() -> this.unwrapHandshake(timeout), (FlatMap)$this.evidence$1$1);
                        } else if (((Object)((Object)((Object)SSLEngineResult.Status.CLOSED))).equals((Object)((Object)status))) {
                            object = FlatMapOps$.MODULE$.$greater$greater$extension(package.all$.MODULE$.catsSyntaxFlatMapOps(this.stopWrap(), (FlatMap)$this.evidence$1$1), (Function0 & Serializable)() -> this.stopUnwrap(), (FlatMap)$this.evidence$1$1);
                        } else {
                            throw new MatchError((Object)((Object)status));
                        }
                        return object;
                    });
                }

                public static final /* synthetic */ Object $anonfun$wrap$5(anon.1 $this, Option timeout$2, SSLEngineResult result$1, int x) {
                    return ApplicativeOps$.MODULE$.whenA$extension(package.all$.MODULE$.catsSyntaxApplicative($this.wrap((Option<FiniteDuration>)timeout$2)), x > 0 && result$1.bytesConsumed() > 0, (Applicative)$this.evidence$1$1);
                }

                public static final /* synthetic */ Object $anonfun$stepHandshake$1(anon.1 $this, Option timeout$7, int remaining) {
                    return remaining > 0 ? $this.unwrapHandshake((Option<FiniteDuration>)timeout$7) : Applicative$.MODULE$.apply((Applicative)$this.evidence$1$1).unit();
                }

                public static final /* synthetic */ Object $anonfun$stepHandshake$6(anon.1 $this, int x) {
                    return x > 0 ? Applicative$.MODULE$.apply((Applicative)$this.evidence$1$1).unit() : $this.stopUnwrap();
                }

                /*
                 * Enabled aggressive block sorting
                 */
                public static final /* synthetic */ Object $anonfun$stepHandshake$3(anon.1 $this, SSLEngineResult result$3, Option timeout$7, int remaining) {
                    Object object;
                    if (remaining > 0) {
                        SSLEngineResult.Status status = result$3.getStatus();
                        SSLEngineResult.Status status2 = SSLEngineResult.Status.BUFFER_UNDERFLOW;
                        if (status == null ? status2 != null : !((Object)((Object)status)).equals((Object)((Object)status2))) {
                            object = $this.unwrapHandshake((Option<FiniteDuration>)timeout$7);
                            return object;
                        }
                    }
                    object = package.all$.MODULE$.toFlatMapOps($this.binding$1.read($this.engine$1.getSession().getPacketBufferSize(), (Option<FiniteDuration>)timeout$7), (FlatMap)$this.evidence$1$1).flatMap((Function1 & Serializable)x0$1 -> {
                        Object object;
                        Option option = x0$1;
                        if (option instanceof Some) {
                            Some some = (Some)option;
                            Chunk c = (Chunk)some.value();
                            object = FlatMapOps$.MODULE$.$greater$greater$extension(package.all$.MODULE$.catsSyntaxFlatMapOps($this.unwrapBuffer$1.input((Chunk<Object>)c), (FlatMap)$this.evidence$1$1), (Function0 & Serializable)() -> $this.unwrapHandshake((Option<FiniteDuration>)timeout$7), (FlatMap)$this.evidence$1$1);
                        } else if (None$.MODULE$.equals(option)) {
                            object = package.all$.MODULE$.toFlatMapOps($this.unwrapBuffer$1.inputRemains(), (FlatMap)$this.evidence$1$1).flatMap((Function1 & Serializable)x -> anon.1.$anonfun$stepHandshake$6($this, BoxesRunTime.unboxToInt((Object)x)));
                        } else {
                            throw new MatchError((Object)option);
                        }
                        return object;
                    });
                    return object;
                }
                {
                    this.logger$1 = logger$1;
                    this.evidence$1$1 = evidence$1$1;
                    this.engine$1 = engine$1;
                    this.writeSemaphore$1 = writeSemaphore$1;
                    this.wrapBuffer$1 = wrapBuffer$1;
                    this.handshakeSemaphore$1 = handshakeSemaphore$1;
                    this.binding$1 = binding$1;
                    this.readSemaphore$1 = readSemaphore$1;
                    this.unwrapBuffer$1 = unwrapBuffer$1;
                    this.sslEngineTaskRunner$1 = sslEngineTaskRunner$1;
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applicationProtocol$1(fs2.io.tls.TLSEngine$$anon$1 ), $anonfun$beginHandshake$1(fs2.io.tls.TLSEngine$$anon$1 ), $anonfun$dequeueUnwrap$1(fs2.Chunk ), $anonfun$doWrite$1(fs2.io.tls.TLSEngine$$anon$1 scala.Option fs2.Chunk ), $anonfun$initialHandshakeDone$1(fs2.io.tls.TLSEngine$$anon$1 ), $anonfun$log$1(java.lang.String scala.Function1 ), $anonfun$log$2(fs2.io.tls.TLSEngine$$anon$1 ), $anonfun$read0$1(fs2.io.tls.TLSEngine$$anon$1 int scala.Option scala.Option ), $anonfun$read0$2(fs2.io.tls.TLSEngine$$anon$1 int scala.Option ), $anonfun$read0$3(fs2.io.tls.TLSEngine$$anon$1 int scala.Option ), $anonfun$read0$4(fs2.io.tls.TLSEngine$$anon$1 int scala.Option ), $anonfun$read0$5(fs2.io.tls.TLSEngine$$anon$1 int scala.Option scala.Option ), $anonfun$read1$1(fs2.io.tls.TLSEngine$$anon$1 int scala.Option scala.Option ), $anonfun$read1$2(fs2.io.tls.TLSEngine$$anon$1 int scala.Option ), $anonfun$read1$3(fs2.io.tls.TLSEngine$$anon$1 int scala.Option scala.Option ), $anonfun$session$1(fs2.io.tls.TLSEngine$$anon$1 ), $anonfun$stepHandshake$1$adapted(fs2.io.tls.TLSEngine$$anon$1 scala.Option java.lang.Object ), $anonfun$stepHandshake$2(fs2.io.tls.TLSEngine$$anon$1 boolean scala.Option ), $anonfun$stepHandshake$3$adapted(fs2.io.tls.TLSEngine$$anon$1 javax.net.ssl.SSLEngineResult scala.Option java.lang.Object ), $anonfun$stepHandshake$4(fs2.io.tls.TLSEngine$$anon$1 scala.Option scala.Option ), $anonfun$stepHandshake$5(fs2.io.tls.TLSEngine$$anon$1 scala.Option ), $anonfun$stepHandshake$6$adapted(fs2.io.tls.TLSEngine$$anon$1 java.lang.Object ), $anonfun$stopUnwrap$1(fs2.io.tls.TLSEngine$$anon$1 ), $anonfun$stopWrap$1(fs2.io.tls.TLSEngine$$anon$1 ), $anonfun$unwrap$1(fs2.io.tls.TLSEngine$$anon$1 java.nio.ByteBuffer java.nio.ByteBuffer ), $anonfun$unwrap$10(fs2.io.tls.TLSEngine$$anon$1 int ), $anonfun$unwrap$2(fs2.io.tls.TLSEngine$$anon$1 javax.net.ssl.SSLEngineResult ), $anonfun$unwrap$3(fs2.io.tls.TLSEngine$$anon$1 int scala.Option javax.net.ssl.SSLEngineResult ), $anonfun$unwrap$4(javax.net.ssl.SSLEngineResult int ), $anonfun$unwrap$5(fs2.io.tls.TLSEngine$$anon$1 int scala.Option ), $anonfun$unwrap$6(fs2.io.tls.TLSEngine$$anon$1 int ), $anonfun$unwrap$7(fs2.io.tls.TLSEngine$$anon$1 int scala.Option ), $anonfun$unwrap$8(fs2.io.tls.TLSEngine$$anon$1 int scala.Option ), $anonfun$unwrap$9(fs2.io.tls.TLSEngine$$anon$1 ), $anonfun$unwrapHandshake$1(fs2.io.tls.TLSEngine$$anon$1 java.nio.ByteBuffer java.nio.ByteBuffer ), $anonfun$unwrapHandshake$2(fs2.io.tls.TLSEngine$$anon$1 javax.net.ssl.SSLEngineResult ), $anonfun$unwrapHandshake$3(fs2.io.tls.TLSEngine$$anon$1 scala.Option javax.net.ssl.SSLEngineResult ), $anonfun$unwrapHandshake$4(fs2.io.tls.TLSEngine$$anon$1 scala.Option ), $anonfun$unwrapHandshake$5(fs2.io.tls.TLSEngine$$anon$1 ), $anonfun$wrap$1(fs2.io.tls.TLSEngine$$anon$1 java.nio.ByteBuffer java.nio.ByteBuffer ), $anonfun$wrap$2(fs2.io.tls.TLSEngine$$anon$1 javax.net.ssl.SSLEngineResult ), $anonfun$wrap$3(fs2.io.tls.TLSEngine$$anon$1 scala.Option javax.net.ssl.SSLEngineResult ), $anonfun$wrap$4(fs2.io.tls.TLSEngine$$anon$1 javax.net.ssl.SSLEngineResult scala.Option ), $anonfun$wrap$5$adapted(fs2.io.tls.TLSEngine$$anon$1 scala.Option javax.net.ssl.SSLEngineResult java.lang.Object ), $anonfun$wrap$6(fs2.io.tls.TLSEngine$$anon$1 scala.Option ), $anonfun$wrap$7(fs2.io.tls.TLSEngine$$anon$1 scala.Option ), $anonfun$wrapHandshake$1(fs2.io.tls.TLSEngine$$anon$1 java.nio.ByteBuffer java.nio.ByteBuffer ), $anonfun$wrapHandshake$2(fs2.io.tls.TLSEngine$$anon$1 javax.net.ssl.SSLEngineResult ), $anonfun$wrapHandshake$3(fs2.io.tls.TLSEngine$$anon$1 scala.Option javax.net.ssl.SSLEngineResult ), $anonfun$wrapHandshake$4(fs2.io.tls.TLSEngine$$anon$1 javax.net.ssl.SSLEngineResult scala.Option ), $anonfun$wrapHandshake$5(fs2.io.tls.TLSEngine$$anon$1 scala.Option ), $anonfun$wrapHandshake$6(fs2.io.tls.TLSEngine$$anon$1 ), $anonfun$write0$1(fs2.io.tls.TLSEngine$$anon$1 scala.Option )}, serializedLambda);
                }
            };
        })))));
    }

    public <F> None$ apply$default$4() {
        return None$.MODULE$;
    }

    private TLSEngine$() {
    }
}

