/*
 * Decompiled with CFR 0.152.
 */
package net.shrine.messagequeuemiddleware;

import cats.effect.ContextShift;
import cats.effect.IO;
import cats.effect.IO$;
import com.typesafe.config.Config;
import fs2.Stream$;
import fs2.internal.FreeC;
import java.io.Serializable;
import java.util.List;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import net.shrine.config.ConfigSource$;
import net.shrine.crypto.SecureRandomSource$;
import net.shrine.http4s.catsio.ExecutionContexts$;
import net.shrine.log.Log$;
import net.shrine.messagequeuemiddleware.DeliveryAttempt;
import net.shrine.messagequeuemiddleware.InternalMessage;
import net.shrine.messagequeuemiddleware.LocalMessageQueueMiddleware;
import net.shrine.messagequeuemiddleware.LocalMessageQueueMiddleware$MessageScheduler$;
import net.shrine.messagequeuemiddleware.MessageDoesNotExistAndCannotBeCompletedException;
import net.shrine.messagequeuemiddleware.QueueDoesNotExistException;
import net.shrine.messagequeueservice.DeliveryAttemptId;
import net.shrine.messagequeueservice.DeliveryAttemptId$;
import net.shrine.messagequeueservice.Message;
import net.shrine.messagequeueservice.MessageQueueService;
import net.shrine.messagequeueservice.Queue;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Tuple2;
import scala.UninitializedFieldError;
import scala.collection.IterableOnceOps;
import scala.collection.StringOps$;
import scala.collection.concurrent.Map;
import scala.collection.concurrent.TrieMap;
import scala.collection.concurrent.TrieMap$;
import scala.collection.immutable.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.concurrent.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

public final class LocalMessageQueueMiddleware$
implements MessageQueueService {
    public static final LocalMessageQueueMiddleware$ MODULE$ = new LocalMessageQueueMiddleware$();
    private static final String configPath = "shrine.hub.messagequeue.blockingq";
    private static final TrieMap<DeliveryAttemptId, Tuple2<DeliveryAttempt, Option<ScheduledFuture<?>>>> net$shrine$messagequeuemiddleware$LocalMessageQueueMiddleware$$messageDeliveryAttemptMap;
    private static final TrieMap<Object, ScheduledFuture<?>> net$shrine$messagequeuemiddleware$LocalMessageQueueMiddleware$$messageIdsToExpirationCleanupTasks;
    private static final Map<String, BlockingDeque<InternalMessage>> blockingQueuePool;
    private static final ContextShift<IO> logActionContextShift;
    private static volatile int bitmap$init$0;

    static {
        bitmap$init$0 |= 1;
        net$shrine$messagequeuemiddleware$LocalMessageQueueMiddleware$$messageDeliveryAttemptMap = TrieMap$.MODULE$.empty();
        bitmap$init$0 |= 2;
        net$shrine$messagequeuemiddleware$LocalMessageQueueMiddleware$$messageIdsToExpirationCleanupTasks = TrieMap$.MODULE$.empty();
        bitmap$init$0 |= 4;
        blockingQueuePool = TrieMap$.MODULE$.empty();
        bitmap$init$0 |= 8;
        logActionContextShift = IO$.MODULE$.contextShift((ExecutionContext)ExecutionContexts$.MODULE$.longActionExecutionContext());
        bitmap$init$0 |= 0x10;
    }

    public String configPath() {
        if ((bitmap$init$0 & 1) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /var/opt/bamboo/bamboo-home/local-working-dir/SHRINE-TRUNK695-JOB1/hub/message-service/src/main/scala/net/shrine/messagequeuemiddleware/LocalMessageQueueMiddleware.scala: 31");
        }
        return configPath;
    }

    private Config config() {
        return ConfigSource$.MODULE$.config().getConfig(this.configPath());
    }

    public long net$shrine$messagequeuemiddleware$LocalMessageQueueMiddleware$$messageTimeToLiveInMillis() {
        return ((Duration)net.shrine.config.package$.MODULE$.ConfigExtensions(this.config()).get("messageTimeToLive", (Function1 & Serializable)x$1 -> Duration$.MODULE$.apply(x$1))).toMillis();
    }

    private long messageRedeliveryDelay() {
        return ((Duration)net.shrine.config.package$.MODULE$.ConfigExtensions(this.config()).get("messageRedeliveryDelay", (Function1 & Serializable)x$2 -> Duration$.MODULE$.apply(x$2))).toMillis();
    }

    private int messageMaxDeliveryAttempts() {
        return this.config().getInt("messageMaxDeliveryAttempts");
    }

    public TrieMap<DeliveryAttemptId, Tuple2<DeliveryAttempt, Option<ScheduledFuture<?>>>> net$shrine$messagequeuemiddleware$LocalMessageQueueMiddleware$$messageDeliveryAttemptMap() {
        if ((bitmap$init$0 & 2) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /var/opt/bamboo/bamboo-home/local-working-dir/SHRINE-TRUNK695-JOB1/hub/message-service/src/main/scala/net/shrine/messagequeuemiddleware/LocalMessageQueueMiddleware.scala: 42");
        }
        return net$shrine$messagequeuemiddleware$LocalMessageQueueMiddleware$$messageDeliveryAttemptMap;
    }

    public TrieMap<Object, ScheduledFuture<?>> net$shrine$messagequeuemiddleware$LocalMessageQueueMiddleware$$messageIdsToExpirationCleanupTasks() {
        if ((bitmap$init$0 & 4) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /var/opt/bamboo/bamboo-home/local-working-dir/SHRINE-TRUNK695-JOB1/hub/message-service/src/main/scala/net/shrine/messagequeuemiddleware/LocalMessageQueueMiddleware.scala: 45");
        }
        return net$shrine$messagequeuemiddleware$LocalMessageQueueMiddleware$$messageIdsToExpirationCleanupTasks;
    }

    public List<Runnable> stop() {
        return LocalMessageQueueMiddleware$MessageScheduler$.MODULE$.shutDown();
    }

    public Map<String, BlockingDeque<InternalMessage>> blockingQueuePool() {
        if ((bitmap$init$0 & 8) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /var/opt/bamboo/bamboo-home/local-working-dir/SHRINE-TRUNK695-JOB1/hub/message-service/src/main/scala/net/shrine/messagequeuemiddleware/LocalMessageQueueMiddleware.scala: 56");
        }
        return blockingQueuePool;
    }

    @Override
    public IO<Queue> createQueueIfAbsentIO(String queueName) {
        return IO$.MODULE$.apply((Function0 & Serializable)() -> {
            void var1_1;
            Queue proposedQueue = new Queue(queueName);
            MODULE$.blockingQueuePool().getOrElseUpdate((Object)proposedQueue.name(), (Function0 & Serializable)() -> new LinkedBlockingDeque());
            return var1_1;
        });
    }

    @Override
    public IO<Queue> getQueueIO(String queueName) {
        return IO$.MODULE$.apply((Function0 & Serializable)() -> {
            void var1_1;
            Queue proposedQueue = new Queue(queueName);
            MODULE$.blockingQueuePool().getOrElse((Object)proposedQueue.name(), (Function0 & Serializable)() -> {
                throw new QueueDoesNotExistException(new Queue(queueName));
            });
            return var1_1;
        });
    }

    @Override
    public IO<BoxedUnit> deleteQueueIO(String queueName) {
        return IO$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> MODULE$.blockingQueuePool().remove((Object)queueName).getOrElse((Function0 & Serializable)() -> {
            throw new QueueDoesNotExistException(new Queue(queueName));
        }));
    }

    @Override
    public IO<Seq<Queue>> queuesIO() {
        return IO$.MODULE$.apply((Function0 & Serializable)() -> ((IterableOnceOps)MODULE$.blockingQueuePool().keys().map((Function1 & Serializable)name -> new Queue((String)name))).toSeq());
    }

    @Override
    public IO<BoxedUnit> sendIO(String contents, Queue to) {
        return IO$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> {
            BlockingDeque queue = (BlockingDeque)MODULE$.blockingQueuePool().getOrElse((Object)to.name(), (Function0 & Serializable)() -> {
                throw new QueueDoesNotExistException(to);
            });
            long msgID = SecureRandomSource$.MODULE$.nextId();
            InternalMessage internalMessage = new InternalMessage(msgID, contents, System.currentTimeMillis(), to, MODULE$.messageMaxDeliveryAttempts());
            LocalMessageQueueMiddleware$MessageScheduler$.MODULE$.scheduleExpiredMessageCleanup(to, internalMessage);
            package$.MODULE$.blocking((Function0)(JFunction0.mcV.sp & Serializable)() -> queue.putLast(internalMessage));
            Log$.MODULE$.debug((Function0 & Serializable)() -> new StringBuilder(49).append("After send to ").append(to.name()).append(" - blockingQueue contains ").append(queue.size()).append(" messages").toString());
        });
    }

    private ContextShift<IO> logActionContextShift() {
        if ((bitmap$init$0 & 0x10) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /var/opt/bamboo/bamboo-home/local-working-dir/SHRINE-TRUNK695-JOB1/hub/message-service/src/main/scala/net/shrine/messagequeuemiddleware/LocalMessageQueueMiddleware.scala: 95");
        }
        return logActionContextShift;
    }

    @Override
    public IO<Option<Message>> receiveIO(Queue from, Duration timeout) {
        long deadline = System.currentTimeMillis() + timeout.toMillis();
        BlockingDeque blockingQueue = (BlockingDeque)this.blockingQueuePool().getOrElse((Object)from.name(), (Function0 & Serializable)() -> {
            throw new QueueDoesNotExistException(from);
        });
        return IO$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> Log$.MODULE$.debug((Function0 & Serializable)() -> new StringBuilder(55).append("Before receive from ").append(from.name()).append(" - blockingQueue contains ").append(blockingQueue.size()).append(" messages").toString())).flatMap((Function1 & Serializable)x$3 -> (IO)MODULE$.logActionContextShift().evalOn((ExecutionContext)ExecutionContexts$.MODULE$.longActionExecutionContext(), (Object)IO$.MODULE$.apply((Function0 & Serializable)() -> (Option)package$.MODULE$.blocking((Function0 & Serializable)() -> Option$.MODULE$.apply(package$.MODULE$.blocking((Function0 & Serializable)() -> (InternalMessage)blockingQueue.pollFirst(deadline - System.currentTimeMillis(), TimeUnit.MILLISECONDS))))))).map((Function1 & Serializable)internalMessageOpt -> {
            block0: {
                if (!internalMessageOpt.isEmpty()) break block0;
                Log$.MODULE$.debug((Function0 & Serializable)() -> new StringBuilder(39).append("No message available from queue ").append(from.name()).append(" after ").append(timeout).toString());
            }
            return internalMessageOpt.map((Function1 & Serializable)x$4 -> MODULE$.toMessage(from, (InternalMessage)x$4));
        });
    }

    @Override
    public FreeC<IO, Message, BoxedUnit> receiveStream(Queue from) {
        Log$.MODULE$.debug((Function0 & Serializable)() -> new StringBuilder(27).append("Starting stream from queue ").append(from.name()).toString());
        BlockingDeque blockingQueue = (BlockingDeque)this.blockingQueuePool().getOrElse((Object)from.name(), (Function0 & Serializable)() -> {
            throw new QueueDoesNotExistException(from);
        });
        return Stream$.MODULE$.repeatEval((Object)((IO)this.logActionContextShift().evalOn((ExecutionContext)ExecutionContexts$.MODULE$.longActionExecutionContext(), (Object)IO$.MODULE$.apply((Function0 & Serializable)() -> (InternalMessage)package$.MODULE$.blocking((Function0 & Serializable)() -> (InternalMessage)blockingQueue.takeFirst())))).map((Function1 & Serializable)x$5 -> MODULE$.toMessage(from, (InternalMessage)x$5)));
    }

    public Message toMessage(Queue from, InternalMessage internalMessage) {
        long deliveryAttemptID = DeliveryAttemptId$.MODULE$.create();
        DeliveryAttempt deliveryAttempt = new DeliveryAttempt(internalMessage, internalMessage.createdTime(), from);
        LocalMessageQueueMiddleware$MessageScheduler$.MODULE$.scheduleMessageRedelivery(deliveryAttemptID, deliveryAttempt, this.messageRedeliveryDelay(), this.messageMaxDeliveryAttempts());
        LocalMessageQueueMiddleware.LocalMessage localMessage = new LocalMessageQueueMiddleware.LocalMessage(deliveryAttemptID, this.messageRedeliveryDelay(), internalMessage.remainingAttempts(), internalMessage.contents());
        Log$.MODULE$.debug((Function0 & Serializable)() -> new StringBuilder(25).append(StringOps$.MODULE$.take$extension(Predef$.MODULE$.augmentString(deliveryAttempt.toString()), 70)).append(" scheduled to expire for ").append(StringOps$.MODULE$.take$extension(Predef$.MODULE$.augmentString(localMessage.toString()), 70)).toString());
        return localMessage;
    }

    public IO<BoxedUnit> completeMessage(long deliveryAttemptId) {
        return IO$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> {
            Option deliveryAttemptAndFutureTaskOpt = MODULE$.net$shrine$messagequeuemiddleware$LocalMessageQueueMiddleware$$messageDeliveryAttemptMap().get((Object)new DeliveryAttemptId(deliveryAttemptId));
            deliveryAttemptAndFutureTaskOpt.fold((Function0 & Serializable)() -> {
                throw new MessageDoesNotExistAndCannotBeCompletedException(deliveryAttemptId);
            }, (Function1 & Serializable)deliveryAttemptAndFutureTask -> {
                LocalMessageQueueMiddleware$.$anonfun$completeMessage$3(deliveryAttemptAndFutureTask);
                return BoxedUnit.UNIT;
            });
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$completeMessage$4(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        if (tuple2 == null) return false;
        long id = ((DeliveryAttemptId)tuple2._1()).underlying();
        Tuple2 eachDAandTask = (Tuple2)tuple2._2();
        if (!(new DeliveryAttemptId(id) instanceof DeliveryAttemptId)) return false;
        if (!(eachDAandTask instanceof Tuple2)) return false;
        return true;
    }

    public static final /* synthetic */ void $anonfun$completeMessage$3(Tuple2 deliveryAttemptAndFutureTask) {
        DeliveryAttempt deliveryAttempt = (DeliveryAttempt)deliveryAttemptAndFutureTask._1();
        InternalMessage internalToBeSentMessage = deliveryAttempt.message();
        Queue queue = internalToBeSentMessage.toQueue();
        MODULE$.net$shrine$messagequeuemiddleware$LocalMessageQueueMiddleware$$messageDeliveryAttemptMap().withFilter((Function1 & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)LocalMessageQueueMiddleware$.$anonfun$completeMessage$4(check$ifrefutable$1))).foreach((Function1 & Serializable)x$6 -> {
            BoxedUnit boxedUnit;
            Tuple2 tuple2 = x$6;
            if (tuple2 == null) throw new MatchError((Object)tuple2);
            long id = ((DeliveryAttemptId)tuple2._1()).underlying();
            Tuple2 eachDAandTask = (Tuple2)tuple2._2();
            if (!(new DeliveryAttemptId(id) instanceof DeliveryAttemptId)) throw new MatchError((Object)tuple2);
            long l = id;
            if (!(eachDAandTask instanceof Tuple2)) throw new MatchError((Object)tuple2);
            Tuple2 tuple22 = eachDAandTask;
            if (((DeliveryAttempt)tuple22._1()).message().id() == internalToBeSentMessage.id()) {
                MODULE$.net$shrine$messagequeuemiddleware$LocalMessageQueueMiddleware$$messageDeliveryAttemptMap().remove((Object)new DeliveryAttemptId(l));
                LocalMessageQueueMiddleware$MessageScheduler$.MODULE$.cancelScheduledMessageRedelivery((Option)tuple22._2());
                boxedUnit = MODULE$.net$shrine$messagequeuemiddleware$LocalMessageQueueMiddleware$$messageIdsToExpirationCleanupTasks().remove((Object)BoxesRunTime.boxToLong((long)internalToBeSentMessage.id())).map((Function1 & Serializable)futureTask -> {
                    LocalMessageQueueMiddleware$MessageScheduler$.MODULE$.cancelExpiredMessageCleanup(futureTask);
                    return BoxedUnit.UNIT;
                });
                return boxedUnit;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return boxedUnit;
        });
        BlockingDeque blockingQueue = (BlockingDeque)MODULE$.blockingQueuePool().getOrElse((Object)queue.name(), (Function0 & Serializable)() -> {
            throw new QueueDoesNotExistException(queue);
        });
        blockingQueue.remove(internalToBeSentMessage);
        Log$.MODULE$.debug((Function0 & Serializable)() -> new StringBuilder(23).append("Message from ").append(((DeliveryAttempt)deliveryAttemptAndFutureTask._1()).fromQueue()).append(" completed").toString());
    }

    private LocalMessageQueueMiddleware$() {
    }
}

