/*
 * Decompiled with CFR 0.152.
 */
package org.http4s;

import cats.ApplicativeError;
import cats.Foldable;
import cats.Functor;
import cats.Invariant$;
import cats.Monad;
import cats.Semigroupal$;
import cats.UnorderedFoldable$;
import cats.data.OptionT;
import cats.data.OptionT$;
import cats.effect.Blocker$;
import cats.effect.ContextShift;
import cats.effect.IO;
import cats.effect.IO$;
import cats.effect.Sync;
import cats.effect.Sync$;
import cats.kernel.Semigroup;
import cats.kernel.Semigroup$;
import cats.syntax.ApplicativeErrorOps$;
import cats.syntax.EitherOps$;
import cats.syntax.package;
import fs2.Stream;
import fs2.Stream$;
import fs2.internal.FreeC;
import fs2.io.package$;
import io.chrisdavenport.vault.Key;
import io.chrisdavenport.vault.Key$;
import io.chrisdavenport.vault.Vault;
import io.chrisdavenport.vault.Vault$;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.Serializable;
import java.net.URL;
import java.net.URLConnection;
import org.http4s.ContentCoding$;
import org.http4s.Header;
import org.http4s.Headers$;
import org.http4s.HttpDate;
import org.http4s.HttpDate$;
import org.http4s.HttpVersion;
import org.http4s.MediaType;
import org.http4s.MediaType$;
import org.http4s.Request;
import org.http4s.Response;
import org.http4s.Response$;
import org.http4s.Status;
import org.http4s.Status$;
import org.http4s.TransferCoding$;
import org.http4s.headers.Accept$minusEncoding;
import org.http4s.headers.Accept$minusEncoding$;
import org.http4s.headers.Content$minusEncoding;
import org.http4s.headers.Content$minusLength;
import org.http4s.headers.Content$minusLength$;
import org.http4s.headers.Content$minusType;
import org.http4s.headers.Content$minusType$;
import org.http4s.headers.ETag;
import org.http4s.headers.ETag$;
import org.http4s.headers.If$minusModified$minusSince;
import org.http4s.headers.If$minusModified$minusSince$;
import org.http4s.headers.If$minusNone$minusMatch;
import org.http4s.headers.If$minusNone$minusMatch$;
import org.http4s.headers.Last$minusModified;
import org.http4s.headers.Transfer$minusEncoding$;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.concurrent.ExecutionContext;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

public final class StaticFile$ {
    public static final StaticFile$ MODULE$ = new StaticFile$();
    private static final Logger logger = LoggerFactory.getLogger((String)"org.http4s.StaticFile");
    private static final int DefaultBufferSize = 10240;
    private static final Key<File> staticFileKey = (Key)((IO)Key$.MODULE$.newKey((Sync)IO$.MODULE$.ioEffect())).unsafeRunSync();

    public int DefaultBufferSize() {
        return DefaultBufferSize;
    }

    public <F> OptionT<F, Response<F>> fromString(String url, ExecutionContext blocker, Option<Request<F>> req, Sync<F> evidence$1, ContextShift<F> evidence$2) {
        return this.fromFile(new File(url), blocker, req, evidence$1, evidence$2);
    }

    public <F> None$ fromString$default$3() {
        return None$.MODULE$;
    }

    public <F> OptionT<F, Response<F>> fromResource(String name, ExecutionContext blocker, Option<Request<F>> req, boolean preferGzipped, Option<ClassLoader> classloader, Sync<F> evidence$3, ContextShift<F> evidence$4) {
        ClassLoader loader = (ClassLoader)classloader.getOrElse((Function0 & Serializable)() -> MODULE$.getClass().getClassLoader());
        boolean tryGzipped = preferGzipped && req.flatMap((Function1 & Serializable)x$1 -> Headers$.MODULE$.get$extension((List<Header>)x$1.headers(), Accept$minusEncoding$.MODULE$)).exists((Function1 & Serializable)acceptEncoding -> BoxesRunTime.boxToBoolean((boolean)StaticFile$.$anonfun$fromResource$3(acceptEncoding)));
        String normalizedName = Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])name.split("/")), (Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(x$2))))).mkString("/");
        OptionT gzUrl = tryGzipped ? StaticFile$.getResource$1(new StringBuilder(3).append(normalizedName).append(".gz").toString(), evidence$3, loader) : OptionT$.MODULE$.none(evidence$3);
        return gzUrl.flatMap((Function1 & Serializable)url -> {
            Option<Content$minusType> contentType = MODULE$.nameToContentType(normalizedName);
            Content$minusEncoding content$minusEncoding = new Content$minusEncoding(ContentCoding$.MODULE$.gzip());
            List headers = contentType.toList().$colon$colon((Object)content$minusEncoding);
            return MODULE$.fromURL((URL)url, blocker, req, evidence$3, evidence$4).map((Function1 & Serializable)x$3 -> (Response)x$3.removeHeader(Content$minusType$.MODULE$).putHeaders((Seq<Header>)headers), (Functor)evidence$3);
        }, evidence$3).orElse((Function0 & Serializable)() -> StaticFile$.getResource$1(normalizedName, evidence$3, loader).flatMap((Function1 & Serializable)x$4 -> MODULE$.fromURL((URL)x$4, blocker, req, evidence$3, evidence$4), (Monad)evidence$3), evidence$3);
    }

    public <F> None$ fromResource$default$3() {
        return None$.MODULE$;
    }

    public <F> boolean fromResource$default$4() {
        return false;
    }

    public <F> Option<ClassLoader> fromResource$default$5() {
        return None$.MODULE$;
    }

    public <F> OptionT<F, Response<F>> fromURL(URL url, ExecutionContext blocker, Option<Request<F>> req, Sync<F> F, ContextShift<F> cs) {
        String fileUrl = url.getFile();
        File file = new File(fileUrl);
        return new OptionT(F.defer((Function0 & Serializable)() -> {
            Object object;
            if (file.isDirectory()) {
                object = F.pure((Object)None$.MODULE$);
            } else {
                URLConnection urlConn = url.openConnection();
                Option lastmod = HttpDate$.MODULE$.fromEpochSecond(urlConn.getLastModified() / 1000L).toOption();
                Option ifModifiedSince = req.flatMap((Function1 & Serializable)x$5 -> Headers$.MODULE$.get$extension((List<Header>)x$5.headers(), If$minusModified$minusSince$.MODULE$));
                boolean expired = BoxesRunTime.unboxToBoolean((Object)((Option)package.all$.MODULE$.catsSyntaxTuple2Semigroupal(new Tuple2((Object)ifModifiedSince, (Object)lastmod)).mapN((Function2 & Serializable)(x$6, x$7) -> BoxesRunTime.boxToBoolean((boolean)StaticFile$.$anonfun$fromURL$3(x$6, x$7)), (Functor)Invariant$.MODULE$.catsInstancesForOption(), Semigroupal$.MODULE$.catsSemigroupalForOption())).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable)() -> true));
                if (expired) {
                    Content$minusLength lenHeader;
                    List lastModHeader = lastmod.map((Function1 & Serializable)x$8 -> new Last$minusModified((HttpDate)x$8)).toList();
                    List contentType = MODULE$.nameToContentType(url.getPath()).toList();
                    long len = urlConn.getContentLengthLong();
                    Content$minusLength content$minusLength = lenHeader = len >= 0L ? Content$minusLength$.MODULE$.unsafeFromLong(len) : Transfer$minusEncoding$.MODULE$.apply(TransferCoding$.MODULE$.chunked(), (Seq<Object>)Nil$.MODULE$);
                    List list = lastModHeader;
                    List<Header> headers = Headers$.MODULE$.apply((List<Header>)contentType.$colon$colon$colon(list).$colon$colon((Object)content$minusLength));
                    object = ApplicativeErrorOps$.MODULE$.redeem$extension(package.all$.MODULE$.catsSyntaxApplicativeError(Blocker$.MODULE$.delay$extension(blocker, (Function0 & Serializable)() -> urlConn.getInputStream(), F, cs), (ApplicativeError)F), (Function1 & Serializable)x0$1 -> {
                        Throwable throwable = x0$1;
                        if (!(throwable instanceof FileNotFoundException)) {
                            throw throwable;
                        }
                        None$ none$ = None$.MODULE$;
                        return none$;
                    }, (Function1 & Serializable)inputStream -> {
                        List x$1 = headers;
                        FreeC x$2 = package$.MODULE$.readInputStream(F.pure(inputStream), MODULE$.DefaultBufferSize(), blocker, package$.MODULE$.readInputStream$default$4(), F, cs);
                        Status x$3 = Response$.MODULE$.apply$default$1();
                        HttpVersion x$4 = Response$.MODULE$.apply$default$2();
                        Vault x$5 = Response$.MODULE$.apply$default$5();
                        return new Some(new Response(x$3, x$4, (List<Header>)x$1, x$2, x$5));
                    }, (ApplicativeError)F);
                } else {
                    object = package.all$.MODULE$.toFunctorOps(ApplicativeErrorOps$.MODULE$.handleError$extension(package.all$.MODULE$.catsSyntaxApplicativeError(Blocker$.MODULE$.delay$extension(blocker, (Function0)(JFunction0.mcV.sp & Serializable)() -> urlConn.getInputStream().close(), F, cs), (ApplicativeError)F), (Function1 & Serializable)x$9 -> {
                        StaticFile$.$anonfun$fromURL$10(x$9);
                        return BoxedUnit.UNIT;
                    }, (ApplicativeError)F), (Functor)F).as((Object)new Some(new Response<Nothing$>(Status$.MODULE$.NotModified(), Response$.MODULE$.apply$default$2(), Response$.MODULE$.apply$default$3(), Response$.MODULE$.apply$default$4(), Response$.MODULE$.apply$default$5())));
                }
            }
            return object;
        }));
    }

    public <F> None$ fromURL$default$3() {
        return None$.MODULE$;
    }

    public <F> Function1<File, F> calcETag(Sync<F> evidence$5) {
        return (Function1 & Serializable)f -> Sync$.MODULE$.apply(evidence$5).delay((Function0 & Serializable)() -> f.isFile() ? new StringBuilder(1).append(RichLong$.MODULE$.toHexString$extension(Predef$.MODULE$.longWrapper(f.lastModified()))).append("-").append(RichLong$.MODULE$.toHexString$extension(Predef$.MODULE$.longWrapper(f.length()))).toString() : "");
    }

    public <F> OptionT<F, Response<F>> fromFile(File f, ExecutionContext blocker, Option<Request<F>> req, Sync<F> evidence$6, ContextShift<F> evidence$7) {
        return this.fromFile(f, this.DefaultBufferSize(), blocker, req, this.calcETag(evidence$6), evidence$6, evidence$7);
    }

    public <F> OptionT<F, Response<F>> fromFile(File f, ExecutionContext blocker, Option<Request<F>> req, Function1<File, F> etagCalculator, Sync<F> evidence$8, ContextShift<F> evidence$9) {
        return this.fromFile(f, this.DefaultBufferSize(), blocker, req, etagCalculator, evidence$8, evidence$9);
    }

    public <F> OptionT<F, Response<F>> fromFile(File f, int buffsize, ExecutionContext blocker, Option<Request<F>> req, Function1<File, F> etagCalculator, Sync<F> evidence$10, ContextShift<F> evidence$11) {
        return this.fromFile(f, 0L, f.length(), buffsize, blocker, req, etagCalculator, evidence$10, evidence$11);
    }

    public <F> OptionT<F, Response<F>> fromFile(File f, long start, long end, int buffsize, ExecutionContext blocker, Option<Request<F>> req, Function1<File, F> etagCalculator, Sync<F> F, ContextShift<F> cs) {
        return new OptionT(package.all$.MODULE$.toFlatMapOps(package.all$.MODULE$.toFunctorOps(etagCalculator.apply((Object)f), F).map((Function1 & Serializable)et -> ETag$.MODULE$.apply((String)et, ETag$.MODULE$.apply$default$2())), F).flatMap((Function1 & Serializable)etagCalc -> F.delay((Function0 & Serializable)() -> {
            None$ none$;
            if (f.isFile()) {
                Predef$.MODULE$.require(start >= 0L && end >= start && buffsize > 0, (Function0 & Serializable)() -> new StringBuilder(26).append("start: ").append(start).append(", end: ").append(end).append(", buffsize: ").append(buffsize).toString());
                Option lastModified = HttpDate$.MODULE$.fromEpochSecond(f.lastModified() / 1000L).toOption();
                none$ = MODULE$.notModified(req, (ETag)etagCalc, (Option<HttpDate>)lastModified).orElse((Function0 & Serializable)() -> {
                    Tuple2 tuple2;
                    Tuple2 tuple22 = tuple2 = f.length() < end ? new Tuple2((Object)new Stream(Stream.PureOps$.MODULE$.covary$extension(Stream$.MODULE$.PureOps(Stream$.MODULE$.empty()))), (Object)BoxesRunTime.boxToLong((long)0L)) : new Tuple2((Object)new Stream(MODULE$.fileToBody(f, start, end, blocker, F, cs)), (Object)BoxesRunTime.boxToLong((long)(end - start)));
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    FreeC body = ((Stream)tuple2._1()).fs2$Stream$$free();
                    long contentLength = tuple2._2$mcJ$sp();
                    Tuple2 tuple23 = new Tuple2((Object)new Stream(body), (Object)BoxesRunTime.boxToLong((long)contentLength));
                    Tuple2 tuple24 = tuple23;
                    FreeC body2 = ((Stream)tuple24._1()).fs2$Stream$$free();
                    long contentLength2 = tuple24._2$mcJ$sp();
                    Option<Content$minusType> contentType = MODULE$.nameToContentType(f.getName());
                    List list = lastModified.map((Function1 & Serializable)lm -> new Last$minusModified((HttpDate)lm)).toList();
                    List list2 = EitherOps$.MODULE$.toList$extension(package.all$.MODULE$.catsSyntaxEither(Content$minusLength$.MODULE$.fromLong(contentLength2)));
                    List list3 = contentType.toList();
                    List hs = ((List)scala.package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ETag[]{etagCalc}))).$colon$colon$colon(list3).$colon$colon$colon(list2).$colon$colon$colon(list);
                    List<Header> x$1 = Headers$.MODULE$.apply((List<Header>)hs);
                    FreeC x$2 = body2;
                    Vault x$3 = Vault$.MODULE$.empty().insert(MODULE$.staticFileKey(), (Object)f);
                    Status x$4 = Response$.MODULE$.apply$default$1();
                    HttpVersion x$5 = Response$.MODULE$.apply$default$2();
                    Response r = new Response(x$4, x$5, x$1, x$2, x$3);
                    if (logger.isTraceEnabled()) {
                        logger.trace(new StringBuilder(32).append("Static file generated response: ").append(r).toString());
                    }
                    return new Some(r);
                });
            } else {
                none$ = None$.MODULE$;
            }
            return none$;
        })));
    }

    public <F> None$ fromFile$default$3() {
        return None$.MODULE$;
    }

    private <F> Option<Response<F>> notModified(Option<Request<F>> req, ETag etagCalc, Option<HttpDate> lastModified) {
        Semigroup<Object> conjunction = new Semigroup<Object>(){

            public double combine$mcD$sp(double x, double y) {
                return Semigroup.combine$mcD$sp$((Semigroup)this, (double)x, (double)y);
            }

            public float combine$mcF$sp(float x, float y) {
                return Semigroup.combine$mcF$sp$((Semigroup)this, (float)x, (float)y);
            }

            public int combine$mcI$sp(int x, int y) {
                return Semigroup.combine$mcI$sp$((Semigroup)this, (int)x, (int)y);
            }

            public long combine$mcJ$sp(long x, long y) {
                return Semigroup.combine$mcJ$sp$((Semigroup)this, (long)x, (long)y);
            }

            public Object combineN(Object a, int n) {
                return Semigroup.combineN$((Semigroup)this, (Object)a, (int)n);
            }

            public double combineN$mcD$sp(double a, int n) {
                return Semigroup.combineN$mcD$sp$((Semigroup)this, (double)a, (int)n);
            }

            public float combineN$mcF$sp(float a, int n) {
                return Semigroup.combineN$mcF$sp$((Semigroup)this, (float)a, (int)n);
            }

            public int combineN$mcI$sp(int a, int n) {
                return Semigroup.combineN$mcI$sp$((Semigroup)this, (int)a, (int)n);
            }

            public long combineN$mcJ$sp(long a, int n) {
                return Semigroup.combineN$mcJ$sp$((Semigroup)this, (long)a, (int)n);
            }

            public Object repeatedCombineN(Object a, int n) {
                return Semigroup.repeatedCombineN$((Semigroup)this, (Object)a, (int)n);
            }

            public double repeatedCombineN$mcD$sp(double a, int n) {
                return Semigroup.repeatedCombineN$mcD$sp$((Semigroup)this, (double)a, (int)n);
            }

            public float repeatedCombineN$mcF$sp(float a, int n) {
                return Semigroup.repeatedCombineN$mcF$sp$((Semigroup)this, (float)a, (int)n);
            }

            public int repeatedCombineN$mcI$sp(int a, int n) {
                return Semigroup.repeatedCombineN$mcI$sp$((Semigroup)this, (int)a, (int)n);
            }

            public long repeatedCombineN$mcJ$sp(long a, int n) {
                return Semigroup.repeatedCombineN$mcJ$sp$((Semigroup)this, (long)a, (int)n);
            }

            public Option<Object> combineAllOption(IterableOnce<Object> as) {
                return Semigroup.combineAllOption$((Semigroup)this, as);
            }

            public Semigroup<Object> reverse() {
                return Semigroup.reverse$((Semigroup)this);
            }

            public Semigroup<Object> reverse$mcD$sp() {
                return Semigroup.reverse$mcD$sp$((Semigroup)this);
            }

            public Semigroup<Object> reverse$mcF$sp() {
                return Semigroup.reverse$mcF$sp$((Semigroup)this);
            }

            public Semigroup<Object> reverse$mcI$sp() {
                return Semigroup.reverse$mcI$sp$((Semigroup)this);
            }

            public Semigroup<Object> reverse$mcJ$sp() {
                return Semigroup.reverse$mcJ$sp$((Semigroup)this);
            }

            public Semigroup intercalate(Object middle) {
                return Semigroup.intercalate$((Semigroup)this, (Object)middle);
            }

            public Semigroup<Object> intercalate$mcD$sp(double middle) {
                return Semigroup.intercalate$mcD$sp$((Semigroup)this, (double)middle);
            }

            public Semigroup<Object> intercalate$mcF$sp(float middle) {
                return Semigroup.intercalate$mcF$sp$((Semigroup)this, (float)middle);
            }

            public Semigroup<Object> intercalate$mcI$sp(int middle) {
                return Semigroup.intercalate$mcI$sp$((Semigroup)this, (int)middle);
            }

            public Semigroup<Object> intercalate$mcJ$sp(long middle) {
                return Semigroup.intercalate$mcJ$sp$((Semigroup)this, (long)middle);
            }

            public boolean combine(boolean x, boolean y) {
                return x && y;
            }
            {
                Semigroup.$init$((Semigroup)this);
            }
        };
        return ((Option)package.all$.MODULE$.toFoldableOps(scala.package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Option[]{this.etagMatch(req, etagCalc), this.notModifiedSince(req, lastModified)})), (Foldable)UnorderedFoldable$.MODULE$.catsTraverseForList()).combineAll(Semigroup$.MODULE$.catsKernelMonoidForOption((Semigroup)conjunction))).filter((Function1 & Serializable)x -> BoxesRunTime.boxToBoolean((boolean)StaticFile$.$anonfun$notModified$1(BoxesRunTime.unboxToBoolean((Object)x)))).map((Function1 & Serializable)x$11 -> StaticFile$.$anonfun$notModified$2(BoxesRunTime.unboxToBoolean((Object)x$11)));
    }

    private <F> Option<Object> etagMatch(Option<Request<F>> req, ETag etagCalc) {
        return req.flatMap((Function1 & Serializable)r -> Headers$.MODULE$.get$extension((List<Header>)r.headers(), If$minusNone$minusMatch$.MODULE$).map((Function1 & Serializable)etagHeader -> BoxesRunTime.boxToBoolean((boolean)StaticFile$.$anonfun$etagMatch$2(etagCalc, etagHeader))));
    }

    private <F> Option<Object> notModifiedSince(Option<Request<F>> req, Option<HttpDate> lastModified) {
        return req.flatMap((Function1 & Serializable)r -> Headers$.MODULE$.get$extension((List<Header>)r.headers(), If$minusModified$minusSince$.MODULE$).flatMap((Function1 & Serializable)h -> lastModified.map((Function1 & Serializable)lm -> BoxesRunTime.boxToBoolean((boolean)StaticFile$.$anonfun$notModifiedSince$3(h, lm)))));
    }

    private <F> FreeC<F, Object, BoxedUnit> fileToBody(File f, long start, long end, ExecutionContext blocker, Sync<F> evidence$12, ContextShift<F> evidence$13) {
        return fs2.io.file.package$.MODULE$.readRange(f.toPath(), blocker, this.DefaultBufferSize(), start, end, evidence$12, evidence$13);
    }

    private Option<Content$minusType> nameToContentType(String name) {
        None$ none$;
        int n = name.lastIndexOf(46);
        switch (n) {
            case -1: {
                none$ = None$.MODULE$;
                break;
            }
            default: {
                none$ = MediaType$.MODULE$.forExtension(name.substring(n + 1)).map((Function1 & Serializable)x$18 -> Content$minusType$.MODULE$.apply((MediaType)x$18));
                break;
            }
        }
        return none$;
    }

    public Key<File> staticFileKey() {
        return staticFileKey;
    }

    public static final /* synthetic */ boolean $anonfun$fromResource$3(Accept$minusEncoding acceptEncoding) {
        return acceptEncoding.satisfiedBy(ContentCoding$.MODULE$.gzip()) || acceptEncoding.satisfiedBy(ContentCoding$.MODULE$.x$minusgzip());
    }

    private static final OptionT getResource$1(String name, Sync evidence$3$1, ClassLoader loader$1) {
        return new OptionT(Sync$.MODULE$.apply(evidence$3$1).delay((Function0 & Serializable)() -> Option$.MODULE$.apply((Object)loader$1.getResource(name))));
    }

    public static final /* synthetic */ boolean $anonfun$fromURL$3(If$minusModified$minusSince x$6, HttpDate x$7) {
        return x$6.date().$less(x$7);
    }

    public static final /* synthetic */ void $anonfun$fromURL$10(Throwable x$9) {
    }

    public static final /* synthetic */ boolean $anonfun$notModified$1(boolean x) {
        return BoxesRunTime.unboxToBoolean((Object)Predef$.MODULE$.identity((Object)BoxesRunTime.boxToBoolean((boolean)x)));
    }

    public static final /* synthetic */ Response $anonfun$notModified$2(boolean x$11) {
        return new Response<Nothing$>(Status$.MODULE$.NotModified(), Response$.MODULE$.apply$default$2(), Response$.MODULE$.apply$default$3(), Response$.MODULE$.apply$default$4(), Response$.MODULE$.apply$default$5());
    }

    public static final /* synthetic */ boolean $anonfun$etagMatch$4(ETag etagCalc$2, ETag.EntityTag x$13) {
        ETag.EntityTag entityTag = x$13;
        ETag.EntityTag entityTag2 = etagCalc$2.tag();
        return !(entityTag != null ? !((Object)entityTag).equals(entityTag2) : entityTag2 != null);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ boolean $anonfun$etagMatch$2(ETag etagCalc$2, If$minusNone$minusMatch etagHeader) {
        void var2_2;
        BoxedUnit boxedUnit;
        boolean etagMatch = etagHeader.tags().exists((Function1 & Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)x$12.exists((Function1 & Serializable)x$13 -> BoxesRunTime.boxToBoolean((boolean)StaticFile$.$anonfun$etagMatch$4(etagCalc$2, x$13)))));
        if (logger.isTraceEnabled()) {
            logger.trace(new StringBuilder(53).append("Matches `If-None-Match`: ").append(etagMatch).append(" Previous ETag: ").append(etagHeader.value()).append(", New ETag: ").append(etagCalc$2).toString());
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        BoxedUnit boxedUnit2 = boxedUnit;
        return (boolean)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ boolean $anonfun$notModifiedSince$3(If$minusModified$minusSince h$1, HttpDate lm) {
        void var2_2;
        BoxedUnit boxedUnit;
        boolean notModified = h$1.date().$greater$eq(lm);
        if (logger.isTraceEnabled()) {
            logger.trace(new StringBuilder(56).append("Matches `If-Modified-Since`: ").append(notModified).append(". Request age: ").append(h$1.date()).append(", Modified: ").append(lm).toString());
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        BoxedUnit boxedUnit2 = boxedUnit;
        return (boolean)var2_2;
    }

    private StaticFile$() {
    }
}

