/*
 * Decompiled with CFR 0.152.
 */
package org.spin.tools;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.UUID;
import org.spin.tools.IterableEnumeration;

public final class Util {
    private Util() {
    }

    public static final <T> IterableEnumeration<T> iterable(Enumeration<T> enumeration) {
        return IterableEnumeration.from(enumeration);
    }

    public static <T> ArrayList<T> makeArrayList() {
        return new ArrayList();
    }

    public static <T> ArrayList<T> makeArrayList(Collection<? extends T> collection) {
        if (collection == null) {
            return null;
        }
        return new ArrayList<T>(collection);
    }

    public static <T> ArrayList<T> makeArrayList(T ... values) {
        if (values == null) {
            return null;
        }
        return new ArrayList<T>(Arrays.asList(values));
    }

    public static <T> ArrayList<T> makeArrayList(int initialCapacity) {
        return new ArrayList(initialCapacity);
    }

    public static <T> LinkedList<T> makeLinkedList() {
        return new LinkedList();
    }

    public static <T> LinkedList<T> makeLinkedList(Collection<? extends T> collection) {
        if (collection == null) {
            return null;
        }
        return new LinkedList<T>(collection);
    }

    public static <K, V> HashMap<K, V> makeHashMap() {
        return new HashMap();
    }

    public static <K, V> HashMap<K, V> makeHashMap(Map<K, V> map) {
        return new HashMap<K, V>(map);
    }

    public static <K, V> TreeMap<K, V> makeTreeMap() {
        return new TreeMap();
    }

    public static <T> TreeSet<T> makeTreeSet() {
        return new TreeSet();
    }

    public static <T> HashSet<T> makeHashSet() {
        return new HashSet();
    }

    public static <K extends Enum<K>, V> EnumMap<K, V> makeEnumMap(Class<K> keyClass) {
        return new EnumMap(keyClass);
    }

    public static <T> Set<T> asSet(T ... values) {
        return Util.asSet(Arrays.asList(values));
    }

    public static <T> Set<T> asSet(Collection<? extends T> values) {
        return new HashSet<T>(values);
    }

    public static <T> T[] asArray(T ... values) {
        return values;
    }

    public static <T> List<T> asList(Set<T> values) {
        return Arrays.asList(values.toArray());
    }

    public static <T> List<T> asList(Iterator<T> values) {
        ArrayList<T> result = Util.makeArrayList();
        while (values.hasNext()) {
            result.add(values.next());
        }
        return result;
    }

    public static <T extends Comparable<T>> List<T> asSortedList(T ... values) {
        return Util.asSortedList(Arrays.asList(values));
    }

    public static <T extends Comparable<T>> List<T> asSortedList(Collection<? extends T> values) {
        ArrayList<? extends T> result = Util.makeArrayList(values);
        Collections.sort(result);
        return result;
    }

    public static <K, V> boolean mapsAreEqual(Map<K, V> lhs, Map<K, V> rhs) {
        if (lhs == null && rhs == null) {
            return true;
        }
        if (lhs == rhs) {
            return true;
        }
        if (lhs == null || rhs == null) {
            return false;
        }
        if (lhs.size() != rhs.size()) {
            return false;
        }
        if (!lhs.keySet().equals(rhs.keySet())) {
            return false;
        }
        return Util.doMapEqualityTets(lhs, rhs);
    }

    private static <V, K> boolean doMapEqualityTets(Map<K, V> lhs, Map<K, V> rhs) {
        for (Map.Entry<K, V> entry : lhs.entrySet()) {
            K key = entry.getKey();
            V lhsVal = entry.getValue();
            V rhsVal = rhs.get(key);
            if (lhsVal == null && rhsVal == null || lhsVal == rhsVal) continue;
            if (lhsVal == null || rhsVal == null) {
                return false;
            }
            if (lhsVal.equals(rhsVal)) continue;
            return false;
        }
        return true;
    }

    public static <T> boolean setsAreEqual(Set<T> lhs, Set<T> rhs) {
        if (lhs == rhs) {
            return true;
        }
        if (lhs == null) {
            return rhs == null;
        }
        if (rhs == null) {
            return false;
        }
        return lhs.size() == rhs.size() && lhs.containsAll(rhs) && rhs.containsAll(lhs);
    }

    public static final Range range(int min, int max) {
        return new Range(min, max);
    }

    public static final Range range(int max) {
        return new Range(0, max);
    }

    public static final void require(boolean condition) {
        Util.require(condition, "");
    }

    public static final void require(boolean condition, String message) {
        if (!condition) {
            throw new IllegalStateException("Condition not met: " + message);
        }
    }

    public static final void guardNotNull(Object o, String message) {
        Util.require(o != null, "Unexpected null value: " + message);
    }

    public static final void guardNotNull(Object o) {
        Util.guardNotNull(o, "");
    }

    public static final String concat(Object ... components) {
        if (components == null) {
            return "";
        }
        return Util.concat(Arrays.asList(components));
    }

    public static final String concat(Collection<? extends Object> components) {
        if (components == null) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        for (Object object : components) {
            result.append(object);
        }
        return result.toString();
    }

    public static final String uuid() {
        return UUID.randomUUID().toString();
    }

    public static final class Range
    implements Iterable<Integer> {
        private final int min;
        private final int max;

        public Range(int min, int max) {
            if (max < min) {
                throw new IllegalArgumentException("Max value must be greater or equal to minimum value");
            }
            this.min = min;
            this.max = max;
        }

        public int getMin() {
            return this.min;
        }

        public int getMax() {
            return this.max;
        }

        public int size() {
            return this.max - this.min;
        }

        public Range inclusive() {
            return new Range(this.min, this.max + 1);
        }

        @Override
        public Iterator<Integer> iterator() {
            return new Iterator<Integer>(){
                private int current;
                {
                    this.current = Range.this.min;
                }

                @Override
                public boolean hasNext() {
                    return this.current < Range.this.max;
                }

                @Override
                public Integer next() {
                    return this.current++;
                }

                @Override
                public void remove() {
                }
            };
        }

        public String toString() {
            return "[" + this.min + "," + this.max + ")";
        }
    }
}

